/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest.tester;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.commands.speedtest.SpeedTestPacketUtils;
import carpettisaddition.commands.speedtest.ping.PingHandler;
import carpettisaddition.commands.speedtest.ping.PongReceiver;
import carpettisaddition.commands.speedtest.tester.SpeedTesterBase;
import net.minecraft.class_2487;

public abstract class SpeedTesterPayloadSenderBase
extends SpeedTesterBase
implements PongReceiver {
    protected final int packetCount;
    private final PingHandler pingHandler = new PingHandler(this::abortCuzBadPongReceived);

    public SpeedTesterPayloadSenderBase(int testSizeMb) {
        super(testSizeMb);
        this.packetCount = SpeedTestPacketUtils.getPacketCount(testSizeMb);
    }

    @Override
    public void start() {
        super.start();
        for (int i = 0; i < Math.min(3, this.packetCount); ++i) {
            this.sendOnePacket();
        }
    }

    @Override
    protected void onContinue(int processedCount) {
        if (processedCount % 16 == 0 || processedCount == this.packetCount - 1) {
            this.sendPingPacket(this.pingHandler, (p, c) -> this.sendOnePacket());
        } else {
            this.sendOnePacket();
        }
    }

    @Override
    public void onPongReceived(class_2487 payload) {
        this.pingHandler.onPongReceived(payload);
    }

    protected void abortCuzBadPongReceived() {
        CarpetTISAdditionMod.LOGGER.warn("bad pong received, abort test");
        this.abort();
    }

    protected abstract void sendOnePacket();

    protected abstract void sendPingPacket(PingHandler var1, PingHandler.PongCallback var2);
}

