/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest.tester;

import carpettisaddition.commands.speedtest.SpeedTestReporter;
import carpettisaddition.commands.speedtest.session.SpeedTestServerSession;
import carpettisaddition.commands.speedtest.session.SpeedTestServerSessionHolder;
import carpettisaddition.commands.speedtest.session.SpeedTestSessionMessenger;
import carpettisaddition.commands.speedtest.tester.SpeedTesterBase;
import carpettisaddition.network.TISCMProtocol;
import carpettisaddition.network.TISCMServerPacketHandler;
import net.minecraft.class_3222;

public class SpeedTestServerUploadReceiver
extends SpeedTesterBase
implements SpeedTestServerSession {
    private final class_3222 player;
    private final SpeedTestServerSessionHolder serverSessionHolder;
    private final SpeedTestReporter reporter;

    public SpeedTestServerUploadReceiver(class_3222 player, int totalSizeMb, SpeedTestServerSessionHolder serverSessionHolder, SpeedTestReporter reporter) {
        super(totalSizeMb);
        this.player = player;
        this.serverSessionHolder = serverSessionHolder;
        this.reporter = reporter;
    }

    @Override
    public SpeedTestSessionMessenger getMessenger() {
        return this.reporter;
    }

    @Override
    public void start() {
        this.reporter.start(this.totalSize);
        super.start();
        TISCMServerPacketHandler.getInstance().sendPacket(this.player.field_13987, TISCMProtocol.S2C.SPEED_TEST_UPLOAD_REQUEST, nbt -> nbt.method_10569("size_mb", this.totalSizeMb));
        this.serverSessionHolder.setFor(this.player, this);
    }

    @Override
    public void abort() {
        super.abort();
        TISCMServerPacketHandler.getInstance().sendPacket(this.player.field_13987, TISCMProtocol.S2C.SPEED_TEST_ABORT, nbt -> {});
    }

    public void onC2SPayloadPacketReceived() {
        this.onPayloadDone();
    }

    @Override
    protected void onProgress(long sentBytes, long totalBytes) {
        this.reporter.onProgress(this.timer.getTimeElapsedNs(), sentBytes, totalBytes);
    }

    @Override
    protected void onDone(long timeCostNs) {
        this.reporter.reportDone(timeCostNs, this.processedSize.get(), this.totalSize);
        this.serverSessionHolder.clearFor(this.player, this);
    }
}

