/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest.ping;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.commands.speedtest.ping.PongReceiver;
import carpettisaddition.network.TISCMClientPacketHandler;
import carpettisaddition.network.TISCMProtocol;
import carpettisaddition.network.TISCMServerPacketHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2487;
import net.minecraft.class_3244;
import org.jetbrains.annotations.Nullable;

public class PingHandler
implements PongReceiver {
    private static final AtomicInteger MAGIC_COUNTER = new AtomicInteger(0);
    private final Random random = new Random();
    private final Map<Long, PingTask> pingTasks = new ConcurrentHashMap<Long, PingTask>();
    private final FailureCallback failureCallback;

    public PingHandler(@Nullable FailureCallback failureCallback) {
        this.failureCallback = failureCallback;
    }

    public void reset() {
        this.pingTasks.clear();
    }

    private void makePingPayload(class_2487 nbt, long magic) {
        nbt.method_10582("type", "ping");
        nbt.method_10544("magic", magic);
        nbt.method_10544("timestamp", System.nanoTime());
    }

    private long createMagic() {
        return (long)MAGIC_COUNTER.getAndIncrement() | (long)this.random.nextInt() << 32;
    }

    public void pingClient(class_3244 networkHandler, PongCallback pongCallback) {
        long magic = this.createMagic();
        this.pingTasks.put(magic, new PingTask(magic, pongCallback));
        TISCMServerPacketHandler.getInstance().sendPacket(networkHandler, TISCMProtocol.S2C.SPEED_TEST_PING, nbt -> this.makePingPayload((class_2487)nbt, magic));
    }

    public void pingServer(PongCallback pongCallback) {
        long magic = this.createMagic();
        this.pingTasks.put(magic, new PingTask(magic, pongCallback));
        TISCMClientPacketHandler.getInstance().sendPacket(TISCMProtocol.C2S.SPEED_TEST_PING, nbt -> this.makePingPayload((class_2487)nbt, magic));
    }

    @Override
    public void onPongReceived(class_2487 payload) {
        PingTask pingTask = this.readPongImpl(payload);
        if (pingTask != null && pingTask.pongCallback != null) {
            pingTask.pongCallback.onPongReceived(payload, pingTask.costNs);
        }
        if (pingTask == null && this.failureCallback != null) {
            this.failureCallback.onPongFailed();
        }
    }

    private PingTask readPongImpl(class_2487 payload) {
        String pingType = payload.method_10558("type");
        if (!pingType.equals("pong")) {
            CarpetTISAdditionMod.LOGGER.warn("bad ping type, found {}, should be pong", (Object)pingType);
            return null;
        }
        long magic = payload.method_10537("magic");
        PingTask pingTask = this.pingTasks.remove(magic);
        if (pingTask == null) {
            CarpetTISAdditionMod.LOGGER.warn("pong magic mismatch, received {}, should be in {}", (Object)magic, new ArrayList<Long>(this.pingTasks.keySet()));
            return null;
        }
        pingTask.costNs = System.nanoTime() - payload.method_10537("timestamp");
        return pingTask;
    }

    @FunctionalInterface
    public static interface FailureCallback {
        public void onPongFailed();
    }

    private static class PingTask {
        public final long magic;
        public final PongCallback pongCallback;
        public long costNs = -1L;

        public PingTask(long magic, PongCallback pongCallback) {
            this.magic = magic;
            this.pongCallback = pongCallback;
        }
    }

    @FunctionalInterface
    public static interface PongCallback {
        public void onPongReceived(class_2487 var1, long var2);
    }
}

