/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.raid;

import carpettisaddition.commands.AbstractTracker;
import carpettisaddition.commands.raid.RaidCommand;
import carpettisaddition.logging.loggers.raid.RaidLogger;
import carpettisaddition.utils.CounterUtil;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_3763;
import net.minecraft.class_3765;
import net.minecraft.class_5250;

public class RaidTracker
extends AbstractTracker {
    public static final RaidTracker INSTANCE = new RaidTracker();
    private int raidGeneratedCount;
    private final Map<class_1299<?>, Integer> raiderCounter = Maps.newLinkedHashMap();
    private final Map<RaidLogger.InvalidateReason, Integer> raidInvalidateCounter = Maps.newLinkedHashMap();

    public RaidTracker() {
        super("Raid");
    }

    public static RaidTracker getInstance() {
        return INSTANCE;
    }

    @Override
    protected void initTracker() {
        this.raidGeneratedCount = 0;
        this.raiderCounter.clear();
        this.raidInvalidateCounter.clear();
    }

    public void trackRaidInvalidated(RaidLogger.InvalidateReason reason) {
        if (this.isTracking()) {
            Integer count = this.raidInvalidateCounter.get((Object)reason);
            this.raidInvalidateCounter.put(reason, count == null ? 1 : count + 1);
        }
    }

    public void trackRaidGenerated(class_3765 raid) {
        if (this.isTracking()) {
            ++this.raidGeneratedCount;
        }
    }

    public void trackNewRaider(class_3763 raider) {
        if (this.isTracking()) {
            class_1299 key;
            Integer count = this.raiderCounter.get(key = raider.method_5864());
            this.raiderCounter.put(key, count == null ? 1 : count + 1);
        }
    }

    @Override
    protected void printTrackingResult(class_2168 source, boolean realtime) {
        long ticks = this.sendTrackedTime(source, realtime);
        ArrayList result = Lists.newArrayList();
        int raiderCountSum = this.raiderCounter.values().stream().mapToInt(Integer::intValue).sum();
        int invalidateCounterSum = this.raidInvalidateCounter.values().stream().mapToInt(Integer::intValue).sum();
        result.add(Messenger.c(this.tr("raid_generated", new Object[0]), "w : ", Messenger.s(CounterUtil.ratePerHour(this.raidGeneratedCount, ticks))));
        result.add(Messenger.c(RaidCommand.getInstance().getTranslator().tr("raiders", new Object[0]), "w : ", Messenger.s(CounterUtil.ratePerHour(raiderCountSum, ticks))));
        this.raiderCounter.forEach((raiderType, count) -> result.add(Messenger.c("g - ", Messenger.entityType(raiderType), String.format("w : %s, %.1f%%", CounterUtil.ratePerHour(count, ticks), (double)count.intValue() / (double)raiderCountSum * 100.0))));
        result.add(Messenger.c(this.tr("invalidate_reasons_statistics", new Object[0]), "w : ", this.raidInvalidateCounter.isEmpty() ? this.tr("none", new Object[0]) : Messenger.s("")));
        this.raidInvalidateCounter.forEach((reason, count) -> result.add(Messenger.c("g - ", reason.toText(), String.format("w : %s, %.1f%%", CounterUtil.ratePerHour(count, ticks), (double)count.intValue() / (double)invalidateCounterSum * 100.0))));
        Messenger.tell(source, (Iterable<class_5250>)result);
    }
}

