/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.utils;

import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.interfaces.LifetimeTrackerTarget;
import carpettisaddition.commands.lifetime.utils.LifetimeTexts;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class LifeTimeStatistic
extends TranslationContext {
    public static final String COLOR_MIN_TIME = "q ";
    public static final String COLOR_MAX_TIME = "c ";
    public static final String COLOR_AVG_TIME = "p ";
    public StatisticElement minTimeElement = new StatisticElement(Integer.MAX_VALUE, null, null, null);
    public StatisticElement maxTimeElement = new StatisticElement(Integer.MIN_VALUE, null, null, null);
    public long count = 0L;
    public long timeSum = 0L;

    public LifeTimeStatistic() {
        super(LifeTimeTracker.getInstance().getTranslator());
    }

    public boolean isValid() {
        return this.count > 0L;
    }

    public void update(class_1297 entity) {
        long time = ((LifetimeTrackerTarget)entity).getLifeTime();
        ++this.count;
        this.timeSum += time;
        StatisticElement element = new StatisticElement(time, DimensionWrapper.of(entity), ((LifetimeTrackerTarget)entity).getSpawningPosition(), ((LifetimeTrackerTarget)entity).getRemovalPosition());
        if (time < this.minTimeElement.time) {
            this.minTimeElement = element;
        }
        if (time > this.maxTimeElement.time) {
            this.maxTimeElement = element;
        }
    }

    public List<class_5250> getResult(String indentString, boolean showButton) {
        ArrayList result = Lists.newArrayList();
        Consumer<class_5250> f = text -> result.add(Messenger.c(Messenger.s(indentString), text));
        if (this.isValid()) {
            f.accept(this.minTimeElement.getTimeWithPos(this.tr("minimum_lifetime", new Object[0]), COLOR_MIN_TIME, showButton));
            f.accept(this.maxTimeElement.getTimeWithPos(this.tr("maximum_lifetime", new Object[0]), COLOR_MAX_TIME, showButton));
            f.accept(Messenger.c(this.tr("average_lifetime", new Object[0]), "g : ", COLOR_AVG_TIME + String.format("%.4f", (double)this.timeSum / (double)this.count), "g  gt"));
        } else {
            f.accept(Messenger.s((Object)"N/A", "g"));
        }
        return result;
    }

    public class_5250 getCompressedResult(boolean showGtSuffix) {
        if (!this.isValid()) {
            return Messenger.s((Object)"N/A", "g");
        }
        class_5250 text = Messenger.c(COLOR_MIN_TIME + this.minTimeElement.time, "g /", COLOR_MAX_TIME + this.maxTimeElement.time, "g /", COLOR_AVG_TIME + String.format("%.2f", (double)this.timeSum / (double)this.count));
        if (showGtSuffix) {
            text.method_10852((class_2561)Messenger.c("g  (gt)"));
        }
        return text;
    }

    public static class StatisticElement {
        private final long time;
        private final DimensionWrapper dimensionType;
        private final class_243 spawningPos;
        private final class_243 removalPos;

        private StatisticElement(long time, DimensionWrapper dimensionType, class_243 spawningPos, class_243 removalPos) {
            this.time = time;
            this.dimensionType = dimensionType;
            this.spawningPos = spawningPos;
            this.removalPos = removalPos;
        }

        private class_5250 getTimeWithPos(class_5250 hint, String fmt, boolean showButton) {
            class_5250 text = Messenger.c(hint, "g : ", fmt + this.time, "g  gt");
            if (showButton) {
                text = Messenger.join(Messenger.s(" "), text, LifetimeTexts.spawningPosButton(this.spawningPos, this.dimensionType), LifetimeTexts.removalPosButton(this.removalPos, this.dimensionType));
            }
            return text;
        }
    }
}

