/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime;

import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.filter.EntityFilterManager;
import carpettisaddition.commands.lifetime.removal.RemovalReason;
import carpettisaddition.commands.lifetime.spawning.SpawningReason;
import carpettisaddition.commands.lifetime.trackeddata.BasicTrackedData;
import carpettisaddition.commands.lifetime.trackeddata.ExperienceOrbTrackedData;
import carpettisaddition.commands.lifetime.trackeddata.ItemTrackedData;
import carpettisaddition.commands.lifetime.utils.LifeTimeTrackerUtil;
import carpettisaddition.commands.lifetime.utils.SpecificDetailMode;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_3218;
import net.minecraft.class_5250;

public class LifeTimeWorldTracker
extends TranslationContext {
    private final class_3218 world;
    private final Map<class_1299<?>, BasicTrackedData> dataMap = Maps.newHashMap();
    private long spawnStageCounter;

    public LifeTimeWorldTracker(class_3218 world) {
        super(LifeTimeTracker.getInstance().getTranslator());
        this.world = world;
    }

    public Map<class_1299<?>, BasicTrackedData> getDataMap() {
        return this.dataMap;
    }

    public void initTracker() {
        this.dataMap.clear();
    }

    private Optional<BasicTrackedData> getTrackedData(class_1297 entity) {
        if (LifeTimeTracker.getInstance().willTrackEntity(entity, true)) {
            return Optional.of(this.dataMap.computeIfAbsent(entity.method_5864(), e -> {
                if (entity instanceof class_1542) {
                    return new ItemTrackedData();
                }
                if (entity instanceof class_1303) {
                    return new ExperienceOrbTrackedData();
                }
                return new BasicTrackedData();
            }));
        }
        return Optional.empty();
    }

    public void onEntitySpawn(class_1297 entity, SpawningReason reason) {
        this.getTrackedData(entity).ifPresent(data -> data.updateSpawning(entity, reason));
    }

    public void onEntityRemove(class_1297 entity, RemovalReason reason) {
        this.getTrackedData(entity).ifPresent(data -> data.updateRemoval(entity, reason));
    }

    public void increaseSpawnStageCounter() {
        ++this.spawnStageCounter;
    }

    public long getSpawnStageCounter() {
        return this.spawnStageCounter;
    }

    private static List<class_5250> addIfEmpty(List<class_5250> list, class_5250 text) {
        if (list.isEmpty()) {
            list.add(text);
        }
        return list;
    }

    protected int print(class_2168 source, long ticks, class_1299<?> specificType, SpecificDetailMode detailMode) {
        BasicTrackedData specificData = this.dataMap.get(specificType);
        if (this.dataMap.isEmpty() || specificType != null && specificData == null || !LifeTimeTracker.getInstance().isTracking()) {
            return 0;
        }
        ArrayList result = Lists.newArrayList();
        result.add(Messenger.s(" "));
        result.add(Messenger.c(Messenger.formatting(Messenger.dimension(DimensionWrapper.of((class_1937)this.world)), class_124.field_1067, class_124.field_1065), String.format("g  (%s)", DimensionWrapper.of((class_1937)this.world).getIdentifier())));
        if (specificType == null) {
            this.printAll(ticks, result);
        } else {
            this.printSpecific(ticks, specificType, specificData, detailMode, result);
        }
        Messenger.tell(source, (Iterable<class_5250>)result);
        return 1;
    }

    private void printAll(long ticks, List<class_5250> result) {
        this.dataMap.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingLong(a -> ((BasicTrackedData)a.getValue()).getSpawningCount()))).forEach(entry -> {
            class_1299 entityType = (class_1299)entry.getKey();
            BasicTrackedData data = (BasicTrackedData)entry.getValue();
            ArrayList spawningHover = Lists.newArrayList();
            spawningHover.add(data.getSpawningCountText(ticks));
            if (data.hasSpawning()) {
                spawningHover.add(Messenger.formatting(this.tr("reasons_for_spawning", new Object[0]), "e"));
                spawningHover.addAll(data.getSpawningReasonsLines(ticks, false));
            }
            ArrayList removalHover = Lists.newArrayList();
            removalHover.add(data.getRemovalCountText(ticks));
            if (data.hasRemoval()) {
                removalHover.add(Messenger.formatting(this.tr("reasons_for_removal", new Object[0]), "r"));
                removalHover.addAll(data.getRemovalReasonsLines(ticks, false));
            }
            String currentCommandBase = String.format("/%s %s", LifeTimeTracker.getInstance().getCommandPrefix(), LifeTimeTrackerUtil.getEntityTypeDescriptor(entityType));
            result.add(Messenger.c("g - [", Messenger.fancy(null, Messenger.entityType(entityType), Messenger.c(this.tr("filter_info_header", new Object[0]), "w : ", EntityFilterManager.getInstance().getEntityFilterText(entityType), "g  / [G] ", EntityFilterManager.getInstance().getEntityFilterText(null), "w \n", this.tr("detail_hint", new Object[0])), new class_2558(class_2558.class_2559.field_11745, currentCommandBase)), "g ] ", Messenger.fancy(null, Messenger.c("e S", "g /", "r R"), Messenger.c(Messenger.formatting(this.tr("spawn_count", new Object[0]), "e"), "g  / ", Messenger.formatting(this.tr("removal_count", new Object[0]), "r")), null), "g : ", Messenger.fancy(null, Messenger.c("e " + data.getSpawningCount()), Messenger.join(Messenger.s("\n"), spawningHover), new class_2558(class_2558.class_2559.field_11745, String.format("%s %s", new Object[]{currentCommandBase, SpecificDetailMode.SPAWNING}))), "g /", Messenger.fancy(null, Messenger.c("r " + data.getRemovalCount()), Messenger.join(Messenger.s("\n"), removalHover), new class_2558(class_2558.class_2559.field_11745, String.format("%s %s", new Object[]{currentCommandBase, SpecificDetailMode.REMOVAL}))), "g , ", Messenger.fancy(null, Messenger.c("q L", "g : ", data.lifeTimeStatistic.getCompressedResult(true)), Messenger.c(Messenger.formatting(this.tr("lifetime_overview", new Object[0]), "q"), "w \n", Messenger.join(Messenger.s("\n"), data.lifeTimeStatistic.getResult("  ", false))), new class_2558(class_2558.class_2559.field_11745, String.format("%s %s", new Object[]{currentCommandBase, SpecificDetailMode.LIFETIME})))));
        });
    }

    private void printSpecific(long ticks, class_1299<?> specificType, BasicTrackedData specificData, SpecificDetailMode detailMode, List<class_5250> result) {
        boolean showRemoval;
        result.add(Messenger.c(Messenger.formatting(Messenger.c(this.tr("filter_info_header", new Object[0]), Messenger.s(": ")), "c"), EntityFilterManager.getInstance().getEntityFilterText(specificType), "g  / ", Messenger.fancy("g", Messenger.s("[G]"), EntityFilterManager.getInstance().getTranslator().tr("global", new Object[0]), null), "g  ", EntityFilterManager.getInstance().getEntityFilterText(null)));
        boolean showLifeTime = detailMode == null || detailMode == SpecificDetailMode.LIFETIME;
        boolean showSpawning = detailMode == null || detailMode == SpecificDetailMode.SPAWNING;
        boolean bl = showRemoval = detailMode == null || detailMode == SpecificDetailMode.REMOVAL;
        if (showSpawning) {
            result.add(specificData.getSpawningCountText(ticks));
        }
        if (showRemoval) {
            result.add(specificData.getRemovalCountText(ticks));
        }
        if (showLifeTime) {
            result.add(Messenger.fancy("q", this.tr("lifetime_overview", new Object[0]), this.tr("lifetime_explain", new Object[0]), null));
            result.addAll(specificData.lifeTimeStatistic.getResult("  ", true));
        }
        if (showSpawning) {
            result.add(Messenger.formatting(this.tr("reasons_for_spawning", new Object[0]), "e"));
            result.addAll(LifeTimeWorldTracker.addIfEmpty(specificData.getSpawningReasonsLines(ticks, true), Messenger.s((Object)"  N/A", "g")));
        }
        if (showRemoval) {
            result.add(Messenger.formatting(this.tr("reasons_for_removal", new Object[0]), "r"));
            result.addAll(LifeTimeWorldTracker.addIfEmpty(specificData.getRemovalReasonsLines(ticks, true), Messenger.s((Object)"  N/A", "g")));
        }
    }
}

