/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.textures;

import com.google.common.collect.Maps;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.textures.IIconCreator;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.Stitcher;
import com.mamiyaotaru.voxelmap.textures.TextureUtilLegacy;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1044;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class TextureAtlas
extends class_1044 {
    private final HashMap<String, Sprite> mapRegisteredSprites = Maps.newHashMap();
    private final HashMap<String, Sprite> mapUploadedSprites = Maps.newHashMap();
    private final String basePath;
    private final IIconCreator iconCreator;
    private final Sprite missingImage = new Sprite("missingno");
    private final Sprite failedImage = new Sprite("notfound");
    private Stitcher stitcher;

    public TextureAtlas(String basePath) {
        this(basePath, null);
    }

    public TextureAtlas(String basePath, IIconCreator iconCreator) {
        this.basePath = basePath;
        this.iconCreator = iconCreator;
    }

    private void initMissingImage() {
        int[] missingTextureData = new int[1];
        Arrays.fill(missingTextureData, 0);
        this.missingImage.setIconWidth(1);
        this.missingImage.setIconHeight(1);
        this.missingImage.setTextureData(missingTextureData);
        this.failedImage.copyFrom(this.missingImage);
        this.failedImage.setTextureData(missingTextureData);
    }

    public void method_4625(class_3300 manager) {
        if (this.iconCreator != null) {
            this.loadTextureAtlas(this.iconCreator);
        }
    }

    public void reset() {
        this.mapRegisteredSprites.clear();
        this.mapUploadedSprites.clear();
        this.initMissingImage();
        int glMaxTextureSize = RenderSystem.maxSupportedTextureSize();
        this.stitcher = new Stitcher(glMaxTextureSize, glMaxTextureSize, 0);
    }

    public void loadTextureAtlas(IIconCreator iconCreator) {
        this.reset();
        iconCreator.addIcons(this);
        this.stitch();
    }

    public void stitch() {
        for (Map.Entry<String, Sprite> entry : this.mapRegisteredSprites.entrySet()) {
            Sprite icon = entry.getValue();
            this.stitcher.addSprite(icon);
        }
        this.stitcher.doStitch();
        VoxelConstants.getLogger().info("Created: {}x{} {}-atlas", new Object[]{this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight(), this.basePath});
        TextureUtilLegacy.allocateTexture(this.method_4624(), this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight());
        int[] zeros = new int[this.stitcher.getCurrentImageWidth() * this.stitcher.getCurrentImageHeight()];
        Arrays.fill(zeros, 0);
        TextureUtilLegacy.uploadTexture(this.method_4624(), zeros, this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight());
        HashMap tempMapRegisteredSprites = Maps.newHashMap(this.mapRegisteredSprites);
        for (Sprite icon : this.stitcher.getStitchSlots()) {
            String iconName = icon.getIconName();
            tempMapRegisteredSprites.remove(iconName);
            this.mapUploadedSprites.put(iconName, icon);
            try {
                TextureUtilLegacy.uploadSubTexture(icon.getTextureData(), icon.getIconWidth(), icon.getIconHeight(), icon.getOriginX(), icon.getOriginY());
            }
            catch (Throwable var10) {
                class_128 crashReport = class_128.method_560((Throwable)var10, (String)"Stitching texture atlas");
                class_129 crashReportCategory = crashReport.method_562("Texture being stitched together");
                crashReportCategory.method_578("Atlas path", (Object)this.basePath);
                crashReportCategory.method_578("Sprite", (Object)icon);
                throw new class_148(crashReport);
            }
        }
        for (Sprite icon : tempMapRegisteredSprites.values()) {
            icon.copyFrom(this.missingImage);
        }
        this.mapRegisteredSprites.clear();
        this.missingImage.initSprite(this.getHeight(), this.getWidth(), 0, 0);
        this.failedImage.initSprite(this.getHeight(), this.getWidth(), 0, 0);
    }

    public void stitchNew() {
        for (Map.Entry<String, Sprite> entry : this.mapRegisteredSprites.entrySet()) {
            Sprite icon = entry.getValue();
            this.stitcher.addSprite(icon);
        }
        int oldWidth = this.stitcher.getCurrentImageWidth();
        int oldHeight = this.stitcher.getCurrentImageHeight();
        this.stitcher.doStitchNew();
        if (oldWidth == this.stitcher.getCurrentImageWidth() && oldHeight == this.stitcher.getCurrentImageHeight()) {
            OpenGL.glBindTexture(3553, this.field_5204);
        } else {
            VoxelConstants.getLogger().info("Resized to: {}x{} {}-atlas", new Object[]{this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight(), this.basePath});
            TextureUtilLegacy.allocateTexture(this.method_4624(), this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight());
            int[] zeros = new int[this.stitcher.getCurrentImageWidth() * this.stitcher.getCurrentImageHeight()];
            Arrays.fill(zeros, 0);
            TextureUtilLegacy.uploadTexture(this.method_4624(), zeros, this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight());
        }
        HashMap tempMapRegisteredSprites = Maps.newHashMap(this.mapRegisteredSprites);
        for (Sprite icon : this.stitcher.getStitchSlots()) {
            String iconName = icon.getIconName();
            tempMapRegisteredSprites.remove(iconName);
            this.mapUploadedSprites.put(iconName, icon);
            try {
                TextureUtilLegacy.uploadSubTexture(icon.getTextureData(), icon.getIconWidth(), icon.getIconHeight(), icon.getOriginX(), icon.getOriginY());
            }
            catch (Throwable var11) {
                class_128 crashReport = class_128.method_560((Throwable)var11, (String)"Stitching texture atlas");
                class_129 crashReportCategory = crashReport.method_562("Texture being stitched together");
                crashReportCategory.method_578("Atlas path", (Object)this.basePath);
                crashReportCategory.method_578("Sprite", (Object)icon);
                throw new class_148(crashReport);
            }
        }
        for (Sprite icon : tempMapRegisteredSprites.values()) {
            icon.copyFrom(this.missingImage);
        }
        this.mapRegisteredSprites.clear();
        this.missingImage.initSprite(this.getHeight(), this.getWidth(), 0, 0);
        this.failedImage.initSprite(this.getHeight(), this.getWidth(), 0, 0);
    }

    public Sprite getIconAt(float x, float y) {
        return this.mapUploadedSprites.entrySet().stream().map(stringSpriteEntry -> (Sprite)stringSpriteEntry.getValue()).filter(icon -> x >= (float)icon.originX && x < (float)(icon.originX + icon.width) && y >= (float)icon.originY && y < (float)(icon.originY + icon.height)).findFirst().orElse(this.missingImage);
    }

    public Sprite getAtlasSprite(String name) {
        Sprite icon = this.mapUploadedSprites.get(name);
        if (icon == null) {
            icon = this.missingImage;
        }
        return icon;
    }

    public Sprite getAtlasSpriteIncludingYetToBeStitched(String name) {
        Sprite icon = this.mapUploadedSprites.get(name);
        if (icon == null) {
            icon = this.mapRegisteredSprites.get(name);
        }
        if (icon == null) {
            icon = this.missingImage;
        }
        return icon;
    }

    public Sprite registerIconForResource(class_2960 resourceLocation, class_3300 resourceManager) {
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        Sprite icon = this.mapRegisteredSprites.get(resourceLocation.toString());
        if (icon == null) {
            icon = Sprite.spriteFromResourceLocation(resourceLocation);
            try {
                Optional entryResource = resourceManager.method_14486(resourceLocation);
                BufferedImage entryBufferedImage = TextureUtilLegacy.readBufferedImage(((class_3298)entryResource.get()).method_14482());
                icon.bufferedImageToIntData(entryBufferedImage);
                entryBufferedImage.flush();
            }
            catch (RuntimeException var6) {
                VoxelConstants.getLogger().error("Unable to parse metadata from " + String.valueOf(resourceLocation), (Throwable)var6);
            }
            catch (IOException var7) {
                VoxelConstants.getLogger().error("Using missing texture, unable to load " + String.valueOf(resourceLocation), (Throwable)var7);
            }
            this.mapRegisteredSprites.put(resourceLocation.toString(), icon);
        }
        return icon;
    }

    public Sprite registerIconForBufferedImage(String name, BufferedImage bufferedImage) {
        if (name != null && !name.isEmpty()) {
            Sprite icon = this.mapRegisteredSprites.get(name);
            if (icon == null) {
                icon = Sprite.spriteFromString(name);
                icon.bufferedImageToIntData(bufferedImage);
                bufferedImage.flush();
                for (Sprite existing : this.mapUploadedSprites.values()) {
                    if (!Arrays.equals(existing.imageData, icon.imageData)) continue;
                    this.registerMaskedIcon(name, existing);
                    return existing;
                }
                for (Sprite existing : this.mapRegisteredSprites.values()) {
                    if (!Arrays.equals(existing.imageData, icon.imageData)) continue;
                    this.registerMaskedIcon(name, existing);
                    return existing;
                }
                this.mapRegisteredSprites.put(name, icon);
            }
            return icon;
        }
        throw new IllegalArgumentException("Name cannot be null!");
    }

    public Sprite getMissingImage() {
        return this.missingImage;
    }

    public Sprite getFailedImage() {
        return this.failedImage;
    }

    public void registerFailedIcon(String name) {
        this.mapUploadedSprites.put(name, this.failedImage);
    }

    public void registerMaskedIcon(String name, Sprite originalIcon) {
        Sprite existingIcon = this.mapUploadedSprites.get(name);
        if (existingIcon == null) {
            existingIcon = this.mapRegisteredSprites.get(name);
        }
        if (existingIcon == null) {
            this.mapUploadedSprites.put(name, originalIcon);
        }
    }

    public int getWidth() {
        return this.stitcher.getCurrentWidth();
    }

    public int getHeight() {
        return this.stitcher.getCurrentHeight();
    }

    public int getImageWidth() {
        return this.stitcher.getCurrentImageWidth();
    }

    public int getImageHeight() {
        return this.stitcher.getCurrentImageHeight();
    }
}

