/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.fabricmod;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelmapSettingsChannelHandler;
import com.mamiyaotaru.voxelmap.VoxelmapWorldIdChannelHandler;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_7591;
import org.apache.logging.log4j.Level;
import org.joml.Matrix4fStack;

public class FabricModVoxelMap
implements ClientModInitializer {
    public static FabricModVoxelMap instance;
    private boolean initialized;

    public void onInitializeClient() {
        instance = this;
        new VoxelmapSettingsChannelHandler();
        new VoxelmapWorldIdChannelHandler();
    }

    public void lateInit() {
        this.initialized = true;
        VoxelConstants.getVoxelMapInstance().lateInit(true, false);
    }

    public void clientTick() {
        if (!this.initialized) {
            boolean OK;
            boolean bl = OK = VoxelConstants.getMinecraft().method_1478() != null && VoxelConstants.getMinecraft().method_1531() != null;
            if (OK) {
                this.lateInit();
            }
        }
        if (this.initialized) {
            VoxelConstants.getVoxelMapInstance().onTick();
        }
    }

    public void renderOverlay(class_332 drawContext) {
        if (!this.initialized) {
            this.lateInit();
        }
        try {
            VoxelConstants.getVoxelMapInstance().onTickInGame(drawContext);
        }
        catch (RuntimeException e) {
            VoxelConstants.getLogger().log(Level.ERROR, "Error while render overlay", (Throwable)e);
        }
    }

    public boolean onChat(class_2561 chat, class_7591 indicator) {
        return CommandUtils.checkForWaypoints(chat, indicator);
    }

    public boolean onSendChatMessage(String message) {
        if (message.startsWith("newWaypoint")) {
            CommandUtils.waypointClicked(message);
            return false;
        }
        if (message.startsWith("ztp")) {
            CommandUtils.teleport(message);
            return false;
        }
        return true;
    }

    public static void onRenderHand(float partialTicks, Matrix4fStack matrixStack, boolean beacons, boolean signs, boolean withDepth, boolean withoutDepth) {
        try {
            VoxelConstants.getVoxelMapInstance().getWaypointManager().renderWaypoints(partialTicks, matrixStack, beacons, signs, withDepth, withoutDepth);
        }
        catch (RuntimeException e) {
            VoxelConstants.getLogger().log(Level.ERROR, "Error while render waypoints", (Throwable)e);
        }
    }

    public void onShutDown() {
        VoxelConstants.getLogger().info("Saving all world maps");
        VoxelConstants.getVoxelMapInstance().getPersistentMap().purgeCachedRegions();
        VoxelConstants.getVoxelMapInstance().getMapOptions().saveAll();
        BiomeRepository.saveBiomeColors();
        long shutdownTime = System.currentTimeMillis();
        while (ThreadManager.executorService.getQueue().size() + ThreadManager.executorService.getActiveCount() > 0 && System.currentTimeMillis() - shutdownTime < 10000L) {
            Thread.onSpinWait();
        }
    }

    public void playerRunTeleportCommand(double x, double y, double z) {
        MapSettingsManager mapSettingsManager = VoxelConstants.getVoxelMapInstance().getMapOptions();
        String cmd = mapSettingsManager.serverTeleportCommand == null ? mapSettingsManager.teleportCommand : mapSettingsManager.serverTeleportCommand;
        cmd = cmd.replace("%p", VoxelConstants.getPlayer().method_5477().getString()).replace("%x", String.valueOf(x + 0.5)).replace("%y", String.valueOf(y)).replace("%z", String.valueOf(z + 0.5));
        VoxelConstants.getPlayer().field_3944.method_45731(cmd);
    }
}

