/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.Events;
import com.mamiyaotaru.voxelmap.Map;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.Radar;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSimple;
import com.mamiyaotaru.voxelmap.SettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.fabricmod.FabricModVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.packets.WorldIdC2S;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.DimensionManager;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.MapUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.WorldUpdateListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_8710;

public class VoxelMap
implements class_3302 {
    public static MapSettingsManager mapOptions;
    public static RadarSettingsManager radarOptions;
    private PersistentMapSettingsManager persistentMapOptions;
    private Map map;
    private IRadar radar;
    private IRadar radarSimple;
    private PersistentMap persistentMap;
    private SettingsAndLightingChangeNotifier settingsAndLightingChangeNotifier;
    private WorldUpdateListener worldUpdateListener;
    private ColorManager colorManager;
    private WaypointManager waypointManager;
    private DimensionManager dimensionManager;
    private class_638 world;
    private String worldName = "";
    private static String passMessage;
    private ArrayDeque<Runnable> runOnWorldSet = new ArrayDeque();

    VoxelMap() {
    }

    public void lateInit(boolean showUnderMenus, boolean isFair) {
        mapOptions = new MapSettingsManager();
        VoxelMap.mapOptions.showUnderMenus = showUnderMenus;
        radarOptions = new RadarSettingsManager();
        mapOptions.addSecondaryOptionsManager(radarOptions);
        this.persistentMapOptions = new PersistentMapSettingsManager();
        mapOptions.addSecondaryOptionsManager(this.persistentMapOptions);
        BiomeRepository.loadBiomeColors();
        this.colorManager = new ColorManager();
        this.waypointManager = new WaypointManager();
        this.dimensionManager = new DimensionManager();
        this.persistentMap = new PersistentMap();
        mapOptions.loadAll();
        try {
            if (isFair) {
                VoxelMap.radarOptions.radarAllowed = false;
                VoxelMap.radarOptions.radarMobsAllowed = false;
                VoxelMap.radarOptions.radarPlayersAllowed = false;
            } else {
                VoxelMap.radarOptions.radarAllowed = true;
                VoxelMap.radarOptions.radarMobsAllowed = true;
                VoxelMap.radarOptions.radarPlayersAllowed = true;
                this.radar = new Radar();
                this.radarSimple = new RadarSimple();
            }
        }
        catch (RuntimeException var4) {
            VoxelConstants.getLogger().error("Failed creating radar " + var4.getLocalizedMessage(), (Throwable)var4);
            VoxelMap.radarOptions.radarAllowed = false;
            VoxelMap.radarOptions.radarMobsAllowed = false;
            VoxelMap.radarOptions.radarPlayersAllowed = false;
            this.radar = null;
            this.radarSimple = null;
        }
        Events.initEvents(this);
        this.map = new Map();
        this.settingsAndLightingChangeNotifier = new SettingsAndLightingChangeNotifier();
        this.worldUpdateListener = new WorldUpdateListener();
        this.worldUpdateListener.addListener(this.map);
        this.worldUpdateListener.addListener(this.persistentMap);
        class_3304 resourceManager = (class_3304)VoxelConstants.getMinecraft().method_1478();
        resourceManager.method_14477((class_3302)this);
        this.apply((class_3300)resourceManager);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return synchronizer.method_18352((Object)class_3902.field_17274).thenRunAsync(() -> this.apply(manager), applyExecutor);
    }

    private void apply(class_3300 resourceManager) {
        this.waypointManager.onResourceManagerReload(resourceManager);
        if (this.radar != null) {
            this.radar.onResourceManagerReload(resourceManager);
        }
        if (this.radarSimple != null) {
            this.radarSimple.onResourceManagerReload(resourceManager);
        }
        this.colorManager.onResourceManagerReload(resourceManager);
    }

    public void onTickInGame(class_332 drawContext) {
        this.map.onTickInGame(drawContext);
        if (passMessage != null) {
            VoxelConstants.getMinecraft().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)passMessage));
            passMessage = null;
        }
    }

    public void onTick() {
        if (!Objects.equals(this.world, GameVariableAccessShim.getWorld())) {
            this.world = GameVariableAccessShim.getWorld();
            this.waypointManager.newWorld((class_1937)this.world);
            this.persistentMap.newWorld(this.world);
            if (this.world != null) {
                MapUtils.reset();
                ByteBuf wIdRequestBuf = Unpooled.buffer((int)3);
                wIdRequestBuf.writeByte(0);
                wIdRequestBuf.writeByte(42);
                wIdRequestBuf.writeByte(0);
                if (ClientPlayNetworking.canSend(WorldIdC2S.PACKET_ID)) {
                    ClientPlayNetworking.send((class_8710)new WorldIdC2S());
                }
                if (!this.worldName.equals(this.waypointManager.getCurrentWorldName())) {
                    this.worldName = this.waypointManager.getCurrentWorldName();
                }
                this.map.newWorld(this.world);
                while (!this.runOnWorldSet.isEmpty()) {
                    this.runOnWorldSet.removeFirst().run();
                }
            }
        }
        VoxelConstants.tick();
        this.persistentMap.onTick();
    }

    public static void checkPermissionMessages(class_2561 message) {
        String msg = TextUtils.asFormattedString(message);
        if ((msg = msg.replaceAll("\u00a7r", "")).contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d")) {
            VoxelMap.mapOptions.cavesAllowed = false;
            VoxelConstants.getLogger().info("Server disabled cavemapping.");
        }
        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e")) {
            VoxelMap.radarOptions.radarAllowed = false;
            VoxelMap.radarOptions.radarPlayersAllowed = false;
            VoxelMap.radarOptions.radarMobsAllowed = false;
            VoxelConstants.getLogger().info("Server disabled radar.");
        }
        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7f")) {
            VoxelMap.mapOptions.cavesAllowed = true;
            VoxelConstants.getLogger().info("Server enabled cavemapping.");
        }
        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a70")) {
            VoxelMap.radarOptions.radarAllowed = true;
            VoxelMap.radarOptions.radarPlayersAllowed = true;
            VoxelMap.radarOptions.radarMobsAllowed = true;
            VoxelConstants.getLogger().info("Server enabled radar.");
        }
    }

    public MapSettingsManager getMapOptions() {
        return mapOptions;
    }

    public RadarSettingsManager getRadarOptions() {
        return radarOptions;
    }

    public PersistentMapSettingsManager getPersistentMapOptions() {
        return this.persistentMapOptions;
    }

    public Map getMap() {
        return this.map;
    }

    public SettingsAndLightingChangeNotifier getSettingsAndLightingChangeNotifier() {
        return this.settingsAndLightingChangeNotifier;
    }

    public IRadar getRadar() {
        if (VoxelMap.radarOptions.showRadar) {
            if (VoxelMap.radarOptions.radarMode == 1) {
                return this.radarSimple;
            }
            if (VoxelMap.radarOptions.radarMode == 2) {
                return this.radar;
            }
        }
        return null;
    }

    public ColorManager getColorManager() {
        return this.colorManager;
    }

    public WaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    public DimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    public PersistentMap getPersistentMap() {
        return this.persistentMap;
    }

    public void setPermissions(boolean hasFullRadarPermission, boolean hasPlayersOnRadarPermission, boolean hasMobsOnRadarPermission, boolean hasCavemodePermission) {
        VoxelMap.radarOptions.radarAllowed = hasFullRadarPermission;
        VoxelMap.radarOptions.radarPlayersAllowed = hasPlayersOnRadarPermission;
        VoxelMap.radarOptions.radarMobsAllowed = hasMobsOnRadarPermission;
        VoxelMap.mapOptions.cavesAllowed = hasCavemodePermission;
    }

    public synchronized void newSubWorldName(final String name, final boolean fromServer) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                VoxelMap.this.waypointManager.setSubworldName(name, fromServer);
                VoxelMap.this.map.newWorldName();
            }
        };
        if (this.world == null) {
            this.runOnWorldSet.addLast(run);
        } else {
            run.run();
        }
    }

    public String getWorldSeed() {
        return this.waypointManager.getWorldSeed().isEmpty() ? VoxelConstants.getWorldByKey((class_5321<class_1937>)class_1937.field_25179).map(value -> Long.toString(((class_3218)value).method_8412())).orElse("") : this.waypointManager.getWorldSeed();
    }

    public void setWorldSeed(String newSeed) {
        this.waypointManager.setWorldSeed(newSeed);
    }

    public void sendPlayerMessageOnMainThread(String s) {
        passMessage = s;
    }

    public WorldUpdateListener getWorldUpdateListener() {
        return this.worldUpdateListener;
    }

    public void clearServerSettings() {
        VoxelMap.radarOptions.radarAllowed = true;
        VoxelMap.radarOptions.radarPlayersAllowed = true;
        VoxelMap.radarOptions.radarMobsAllowed = true;
        VoxelMap.mapOptions.cavesAllowed = true;
        VoxelMap.mapOptions.serverTeleportCommand = null;
        VoxelMap.mapOptions.worldmapAllowed = true;
        VoxelMap.mapOptions.minimapAllowed = true;
        VoxelMap.mapOptions.waypointsAllowed = true;
        VoxelMap.mapOptions.deathWaypointAllowed = true;
    }

    public void onPlayInit() {
    }

    public void onDisconnect() {
        this.clearServerSettings();
    }

    public void onConfigurationInit() {
        this.clearServerSettings();
    }

    public void onClientStopping() {
        FabricModVoxelMap.instance.onShutDown();
        ThreadManager.flushSaveQueue();
    }
}

