/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptBox;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptFakeBlock;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptLine;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptShape;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptSphere;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderHelper {
    public static final class_2960 BLOCK_ATLAS_TEXTURE = class_1059.field_5275;
    public static final class_1921 CULL_BLOCK_LAYER = class_1921.method_23689((class_2960)BLOCK_ATLAS_TEXTURE);
    public static final class_1921 NO_CULL_BLOCK_LAYER = class_1921.method_23580((class_2960)BLOCK_ATLAS_TEXTURE);

    public static void drawScaledText(class_332 context, class_2561 text, int x, int y, float scale, boolean center) {
        class_310 client = EssentialUtils.getClient();
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 0.0);
        matrices.method_22905(scale, scale, 0.0f);
        if (center) {
            context.method_27534(client.field_1772, text, 0, 0, 0xFFFFFF);
        } else {
            context.method_27535(client.field_1772, text, 0, 0, 0xFFFFFF);
        }
        matrices.method_22909();
    }

    public static void renderAllShapes(class_4587 matrices) {
        RenderHelper.setupArucasRendering();
        RenderHelper.renderBoxes(matrices);
        RenderHelper.renderSpheres(matrices);
        RenderHelper.renderLines(matrices);
        RenderHelper.resetArucasRendering();
    }

    public static void setupArucasRendering() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
    }

    public static void resetArucasRendering() {
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderHelper.setPositionColourShader();
    }

    private static void renderBoxes(class_4587 matrices) {
        class_289 tessellator = class_289.method_1348();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        if (ScriptBox.hasRegular()) {
            RenderHelper.drawBoxOutlines(tessellator, matrices, cameraPos, ScriptBox::forEachRegular);
            RenderHelper.drawBoxes(tessellator, matrices, cameraPos, ScriptBox::forEachRegular);
        }
        if (ScriptBox.hasIgnoreDepth()) {
            RenderSystem.disableDepthTest();
            RenderHelper.drawBoxOutlines(tessellator, matrices, cameraPos, ScriptBox::forEachIgnoreDepth);
            RenderHelper.drawBoxes(tessellator, matrices, cameraPos, ScriptBox::forEachIgnoreDepth);
            RenderSystem.enableDepthTest();
        }
    }

    private static void drawBoxOutlines(class_289 tessellator, class_4587 matrices, class_243 camera, Consumer<Consumer<ScriptBox>> forEach) {
        RenderHelper.setLineShader();
        class_287 bufferBuilder = RenderHelper.startLines(tessellator);
        forEach.accept(box -> {
            if (box.getOutlineWidth() >= 1) {
                RenderSystem.lineWidth((float)box.getOutlineWidth());
                RenderHelper.addBoxToBuffer(bufferBuilder, matrices, camera, box, true);
            }
        });
    }

    private static void drawBoxes(class_289 tessellator, class_4587 matrices, class_243 cameraPos, Consumer<Consumer<ScriptBox>> forEach) {
        RenderHelper.setPositionColourShader();
        class_287 bufferBuilder = RenderHelper.startQuads(tessellator, class_290.field_1576);
        forEach.accept(box -> RenderHelper.addBoxToBuffer(bufferBuilder, matrices, cameraPos, box, false));
    }

    private static class_243 getMinimumPos(class_243 pos1, class_243 pos2) {
        return new class_243(Math.min(pos1.method_10216(), pos2.method_10216()), Math.min(pos1.method_10214(), pos2.method_10214()), Math.min(pos1.method_10215(), pos2.method_10215()));
    }

    private static void addBoxToBuffer(class_287 bufferBuilder, class_4587 matrices, class_243 cameraPos, ScriptBox box, boolean outline) {
        class_243 pos1 = box.getCornerA();
        class_243 pos2 = box.getCornerB();
        int red = box.getRed();
        int green = box.getGreen();
        int blue = box.getBlue();
        int alpha = box.getAlpha();
        if (outline) {
            red = box.getOutlineRed();
            green = box.getOutlineGreen();
            blue = box.getOutlineBlue();
            alpha = 255;
        }
        class_243 posOrigin = RenderHelper.getMinimumPos(pos1, pos2);
        matrices.method_22903();
        matrices.method_22904(posOrigin.method_10216() - cameraPos.method_10216(), posOrigin.method_10214() - cameraPos.method_10214(), posOrigin.method_10215() - cameraPos.method_10215());
        RenderHelper.tilt(matrices, box);
        RenderHelper.scale(matrices, box);
        RenderHelper.addBoxVertices(bufferBuilder, matrices, pos1, pos2, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f, outline);
        matrices.method_22909();
    }

    private static void addBoxVertices(class_287 bufferBuilder, class_4587 matrices, class_243 pos1, class_243 pos2, float red, float green, float blue, float alpha, boolean outline) {
        float c0 = -0.002f;
        float x1 = (float)(Math.abs(pos1.method_10216() - pos2.method_10216()) - (double)c0 + 1.0);
        float y1 = (float)(Math.abs(pos1.method_10214() - pos2.method_10214()) - (double)c0 + 1.0);
        float z1 = (float)(Math.abs(pos1.method_10215() - pos2.method_10215()) - (double)c0 + 1.0);
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f model = entry.method_23761();
        if (outline) {
            bufferBuilder.method_22918(model, c0, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22918(model, x1, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22918(model, c0, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 1.0f, 0.0f);
            bufferBuilder.method_22918(model, c0, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 1.0f, 0.0f);
            bufferBuilder.method_22918(model, c0, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 1.0f);
            bufferBuilder.method_22918(model, c0, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 1.0f);
            bufferBuilder.method_22918(model, x1, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 1.0f, 0.0f);
            bufferBuilder.method_22918(model, x1, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 1.0f, 0.0f);
            bufferBuilder.method_22918(model, x1, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, -1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22918(model, c0, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, -1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22918(model, c0, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 1.0f);
            bufferBuilder.method_22918(model, c0, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 1.0f);
            bufferBuilder.method_22918(model, c0, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, -1.0f, 0.0f);
            bufferBuilder.method_22918(model, c0, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, -1.0f, 0.0f);
            bufferBuilder.method_22918(model, c0, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22918(model, x1, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22918(model, x1, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, -1.0f);
            bufferBuilder.method_22918(model, x1, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, -1.0f);
            bufferBuilder.method_22918(model, c0, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22918(model, x1, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22918(model, x1, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 1.0f, 0.0f);
            bufferBuilder.method_22918(model, x1, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 1.0f, 0.0f);
            bufferBuilder.method_22918(model, x1, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 1.0f);
            bufferBuilder.method_22918(model, x1, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 1.0f);
            return;
        }
        bufferBuilder.method_22918(model, c0, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, c0, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, c0, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, c0, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, y1, z1).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22918(model, x1, y1, c0).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
    }

    private static void renderSpheres(class_4587 matrices) {
        class_289 tessellator = class_289.method_1348();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        if (ScriptSphere.hasRegular()) {
            RenderHelper.drawSpheresOutlines(tessellator, matrices, cameraPos, ScriptSphere::forEachRegular);
            RenderHelper.drawSpheres(tessellator, matrices, cameraPos, ScriptSphere::forEachRegular);
        }
        if (ScriptSphere.hasIgnoreDepth()) {
            RenderSystem.disableDepthTest();
            RenderHelper.drawSpheresOutlines(tessellator, matrices, cameraPos, ScriptSphere::forEachIgnoreDepth);
            RenderHelper.drawSpheres(tessellator, matrices, cameraPos, ScriptSphere::forEachIgnoreDepth);
            RenderSystem.enableDepthTest();
        }
    }

    private static void drawSpheresOutlines(class_289 tessellator, class_4587 matrices, class_243 camera, Consumer<Consumer<ScriptSphere>> forEach) {
        RenderHelper.setLineShader();
        class_287 bufferBuilder = RenderHelper.startLines(tessellator);
        forEach.accept(sphere -> {
            if (sphere.getOutlineWidth() >= 1) {
                RenderSystem.lineWidth((float)sphere.getOutlineWidth());
                RenderHelper.addSphereToBuffer(bufferBuilder, matrices, camera, sphere, true);
            }
        });
    }

    private static void drawSpheres(class_289 tessellator, class_4587 matrices, class_243 cameraPos, Consumer<Consumer<ScriptSphere>> forEach) {
        RenderHelper.setPositionColourShader();
        class_287 bufferBuilder = RenderHelper.startQuads(tessellator, class_290.field_1576);
        forEach.accept(sphere -> RenderHelper.addSphereToBuffer(bufferBuilder, matrices, cameraPos, sphere, false));
    }

    private static void addSphereToBuffer(class_287 bufferBuilder, class_4587 matrices, class_243 cameraPos, ScriptSphere sphere, boolean outline) {
        class_243 pos = sphere.getPosition();
        int red = sphere.getRed();
        int green = sphere.getGreen();
        int blue = sphere.getBlue();
        int alpha = sphere.getAlpha();
        if (outline) {
            red = sphere.getOutlineRed();
            green = sphere.getOutlineGreen();
            blue = sphere.getOutlineBlue();
            alpha = 255;
        }
        matrices.method_22903();
        matrices.method_22904(pos.method_10216() - cameraPos.method_10216(), pos.method_10214() - cameraPos.method_10214(), pos.method_10215() - cameraPos.method_10215());
        RenderHelper.tilt(matrices, sphere);
        RenderHelper.scale(matrices, sphere);
        RenderHelper.addSphereVertices(bufferBuilder, matrices, sphere.getWidth(), sphere.getSteps(), (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f, outline);
        matrices.method_22909();
    }

    private static void addSphereVertices(class_287 builder, class_4587 matrices, float radius, float steps, float red, float green, float blue, float alpha, boolean outline) {
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f model = entry.method_23761();
        float step = (float)(Math.PI * 2 / (double)steps);
        int halfSteps = (int)(Math.PI / (double)step) + 1;
        int totalSteps = (int)(Math.PI * 2 / (double)step);
        if (outline) {
            Vector3f normalVector;
            float y;
            float z;
            float x;
            for (int i = 0; i <= totalSteps; ++i) {
                float theta = step * (float)i;
                for (int j = 0; j <= totalSteps; ++j) {
                    float phi = step * (float)j;
                    x = radius * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                    z = radius * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                    y = radius * class_3532.method_15362((float)phi);
                    normalVector = new Vector3f(x, y, z);
                    normalVector.normalize();
                    builder.method_22918(model, x, y, z).method_22915(red, green, blue, alpha).method_60831(entry, normalVector.x, normalVector.y, normalVector.z);
                }
            }
            for (int j = 0; j <= totalSteps; ++j) {
                float phi = step * (float)j;
                for (int i = 0; i <= totalSteps; ++i) {
                    float theta = step * (float)i;
                    x = radius * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                    z = radius * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                    y = radius * class_3532.method_15362((float)phi);
                    normalVector = new Vector3f(x, y, z);
                    normalVector.normalize();
                    builder.method_22918(model, x, y, z).method_22915(red, green, blue, alpha).method_60831(entry, normalVector.x, normalVector.y, normalVector.z);
                }
            }
            return;
        }
        for (int i = 0; i <= totalSteps; ++i) {
            float theta = (float)i * step;
            float thetaPrime = theta + step;
            float xb = 0.0f;
            float zb = 0.0f;
            float xbp = 0.0f;
            float zbp = 0.0f;
            float yp = radius;
            for (int j = 0; j <= halfSteps; ++j) {
                float phi = (float)j * step;
                float x = radius * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                float z = radius * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                float y = radius * class_3532.method_15362((float)phi);
                float xp = radius * class_3532.method_15374((float)phi) * class_3532.method_15362((float)thetaPrime);
                float zp = radius * class_3532.method_15374((float)phi) * class_3532.method_15374((float)thetaPrime);
                builder.method_22918(model, xb, yp, zb).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
                builder.method_22918(model, xbp, yp, zbp).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
                builder.method_22918(model, xp, y, zp).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
                builder.method_22918(model, x, y, z).method_22915(red, green, blue, alpha).method_60831(entry, 0.0f, 0.0f, 0.0f);
                xb = x;
                zb = z;
                xbp = xp;
                zbp = zp;
                yp = y;
            }
        }
    }

    private static void renderLines(class_4587 matrices) {
        class_289 tessellator = class_289.method_1348();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        if (ScriptLine.hasRegular()) {
            RenderSystem.enableDepthTest();
            RenderHelper.drawLines(tessellator, matrices, cameraPos, ScriptLine::forEachRegular);
        }
        if (ScriptLine.hasIgnoreDepth()) {
            RenderSystem.disableDepthTest();
            RenderHelper.drawLines(tessellator, matrices, cameraPos, ScriptLine::forEachIgnoreDepth);
            RenderSystem.enableDepthTest();
        }
    }

    private static void drawLines(class_289 tessellator, class_4587 matrices, class_243 cameraPos, Consumer<Consumer<ScriptLine>> forEach) {
        RenderHelper.setLineShader();
        class_287 builder = RenderHelper.startLines(tessellator);
        forEach.accept(line -> {
            if (line.getOutlineWidth() >= 1) {
                RenderSystem.lineWidth((float)line.getOutlineWidth());
                RenderHelper.addLineToBuffer(builder, matrices, cameraPos, line);
            }
        });
    }

    private static void addLineToBuffer(class_287 builder, class_4587 matrices, class_243 cameraPos, ScriptLine line) {
        class_243 pos1 = line.getCornerA();
        class_243 pos2 = line.getCornerB();
        int red = line.getRed();
        int green = line.getGreen();
        int blue = line.getBlue();
        int alpha = line.getAlpha();
        matrices.method_22903();
        matrices.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        RenderHelper.tilt(matrices, line);
        RenderHelper.addLineVertices(builder, matrices, pos1.method_46409(), pos2.method_46409(), (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
        matrices.method_22909();
    }

    private static void addLineVertices(class_287 builder, class_4587 matrices, Vector3f pos1, Vector3f pos2, float red, float green, float blue, float alpha) {
        float dx = pos1.x - pos2.x;
        float dy = pos1.y - pos2.y;
        float dz = pos1.z - pos2.z;
        Vector3f normalVec = new Vector3f(dx, dy, dz);
        normalVec.normalize();
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f model = entry.method_23761();
        builder.method_22918(model, pos1.x, pos1.y, pos1.z).method_22915(red, green, blue, alpha).method_60831(entry, normalVec.x, normalVec.y, normalVec.z);
        builder.method_22918(model, pos2.x, pos2.y, pos2.z).method_22915(red, green, blue, alpha).method_60831(entry, normalVec.x, normalVec.y, normalVec.z);
    }

    public static void renderBlocks(class_4587 matrices) {
        class_310 client = EssentialUtils.getClient();
        class_4597.class_4598 immediate = client.method_22940().method_23000();
        ScriptFakeBlock.forEachRegular(f -> RenderHelper.renderFakeBlock(client, matrices, f, immediate));
        immediate.method_22994(NO_CULL_BLOCK_LAYER);
        immediate.method_22994(CULL_BLOCK_LAYER);
        ScriptFakeBlock.forEachIgnoreDepth(f -> RenderHelper.renderFakeBlock(client, matrices, f, immediate));
        immediate.method_22994(NO_CULL_BLOCK_LAYER);
        immediate.method_22994(CULL_BLOCK_LAYER);
    }

    private static void renderFakeBlock(class_310 client, class_4587 matrices, ScriptFakeBlock fakeBlock, class_4597.class_4598 immediate) {
        if (client.field_1687 == null) {
            return;
        }
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        class_243 pos = fakeBlock.getPosition();
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        matrices.method_22904(pos.method_10216() - cameraPos.field_1352, pos.method_10214() - cameraPos.field_1351, pos.method_10215() - cameraPos.field_1350);
        if (fakeBlock.getDirection() == null) {
            matrices.method_22907(client.field_1773.method_19418().method_23767());
            matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        } else {
            switch (fakeBlock.getDirection()) {
                case field_11035: {
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                    break;
                }
                case field_11034: {
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                    break;
                }
                case field_11039: {
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                    break;
                }
                case field_11036: {
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                    break;
                }
                case field_11033: {
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                }
            }
        }
        RenderHelper.tilt(matrices, fakeBlock);
        RenderHelper.scale(matrices, fakeBlock);
        matrices.method_22904(-0.5, -0.5, -0.5);
        class_2338 blockPos = EssentialUtils.vec3dToBlockPos(pos);
        int light = class_765.method_23687((int)client.field_1687.method_8314(class_1944.field_9282, blockPos), (int)client.field_1687.method_8314(class_1944.field_9284, blockPos));
        RenderHelper.renderBlockAsEntity(fakeBlock.getState(), matrices, (class_4597)immediate, (float)fakeBlock.getAlpha() / 255.0f, light, class_4608.field_21444, fakeBlock.shouldCull());
        matrices.method_22909();
    }

    private static void tilt(class_4587 matrices, ScriptShape tiltable) {
        if (tiltable.getXTilt() != 0.0f) {
            matrices.method_22907(class_7833.field_40714.rotationDegrees(tiltable.getXTilt()));
        }
        if (tiltable.getYTilt() != 0.0f) {
            matrices.method_22907(class_7833.field_40716.rotationDegrees(tiltable.getYTilt()));
        }
        if (tiltable.getZTilt() != 0.0f) {
            matrices.method_22907(class_7833.field_40718.rotationDegrees(tiltable.getZTilt()));
        }
    }

    private static void scale(class_4587 matrices, ScriptShape scalable) {
        matrices.method_22905(scalable.getXScale(), scalable.getYScale(), scalable.getZScale());
    }

    public static void renderBlockAsEntity(class_2680 state, class_4587 matrices, class_4597 vertexConsumer, float alpha, int light, int overlay, boolean cull) {
        class_310 client = EssentialUtils.getClient();
        class_776 manager = client.method_1541();
        switch (state.method_26217()) {
            case field_11458: {
                class_1087 bakedModel = manager.method_3349(state);
                int i = client.method_1505().method_1697(state, null, null, 0);
                float red = (float)(i >> 16 & 0xFF) / 255.0f;
                float green = (float)(i >> 8 & 0xFF) / 255.0f;
                float blue = (float)(i & 0xFF) / 255.0f;
                class_1921 layer = cull ? CULL_BLOCK_LAYER : NO_CULL_BLOCK_LAYER;
                RenderHelper.renderBlock(matrices.method_23760(), vertexConsumer.getBuffer(layer), state, bakedModel, red, green, blue, alpha, light, overlay);
                break;
            }
            case field_11456: {
                manager.method_3353(state, matrices, vertexConsumer, light, overlay);
            }
        }
    }

    public static void renderBlock(class_4587.class_4665 entry, class_4588 vertexConsumer, class_2680 state, class_1087 bakedModel, float red, float green, float blue, float alpha, int light, int overlay) {
        class_5819 random = class_5819.method_43047();
        long seed = 42L;
        for (class_2350 direction : class_2350.values()) {
            random.method_43052(seed);
            RenderHelper.renderQuads(entry, vertexConsumer, red, green, blue, alpha, bakedModel.method_4707(state, direction, random), light, overlay);
        }
        random.method_43052(seed);
        RenderHelper.renderQuads(entry, vertexConsumer, red, green, blue, alpha, bakedModel.method_4707(state, null, random), light, overlay);
    }

    private static void renderQuads(class_4587.class_4665 entry, class_4588 vertexConsumer, float red, float green, float blue, float alpha, List<class_777> quads, int light, int overlay) {
        for (class_777 bakedQuad : quads) {
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            float a = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
            if (bakedQuad.method_3360()) {
                r = class_3532.method_15363((float)red, (float)0.0f, (float)1.0f);
                g = class_3532.method_15363((float)green, (float)0.0f, (float)1.0f);
                b = class_3532.method_15363((float)blue, (float)0.0f, (float)1.0f);
            }
            vertexConsumer.method_22919(entry, bakedQuad, r, g, b, a, light, overlay);
        }
    }

    public static class_287 startLines(class_289 tessellator) {
        return tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
    }

    public static class_287 startDebugLines(class_289 tessellator, class_293 format) {
        return tessellator.method_60827(class_293.class_5596.field_29344, format);
    }

    public static class_287 startQuads(class_289 tessellator, class_293 format) {
        return tessellator.method_60827(class_293.class_5596.field_27382, format);
    }

    public static void setLineShader() {
        RenderSystem.setShader(class_757::method_34535);
    }

    public static void setPositionColourShader() {
        RenderSystem.setShader(class_757::method_34540);
    }

    public static void setPositionTextureColourShader() {
        RenderSystem.setShader(class_757::method_34543);
    }

    public static void bindTexture(class_2960 texture) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }
}

