/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import me.senseiwells.arucas.utils.NetworkUtils;

public class MojangAPI {
    private static final String NAME_TO_UUID_LINK = "https://api.mojang.com/users/profiles/minecraft/";
    private static final String UUID_TO_NAME_LINK = "https://api.mojang.com/user/profile/";
    private static final Gson GSON = new Gson();
    private static Map<String, UUID> nameToUuidCache;
    private static Map<UUID, String> uuidToNameCache;
    private static Set<String> invalidNames;
    private static Set<UUID> invalidUuids;

    public static UUID getUuidFromName(String name) {
        UUID uuid;
        if (invalidNames != null && invalidNames.contains(name)) {
            return null;
        }
        if (nameToUuidCache != null && (uuid = nameToUuidCache.get(name)) != null) {
            return uuid;
        }
        String response = NetworkUtils.getStringFromUrl((String)(NAME_TO_UUID_LINK + name));
        JsonObject object = (JsonObject)GSON.fromJson(response, JsonObject.class);
        if (object == null || object.has("error")) {
            if (invalidNames == null) {
                invalidNames = new HashSet<String>();
            }
            invalidNames.add(name);
            return null;
        }
        uuid = UUID.fromString(MojangAPI.addDashes(object.get("id").getAsString()));
        if (nameToUuidCache == null) {
            nameToUuidCache = new WeakHashMap<String, UUID>();
        }
        if (uuidToNameCache == null) {
            uuidToNameCache = new WeakHashMap<UUID, String>();
        }
        nameToUuidCache.put(name, uuid);
        uuidToNameCache.put(uuid, name);
        return uuid;
    }

    public static String getNameFromUuid(UUID uuid) {
        String name;
        if (invalidUuids != null && invalidUuids.contains(uuid)) {
            return null;
        }
        if (uuidToNameCache != null && (name = uuidToNameCache.get(uuid)) != null) {
            return name;
        }
        String response = NetworkUtils.getStringFromUrl((String)(UUID_TO_NAME_LINK + uuid.toString()));
        JsonObject object = (JsonObject)GSON.fromJson(response, JsonObject.class);
        if (object == null || object.has("error")) {
            if (invalidUuids == null) {
                invalidUuids = new HashSet<UUID>();
            }
            invalidUuids.add(uuid);
            return null;
        }
        name = object.get("name").getAsString();
        if (nameToUuidCache == null) {
            nameToUuidCache = new WeakHashMap<String, UUID>();
        }
        if (uuidToNameCache == null) {
            uuidToNameCache = new WeakHashMap<UUID, String>();
        }
        nameToUuidCache.put(name, uuid);
        uuidToNameCache.put(uuid, name);
        return name;
    }

    private static String addDashes(String uuid) {
        StringBuilder builder = new StringBuilder(uuid);
        builder.insert(20, '-');
        builder.insert(16, '-');
        builder.insert(12, '-');
        builder.insert(8, '-');
        return builder.toString();
    }
}

