/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.misc;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.rule.impl.SimpleRule;
import me.senseiwells.essentialclient.utils.EssentialUtils;

public class WikiParser {
    public static String generateWiki() {
        StringBuilder builder = new StringBuilder(WikiParser.getWikiBase());
        WikiParser.addClientRules(builder);
        return builder.toString();
    }

    private static String getWikiBase() {
        Path wikiPath = Path.of("../docs/HomeBase.md", new String[0]);
        return Files.exists(wikiPath, new LinkOption[0]) ? EssentialUtils.throwAsUnchecked(() -> Files.readString(wikiPath)) : "# EssentialClient\n";
    }

    private static void addClientRules(StringBuilder builder) {
        builder.append("\n## Client Rules:\n");
        ClientRules.getClientRules().stream().sorted(Comparator.comparing(SimpleRule::getName)).forEach(r -> {
            builder.append("# ").append(r.getName()).append("\n");
            builder.append(r.getDescription()).append("\n");
            builder.append("- Category: ").append(r.getCategory()).append("\n");
            builder.append("- Type: ").append(r.getType().toString()).append("\n");
            builder.append("- Default Value: ").append(r.getDefaultValue()).append("\n\n");
        });
    }
}

