/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.misc;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;

public class Scheduler {
    private static final Int2ObjectOpenHashMap<Queue<FutureTask<?>>> TASKS = new Int2ObjectOpenHashMap();
    private static final Object LOCK = new Object();
    private static int tickCount = 0;

    public static void load() {
    }

    public static void schedule(int ticks, Runnable runnable) {
        Scheduler.schedule(ticks, Executors.callable(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> Future<V> schedule(int ticks, Callable<V> callable) {
        Object object = LOCK;
        synchronized (object) {
            if (ticks < 0) {
                throw new IllegalArgumentException("Cannot schedule a task in the past");
            }
            FutureTask<V> task = new FutureTask<V>(callable);
            Scheduler.addTask(tickCount + ticks, task);
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleLoop(int delay, int interval, int until, Runnable runnable) {
        Object object = LOCK;
        synchronized (object) {
            if (delay < 0 || interval < 0 || until < 0) {
                throw new IllegalArgumentException("Delay, interval or until ticks cannot be negative");
            }
            for (int delayModifier = tickCount + delay; delayModifier <= tickCount + until; delayModifier += interval) {
                Scheduler.addTask(delayModifier, new FutureTask<Object>(runnable, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTask(int ticks, FutureTask<?> task) {
        Object object = LOCK;
        synchronized (object) {
            ((Queue)TASKS.computeIfAbsent(ticks, k -> new ArrayDeque())).add(task);
        }
    }

    static {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            Object object = LOCK;
            synchronized (object) {
                Queue queue = (Queue)TASKS.remove(tickCount++);
                if (queue != null) {
                    queue.forEach(Runnable::run);
                    queue.clear();
                }
            }
        });
    }
}

