/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.inventory;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.ArucasFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.feature.CraftingSharedConstants;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptItemStack;
import me.senseiwells.essentialclient.utils.interfaces.IGhostRecipeBookWidget;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1728;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2596;
import net.minecraft.class_2855;
import net.minecraft.class_2863;
import net.minecraft.class_310;
import net.minecraft.class_3971;
import net.minecraft.class_3975;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_490;
import net.minecraft.class_492;
import net.minecraft.class_507;
import net.minecraft.class_5455;
import net.minecraft.class_636;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_8786;
import net.minecraft.class_9306;

public class InventoryUtils {
    public static class_1735 getItemSlot(class_746 playerEntity, class_1792 item) {
        class_1703 containerPlayer = playerEntity.field_7512;
        Predicate<class_1799> filterTotemStack = s -> s.method_7909() == item;
        class_1735 targetSlot = null;
        for (class_1735 slot : containerPlayer.field_7761) {
            class_1799 stack = slot.method_7677();
            if (stack.method_7960() || !filterTotemStack.test(stack)) continue;
            targetSlot = slot;
            break;
        }
        return targetSlot;
    }

    public static void swapItemToEquipmentSlot(class_746 playerEntity, class_1304 slotType, int sourceSlot) {
        if (sourceSlot != -1 && playerEntity.field_7512 == playerEntity.field_7498) {
            class_1723 container = playerEntity.field_7498;
            class_310 client = EssentialUtils.getClient();
            if (client.field_1761 == null) {
                return;
            }
            if (slotType == class_1304.field_6173) {
                int currentHotbarSlot = playerEntity.method_31548().field_7545;
                client.field_1761.method_2906(container.field_7763, sourceSlot, currentHotbarSlot, class_1713.field_7791, (class_1657)client.field_1724);
            } else if (slotType == class_1304.field_6171) {
                client.field_1761.method_2906(container.field_7763, sourceSlot, 40, class_1713.field_7791, (class_1657)client.field_1724);
            }
        }
    }

    public static void dropAllItemType(class_1792 item) {
        class_746 player = EssentialUtils.getPlayer();
        class_636 interactionManager = EssentialUtils.getInteractionManager();
        class_1703 containerPlayer = player.field_7512;
        for (class_1735 slot : containerPlayer.field_7761) {
            class_1799 stack = slot.method_7677();
            if (stack.method_7909() != item) continue;
            interactionManager.method_2906(containerPlayer.field_7763, slot.field_7874, 1, class_1713.field_7795, (class_1657)player);
        }
    }

    public static void dropAllItemExact(class_1799 test) {
        class_746 player = EssentialUtils.getPlayer();
        class_636 interactionManager = EssentialUtils.getInteractionManager();
        class_1703 containerPlayer = player.field_7512;
        for (class_1735 slot : containerPlayer.field_7761) {
            class_1799 stack = slot.method_7677();
            if (!class_1799.method_31577((class_1799)stack, (class_1799)test)) continue;
            interactionManager.method_2906(containerPlayer.field_7763, slot.field_7874, 1, class_1713.field_7795, (class_1657)player);
        }
    }

    public static int isSlotInHotbar(class_1703 screenHandler, int slotNum) {
        int totalSize = screenHandler.field_7761.size();
        if (screenHandler instanceof class_1723) {
            return slotNum == 45 ? 40 : (slotNum >= 36 ? slotNum - 36 : -1);
        }
        return slotNum >= totalSize - 10 ? slotNum - (totalSize - 9) : -1;
    }

    private static boolean canMergeIntoMain(class_1661 inventory, class_1799 stack) {
        int count = stack.method_7947();
        for (int i = 0; i < inventory.field_7547.size(); ++i) {
            class_1799 itemStack = (class_1799)inventory.field_7547.get(i);
            if (itemStack.method_7960()) {
                return true;
            }
            if (itemStack.method_7909() != stack.method_7909() || (count -= itemStack.method_7914() - itemStack.method_7947()) > 0) continue;
            return true;
        }
        return false;
    }

    public static void tryMoveItemsToCraftingGridSlots(class_1799[] itemStacks, class_1703 screenHandler) {
        int numSlots = screenHandler.field_7761.size();
        if (9 < numSlots) {
            InventoryUtils.clearCraftingGridOfItems(itemStacks, screenHandler);
            class_1735 slotGridFirst = screenHandler.method_7611(1);
            Map<class_1792, List<Integer>> ingredientSlots = InventoryUtils.getSlotsPerItem(itemStacks);
            for (Map.Entry<class_1792, List<Integer>> entry : ingredientSlots.entrySet()) {
                class_1799 ingredientReference = entry.getKey().method_7854();
                List<Integer> recipeSlots = entry.getValue();
                ArrayList<Integer> targetSlots = new ArrayList<Integer>();
                for (int s : recipeSlots) {
                    targetSlots.add(s + 1);
                }
                InventoryUtils.fillCraftingGrid(screenHandler, slotGridFirst, ingredientReference, targetSlots);
            }
        }
    }

    public static void clearCraftingGridOfItems(class_1799[] recipe, class_1703 handler) {
        int invSlots = handler.field_7761.size();
        int i = 0;
        for (int slotNum = 1; i < 9 && slotNum < invSlots; ++i, ++slotNum) {
            EssentialUtils.throwAsUnchecked(() -> Thread.sleep(0L, 1));
            class_1735 slotTmp = handler.method_7611(slotNum);
            if (slotTmp == null || !slotTmp.method_7681() || InventoryUtils.areStacksEqual(recipe[i], slotTmp.method_7677())) continue;
            InventoryUtils.shiftClickSlot(handler, slotNum);
            if (!slotTmp.method_7681()) continue;
            InventoryUtils.dropStack(handler, slotNum);
        }
    }

    private static void fillCraftingGrid(class_1703 screenHandler, class_1735 slotGridFirst, class_1799 ingredientReference, List<Integer> targetSlots) {
        int slotNum;
        class_746 player = EssentialUtils.getPlayer();
        if (player == null) {
            return;
        }
        int slotReturn = -1;
        if (ingredientReference.method_7960()) {
            return;
        }
        while ((slotNum = InventoryUtils.matchSlot(screenHandler, slotGridFirst, ingredientReference)) >= 0) {
            if (slotReturn == -1) {
                slotReturn = slotNum;
            }
            InventoryUtils.leftClickSlot(screenHandler, slotNum);
            class_1799 stackCursor = InventoryUtils.getCursorStack();
            if (!InventoryUtils.areStacksEqual(ingredientReference, stackCursor)) break;
            int sizeOrig = stackCursor.method_7947();
            InventoryUtils.dragSplitItemsIntoSlots(screenHandler, targetSlots);
            stackCursor = InventoryUtils.getCursorStack();
            if (!stackCursor.method_7960()) {
                if (stackCursor.method_7947() >= sizeOrig) break;
                InventoryUtils.leftClickSlot(screenHandler, slotReturn);
                if (!InventoryUtils.getCursorStack().method_7960()) {
                    slotReturn = slotNum;
                    InventoryUtils.leftClickSlot(screenHandler, slotReturn);
                }
            }
            if (InventoryUtils.getCursorStack().method_7960()) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.getCursorStack().method_7960()) {
            InventoryUtils.leftClickSlot(screenHandler, slotNum);
        }
    }

    private static void dragSplitItemsIntoSlots(class_1703 handler, List<Integer> targetSlots) {
        int slotNum;
        class_746 player = EssentialUtils.getPlayer();
        if (player == null) {
            return;
        }
        class_1799 stackInCursor = InventoryUtils.getCursorStack();
        if (stackInCursor.method_7960()) {
            return;
        }
        if (targetSlots.size() == 1) {
            InventoryUtils.leftClickSlot(handler, targetSlots.get(0));
            return;
        }
        int numSlots = handler.field_7761.size();
        InventoryUtils.craftClickSlot(handler, -999, 0);
        Iterator<Integer> iterator = targetSlots.iterator();
        while (iterator.hasNext() && (slotNum = iterator.next().intValue()) < numSlots) {
            InventoryUtils.craftClickSlot(handler, slotNum, 1);
        }
        InventoryUtils.craftClickSlot(handler, -999, 2);
    }

    public static boolean areStacksEqual(class_1799 stack1, class_1799 stack2) {
        return !stack1.method_7960() && stack1.method_7909() == stack2.method_7909();
    }

    public static boolean areStacksTotallyEqual(class_1799 stack1, class_1799 stack2) {
        return !stack1.method_7960() && class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    private static int matchSlot(class_1703 container, class_1735 slotReference, class_1799 stackReference) {
        int slotNum = -1;
        int largest = 0;
        for (class_1735 slot : container.field_7761) {
            int stackSize;
            if (slot.field_7871 == slotReference.field_7871 || !slot.method_7681() || !InventoryUtils.areStacksEqual(stackReference, slot.method_7677()) || (stackSize = slot.method_7677().method_7947()) <= largest) continue;
            slotNum = slot.field_7874;
            largest = stackSize;
        }
        return slotNum;
    }

    private static Map<class_1792, List<Integer>> getSlotsPerItem(class_1799[] stacks) {
        HashMap<class_1792, List<Integer>> mapSlots = new HashMap<class_1792, List<Integer>>();
        for (int i = 0; i < stacks.length; ++i) {
            class_1792 item = stacks[i].method_7909();
            if (item == class_1802.field_8162) continue;
            if (mapSlots.containsKey(item)) {
                ((List)mapSlots.get(item)).add(i);
                continue;
            }
            ArrayList<Integer> integerList = new ArrayList<Integer>();
            integerList.add(i);
            mapSlots.put(item, integerList);
        }
        return mapSlots;
    }

    public static void swapSlot(class_1703 screenHandler, int index, int secondIndex) {
        EssentialUtils.getInteractionManager().method_2906(screenHandler.field_7763, index, secondIndex, class_1713.field_7791, (class_1657)EssentialUtils.getPlayer());
    }

    public static void shiftClickSlot(class_1703 screen, int index) {
        EssentialUtils.getInteractionManager().method_2906(screen.field_7763, index, 0, class_1713.field_7794, (class_1657)EssentialUtils.getPlayer());
    }

    public static void leftClickSlot(class_1703 screen, int slotNum) {
        EssentialUtils.getInteractionManager().method_2906(screen.field_7763, slotNum, 0, class_1713.field_7790, (class_1657)EssentialUtils.getPlayer());
    }

    public static void craftClickSlot(class_1703 screen, int slotNum, int mouseButton) {
        EssentialUtils.getInteractionManager().method_2906(screen.field_7763, slotNum, mouseButton, class_1713.field_7789, (class_1657)EssentialUtils.getPlayer());
    }

    public static void dropStack(class_1703 screen, int slotNum) {
        EssentialUtils.getInteractionManager().method_2906(screen.field_7763, slotNum, 0, class_1713.field_7795, (class_1657)EssentialUtils.getPlayer());
    }

    public static class_1799 getCursorStack() {
        return EssentialUtils.getPlayer().field_7512.method_34255();
    }

    public static boolean setCursorStack(class_1799 stack) {
        EssentialUtils.getPlayer().field_7512.method_34254(stack);
        return true;
    }

    public static class_1799 getStackAtSlot(class_1703 screenHandler, int slotId) {
        return ((class_1735)screenHandler.field_7761.get(slotId)).method_7677();
    }

    public static boolean areRecipesEqual(class_8786<?> recipe, class_8786<?> other) {
        if (recipe == null || other == null) {
            return false;
        }
        return recipe.comp_1932().equals((Object)other.comp_1932());
    }

    public static boolean areTradesEqual(class_1914 trade, class_1914 other) {
        return InventoryUtils.areStacksTotallyEqual(trade.method_8246(), other.method_8246()) && InventoryUtils.areStacksTotallyEqual(trade.method_57557().map(class_9306::comp_2427).orElse(class_1799.field_8037), other.method_57557().map(class_9306::comp_2427).orElse(class_1799.field_8037)) && InventoryUtils.areStacksTotallyEqual(trade.method_8250(), other.method_8250());
    }

    public static boolean isGridEmpty(class_1703 screenHandler, int gridLength) {
        boolean isEmpty = true;
        class_2371 slots = screenHandler.field_7761;
        for (int i = 0; i < gridLength; ++i) {
            isEmpty &= !((class_1735)slots.get(i + 1)).method_7681();
        }
        return isEmpty;
    }

    public static int getCraftingSlotLength(class_1703 handler) {
        if (handler instanceof class_1729) {
            class_1729 recipeScreen = (class_1729)handler;
            return recipeScreen.method_7656() * recipeScreen.method_7653();
        }
        return 0;
    }

    public static void emptyCraftingGrid(class_1703 screenHandler, class_1657 player, int gridSize) {
        class_2371 slots = player.field_7512.field_7761;
        for (int i = 1; i < gridSize + 1; ++i) {
            InventoryUtils.shiftClickSlot(screenHandler, i);
            if (((class_1735)slots.get(i)).method_7681()) {
                InventoryUtils.dropStack(screenHandler, i);
            }
            EssentialUtils.throwAsUnchecked(() -> Thread.sleep(0L, 1));
        }
    }

    public static void dropStackScheduled(class_1703 screenHandler, boolean craftAll) {
        CraftingSharedConstants.EXECUTOR.schedule(() -> {
            int count = craftAll ? 64 : 1;
            for (int i = 0; i < count; ++i) {
                EssentialUtils.getClient().execute(() -> InventoryUtils.dropStack(screenHandler, 0));
                EssentialUtils.throwAsUnchecked(() -> Thread.sleep(2L));
            }
        }, 40L, TimeUnit.MILLISECONDS);
    }

    public static void doCraftingSlotsFillAction(class_8786<?> recipe, class_465<?> handledScreen, boolean craftAll) {
        InventoryUtils.doCraftingSlotsFillAction(recipe, null, handledScreen, craftAll);
    }

    public static void doCraftingSlotsFillAction(class_8786<?> recipe, class_8786<?> lastRecipe, class_465<?> handledScreen, boolean craftAll) {
        class_507 widget;
        if (handledScreen instanceof class_490) {
            class_490 playerScreen = (class_490)handledScreen;
            widget = playerScreen.method_2659();
        } else if (handledScreen instanceof class_479) {
            class_479 craftingScreen = (class_479)handledScreen;
            widget = craftingScreen.method_2659();
        } else {
            return;
        }
        class_1703 handler = handledScreen.method_17577();
        class_746 player = EssentialUtils.getPlayer();
        int gridLength = InventoryUtils.getCraftingSlotLength(handler);
        if (!InventoryUtils.areRecipesEqual(recipe, lastRecipe) || !InventoryUtils.isGridEmpty(handler, gridLength) && InventoryUtils.getStackAtSlot(handler, 0).method_7960()) {
            InventoryUtils.emptyCraftingGrid(handler, (class_1657)player, gridLength);
        }
        class_1662 matcher = new class_1662();
        handler.field_7761.stream().skip(1L).map(class_1735::method_7677).forEachOrdered(arg_0 -> ((class_1662)matcher).method_7404(arg_0));
        IntArrayList craftInputIds = new IntArrayList();
        int totalCraftOps = matcher.method_7407(recipe, (IntList)craftInputIds);
        if (totalCraftOps == 0 && InventoryUtils.isGridEmpty(handler, gridLength)) {
            widget.method_2596(recipe, (List)player.field_7512.field_7761);
        } else {
            ((IGhostRecipeBookWidget)widget).essentialclient$clearGhostSlots();
            InventoryUtils.parseRecipeAndCacheInventory(handler, gridLength, recipe.comp_1933(), (IntList)craftInputIds, craftAll ? totalCraftOps : 1);
        }
        matcher.method_7409();
    }

    private static void parseRecipeAndCacheInventory(class_1703 screenHandler, int gridLength, class_1860<?> recipe, IntList craftInputIds, int craftOps) {
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            int gridSide = (int)Math.sqrt(gridLength);
            int recipeWidth = shapedRecipe.method_8150();
            int recipeHeight = shapedRecipe.method_8158();
            for (int i = 0; i < recipeHeight - 1; ++i) {
                for (int j = recipeWidth; j < gridSide; ++j) {
                    craftInputIds.add(i * gridSide + j, 0);
                }
            }
        }
        InventoryUtils.cacheInventoryAndFillGrid(craftInputIds, screenHandler, craftOps);
    }

    public static void cacheInventoryAndFillGrid(IntList craftInputIds, class_1703 screenHandler, int craftOps) {
        HashMap<Integer, IntList> inventoryCache = new HashMap<Integer, IntList>();
        HashMap<Integer, IntList> craftGridCache = new HashMap<Integer, IntList>();
        class_2371 slots = screenHandler.field_7761;
        int size = craftInputIds.size();
        for (int i = 0; i < size; ++i) {
            int slotId = craftInputIds.getInt(i);
            if (slotId == 0) continue;
            craftGridCache.computeIfAbsent(slotId, IntArrayList::new).add(i + 1);
        }
        for (class_1735 slot : slots) {
            int id = class_1662.method_7408((class_1799)slot.method_7677());
            if (!(slot.field_7871 instanceof class_1661) || id == 0) continue;
            inventoryCache.computeIfAbsent(id, IntArrayList::new).add(slot.field_7874);
        }
        InventoryUtils.fillCraftingGridWithItems(screenHandler, craftGridCache, inventoryCache, craftOps);
    }

    public static void fillCraftingGridWithItems(class_1703 screenHandler, Map<Integer, IntList> craftInputIds, Map<Integer, IntList> inventoryCache, int craftOps) {
        for (Integer itemId : craftInputIds.keySet()) {
            IntList craftInputSlotIds = craftInputIds.get(itemId);
            int recipeRequiredAmount = craftInputSlotIds.size();
            for (int i = 0; i < craftOps; ++i) {
                int endAt;
                int startAt = 0;
                int slotCounter = 0;
                IntList slotsPerItem = inventoryCache.get(itemId);
                if (slotsPerItem == null) continue;
                do {
                    int slotId = slotsPerItem.getInt(slotCounter);
                    int count = InventoryUtils.getStackAtSlot(screenHandler, slotId).method_7947();
                    endAt = Math.min(startAt + count, recipeRequiredAmount);
                    InventoryUtils.leftClickSlot(screenHandler, slotId);
                    InventoryUtils.dragSplitItemsIntoGrid(screenHandler, craftInputSlotIds, startAt, endAt);
                    if (InventoryUtils.getCursorStack().method_7960()) continue;
                    InventoryUtils.leftClickSlot(screenHandler, slotId);
                } while ((startAt = endAt) < recipeRequiredAmount && slotCounter++ < slotsPerItem.size());
            }
        }
    }

    public static void dragSplitItemsIntoGrid(class_1703 screenHandler, IntList craftingSlotIds, int startAt, int endAt) {
        InventoryUtils.craftClickSlot(screenHandler, -999, 4);
        for (int i = startAt; i < craftingSlotIds.size() && i < endAt; ++i) {
            int slotId = craftingSlotIds.getInt(i);
            InventoryUtils.craftClickSlot(screenHandler, slotId, 5);
        }
        InventoryUtils.craftClickSlot(screenHandler, -999, 6);
    }

    public static void craftRecipe(class_8786<?> recipe, boolean shouldDrop, boolean craftAll) {
        class_1703 handler = InventoryUtils.clickRecipe(recipe, craftAll);
        if (shouldDrop) {
            InventoryUtils.dropStackScheduled(handler, craftAll);
        } else {
            InventoryUtils.shiftClickSlot(handler, 0);
        }
    }

    public static class_1703 clickRecipe(class_8786<?> recipe, boolean craftAll) {
        class_437 class_4372 = EssentialUtils.getClient().field_1755;
        if (!(class_4372 instanceof class_465)) {
            throw new RuntimeError("Must be in a crafting GUI");
        }
        class_465 handledScreen = (class_465)class_4372;
        class_1703 handler = handledScreen.method_17577();
        CraftingSharedConstants.IS_SCRIPT_CLICK.set(true);
        EssentialUtils.getInteractionManager().method_2912(handler.field_7763, recipe, craftAll);
        return handler;
    }

    public static Object anvil(Interpreter interpreter, ArucasFunction predicate1, ArucasFunction predicate2, boolean takeItems) {
        boolean successful;
        class_746 player = EssentialUtils.getPlayer();
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof class_1706)) {
            throw new RuntimeError("Not in anvil gui");
        }
        class_1706 anvilHandler = (class_1706)class_17032;
        interpreter = interpreter.branch();
        class_636 interactionManager = EssentialUtils.getInteractionManager();
        boolean firstValid = false;
        boolean secondValid = false;
        for (class_1735 slot : anvilHandler.field_7761) {
            Boolean returnValue;
            if (firstValid && secondValid) break;
            List<ClassInstance> arguments = List.of(interpreter.create(ItemStackDef.class, (Object)new ScriptItemStack(slot.method_7677())));
            if (!firstValid && (returnValue = (Boolean)predicate1.invoke(interpreter.branch(), arguments).getPrimitive(BooleanDef.class)) != null && returnValue.booleanValue()) {
                firstValid = true;
                interactionManager.method_2906(anvilHandler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
                interactionManager.method_2906(anvilHandler.field_7763, 0, 0, class_1713.field_7790, (class_1657)player);
                continue;
            }
            if (secondValid || (returnValue = (Boolean)predicate2.invoke(interpreter.branch(), arguments).getPrimitive(BooleanDef.class)) == null || !returnValue.booleanValue()) continue;
            secondValid = true;
            interactionManager.method_2906(anvilHandler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
            interactionManager.method_2906(anvilHandler.field_7763, 1, 0, class_1713.field_7790, (class_1657)player);
        }
        anvilHandler.method_24928();
        if (anvilHandler.method_17369() > player.field_7520 && !player.method_7337()) {
            return anvilHandler.method_17369();
        }
        boolean bl = successful = firstValid && secondValid && anvilHandler.method_7611(2).method_7681();
        if (takeItems) {
            InventoryUtils.shiftClickSlot((class_1703)anvilHandler, 2);
        }
        return successful;
    }

    public static Object anvilRename(Interpreter interpreter, String newName, ArucasFunction predicate) {
        class_746 player = EssentialUtils.getPlayer();
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof class_1706)) {
            throw new RuntimeError("Not in anvil gui");
        }
        class_1706 anvilHandler = (class_1706)class_17032;
        interpreter = interpreter.branch();
        for (class_1735 slot : anvilHandler.field_7761) {
            class_1799 itemStack = slot.method_7677();
            if (itemStack.method_7964().getString().equals(newName)) continue;
            List<ClassInstance> args = List.of(interpreter.create(ItemStackDef.class, (Object)new ScriptItemStack(itemStack)));
            Boolean returnValue = (Boolean)predicate.invoke(interpreter.branch(), args).getPrimitive(BooleanDef.class);
            if (returnValue == null || !returnValue.booleanValue()) continue;
            InventoryUtils.shiftClickSlot((class_1703)anvilHandler, slot.field_7874);
            break;
        }
        anvilHandler.method_24928();
        anvilHandler.method_7625(newName);
        EssentialUtils.getNetworkHandler().method_52787((class_2596)new class_2855(newName));
        if (anvilHandler.method_17369() > player.field_7520 && !player.method_7337()) {
            return anvilHandler.method_17369();
        }
        if (anvilHandler.method_7611(2).method_7681()) {
            InventoryUtils.shiftClickSlot((class_1703)anvilHandler, 2);
            return true;
        }
        return false;
    }

    public static boolean stonecutter(class_1792 input, class_1792 output) {
        class_746 player = EssentialUtils.getPlayer();
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof class_3971)) {
            throw new RuntimeError("Not in stonecutter gui");
        }
        class_3971 cutterHandler = (class_3971)class_17032;
        boolean valid = false;
        for (class_1735 slot : cutterHandler.field_7761) {
            if (slot.method_7677().method_7909() != input) continue;
            InventoryUtils.shiftClickSlot((class_1703)cutterHandler, slot.field_7874);
            valid = true;
            break;
        }
        if (!valid) {
            return false;
        }
        List stonecuttingRecipes = cutterHandler.method_17863();
        for (int i = 0; i < stonecuttingRecipes.size(); ++i) {
            class_1799 result = ((class_3975)((class_8786)stonecuttingRecipes.get(i)).comp_1933()).method_8110((class_7225.class_7874)EssentialUtils.getRegistryManager());
            if (result.method_7909() != output) continue;
            cutterHandler.method_7604((class_1657)EssentialUtils.getPlayer(), i);
            EssentialUtils.getInteractionManager().method_2900(cutterHandler.field_7763, i);
            if (!cutterHandler.method_7611(1).method_7681()) continue;
            InventoryUtils.shiftClickSlot((class_1703)cutterHandler, 1);
            return true;
        }
        return false;
    }

    public static void tradeAllItems(int index, boolean dropItems) {
        class_1728 handler = InventoryUtils.checkScreen();
        class_1735 tradeSlot = handler.method_7611(2);
        do {
            InventoryUtils.selectTrade(handler, index);
            if (!tradeSlot.method_7681()) break;
            class_1799 tradeStack = tradeSlot.method_7677().method_7972();
            InventoryUtils.shiftClickSlot((class_1703)handler, tradeSlot.field_7874);
            if (!dropItems) continue;
            InventoryUtils.dropAllItemType(tradeStack.method_7909());
        } while (!tradeSlot.method_7681());
        InventoryUtils.clearTradeInputSlot(handler);
    }

    private static void selectTrade(class_1728 handler, int index) {
        handler.method_7650(index);
        handler.method_20215(index);
        EssentialUtils.getNetworkHandler().method_52787((class_2596)new class_2863(index));
    }

    public static void selectTrade(int index) {
        class_1728 handler = InventoryUtils.checkScreen();
        handler.method_7650(index);
        handler.method_20215(index);
        EssentialUtils.getNetworkHandler().method_52787((class_2596)new class_2863(index));
    }

    public static void tradeSelectedRecipe(boolean drop) {
        class_1728 screenHandler = InventoryUtils.checkScreen();
        class_1735 tradeSlot = screenHandler.method_7611(2);
        if (tradeSlot.method_7677().method_7947() == 0) {
            return;
        }
        if (drop) {
            EssentialUtils.getInteractionManager().method_2906(screenHandler.field_7763, 2, 1, class_1713.field_7795, (class_1657)EssentialUtils.getPlayer());
            return;
        }
        InventoryUtils.shiftClickSlot((class_1703)screenHandler, 2);
    }

    public static void clearTradeInputSlot(class_1728 handler) {
        class_1661 inventory = EssentialUtils.getPlayer().method_31548();
        class_1735 slot = handler.method_7611(0);
        if (slot.method_7681()) {
            if (InventoryUtils.canMergeIntoMain(inventory, slot.method_7677())) {
                InventoryUtils.shiftClickSlot((class_1703)handler, slot.field_7874);
            } else {
                InventoryUtils.dropStack((class_1703)handler, slot.field_7874);
            }
        }
        if (!(slot = handler.method_7611(1)).method_7681()) {
            return;
        }
        if (InventoryUtils.canMergeIntoMain(inventory, slot.method_7677())) {
            InventoryUtils.shiftClickSlot((class_1703)handler, slot.field_7874);
            return;
        }
        InventoryUtils.dropStack((class_1703)handler, slot.field_7874);
    }

    public static boolean checkTradeDisabled(int index) {
        class_1916 tradeOffers = InventoryUtils.checkScreen().method_17438();
        if (index > tradeOffers.size() - 1) {
            InventoryUtils.throwOutOfBounds();
        }
        return ((class_1914)tradeOffers.get(index)).method_8255();
    }

    public static int checkPriceForTrade(int index) {
        class_1916 tradeOffers = InventoryUtils.checkScreen().method_17438();
        if (index > tradeOffers.size() - 1) {
            InventoryUtils.throwOutOfBounds();
        }
        return ((class_1914)tradeOffers.get(index)).method_19272().method_7947();
    }

    public static boolean checkHasTrade(class_1792 item) {
        for (class_1914 offer : InventoryUtils.checkScreen().method_17438()) {
            if (offer.method_8250().method_7909() != item) continue;
            return true;
        }
        return false;
    }

    public static void clearTrade() {
        InventoryUtils.clearTradeInputSlot(InventoryUtils.checkScreen());
    }

    public static boolean isTradeSelected() {
        class_1735 tradeSlot = InventoryUtils.checkScreen().method_7611(2);
        return tradeSlot.method_7677().method_7947() != 0;
    }

    public static class_1799 getTrade(int index) {
        class_1916 tradeOffers = InventoryUtils.checkScreen().method_17438();
        if (index > tradeOffers.size() - 1) {
            InventoryUtils.throwOutOfBounds();
        }
        return ((class_1914)tradeOffers.get(index)).method_8250();
    }

    public static int getIndexOfItemInMerchant(class_1792 item) {
        int i = 0;
        for (class_1914 offer : InventoryUtils.checkScreen().method_17438()) {
            if (offer.method_8250().method_7909() == item) {
                return i;
            }
            ++i;
        }
        InventoryUtils.throwOutOfBounds();
        return -1;
    }

    private static class_1728 checkScreen() {
        class_437 class_4372 = EssentialUtils.getClient().field_1755;
        if (class_4372 instanceof class_492) {
            class_492 merchantScreen = (class_492)class_4372;
            return (class_1728)merchantScreen.method_17577();
        }
        throw new RuntimeError("Not in merchant screen");
    }

    private static void throwOutOfBounds() {
        throw new RuntimeError("That trade is out of bounds");
    }

    public static void clickCuttingRecipe(class_3975 cuttingRecipe) {
        class_437 class_4372 = EssentialUtils.getClient().field_1755;
        if (!(class_4372 instanceof class_465)) {
            throw new RuntimeError("Must be in a stonecutting GUI");
        }
        class_465 handledScreen = (class_465)class_4372;
        class_1703 handler = handledScreen.method_17577();
        if (!(handler instanceof class_3971)) {
            throw new RuntimeError("Must be in a stonecutting GUI");
        }
        class_3971 stonecutterScreenHandler = (class_3971)handler;
        CraftingSharedConstants.IS_SCRIPT_CLICK.set(true);
        List recipes = stonecutterScreenHandler.method_17863();
        int id = recipes.stream().filter(recipe -> {
            class_5455 access = EssentialUtils.getRegistryManager();
            return ((class_3975)recipe.comp_1933()).method_8110((class_7225.class_7874)access).method_7909() == cuttingRecipe.method_8110((class_7225.class_7874)access).method_7909();
        }).findFirst().map(recipes::indexOf).orElse(-1);
        stonecutterScreenHandler.method_7604((class_1657)EssentialUtils.getPlayer(), id);
    }

    public static void clickCuttingRecipe(class_1792 inputItem, class_1792 outputItem) {
        class_437 class_4372 = EssentialUtils.getClient().field_1755;
        if (!(class_4372 instanceof class_465)) {
            throw new RuntimeError("Must be in a stonecutting GUI");
        }
        class_465 handledScreen = (class_465)class_4372;
        class_1703 handler = handledScreen.method_17577();
        if (!(handler instanceof class_3971)) {
            throw new RuntimeError("Must be in a stonecutting GUI");
        }
        class_3971 stonecutterScreenHandler = (class_3971)handler;
        CraftingSharedConstants.IS_SCRIPT_CLICK.set(true);
        List recipes = stonecutterScreenHandler.method_17863();
        int id = recipes.stream().filter(recipe -> {
            class_5455 access = EssentialUtils.getRegistryManager();
            class_1792 result = ((class_3975)recipe.comp_1933()).method_8110((class_7225.class_7874)access).method_7909();
            return result == outputItem && ((class_3975)recipe.comp_1933()).method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(new class_1799((class_1935)inputItem)));
        }).findFirst().map(recipes::indexOf).orElse(-1);
        stonecutterScreenHandler.method_7604((class_1657)EssentialUtils.getPlayer(), id);
    }
}

