/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.interfaces;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import me.senseiwells.essentialclient.EssentialClient;

public interface Rule<T> {
    public String getName();

    public Type getType();

    public String getDescription();

    public String getOptionalInfo();

    public T getDefaultValue();

    public T getValue();

    public T fromJson(JsonElement var1);

    public JsonElement toJson(T var1);

    public List<RuleListener<T>> getListeners();

    public Rule<T> shallowCopy();

    public void setValueQuietly(T var1);

    public void setValueFromString(String var1);

    public void setOptionalInfo(String var1);

    default public String getCategory() {
        return null;
    }

    default public boolean changeable() {
        return true;
    }

    default public boolean isAvailable() {
        return true;
    }

    default public boolean display() {
        return true;
    }

    default public JsonElement getValueAsJson() {
        return this.toJson(this.getValue());
    }

    default public JsonElement getDefaultValueAsJson() {
        return this.toJson(this.getDefaultValue());
    }

    default public void addListener(RuleListener<T> ruleListener) {
        if (ruleListener != null) {
            this.getListeners().add(ruleListener);
        }
    }

    default public void setValue(T value) {
        if (!Objects.equals(this.getValue(), value)) {
            this.setValueQuietly(value);
            this.onValueChange();
        }
    }

    default public void onValueChange() {
        if (this.getListeners() != null) {
            for (RuleListener<Rule> ruleListener : this.getListeners()) {
                ruleListener.accept(this);
            }
        }
    }

    default public void setValueFromJson(JsonElement element) {
        this.setValue(this.fromJson(element));
    }

    default public void resetToDefault() {
        this.setValue(this.getDefaultValue());
    }

    default public boolean isNotDefault() {
        return !this.getValue().equals(this.getDefaultValue());
    }

    default public void logCannotSet(Object value) {
        EssentialClient.LOGGER.error("Cannot set the value '{}' for rule {}", value, (Object)this.getName());
    }

    @FunctionalInterface
    public static interface RuleListener<T>
    extends Consumer<Rule<T>> {
    }

    public static enum Type {
        BOOLEAN("Boolean", "boolean", Set.of(Boolean.TYPE, Boolean.class)),
        INTEGER("Integer", "int", Set.of(Integer.TYPE, Integer.class)),
        DOUBLE("Double", "double", Set.of(Double.TYPE, Double.class)),
        STRING("String", "string", Set.of(String.class)),
        CYCLE("Cycle"),
        SLIDER("Slider"),
        LIST("List"),
        NONE("None");

        private final String name;
        private final String alias;
        private final Set<Class<?>> classAliases;

        private Type(String string2, String alias, Set<Class<?>> classAliases) {
            this.name = string2;
            this.alias = alias;
            this.classAliases = classAliases;
        }

        private Type(String string2) {
            this(string2, string2.toLowerCase(), Set.of());
        }

        public static Type fromClass(Class<?> clazz) {
            for (Type type : Type.values()) {
                if (!type.classAliases.contains(clazz)) continue;
                return type;
            }
            return STRING;
        }

        public static Type fromString(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equalsIgnoreCase(name) && !type.alias.equals(name)) continue;
                return type;
            }
            return STRING;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface ListRule
    extends Rule<List<String>> {
        @Override
        default public List<String> fromJson(JsonElement value) {
            JsonArray array = value.getAsJsonArray();
            ArrayList<String> configData = new ArrayList<String>();
            for (JsonElement element : array) {
                configData.add(element.getAsString());
            }
            return configData;
        }

        @Override
        default public JsonElement toJson(List<String> value) {
            JsonArray array = new JsonArray();
            for (String string : value) {
                array.add(string);
            }
            return array;
        }

        @Override
        default public Type getType() {
            return Type.LIST;
        }

        public int getMaxLength();

        public void setMaxLength(int var1);
    }

    public static interface Cycle
    extends Rule<String> {
        public List<String> getCycleValues();

        public int getCurrentIndex();

        public void setCurrentIndex(int var1);

        default public int getMaxIndex() {
            return this.getCycleValues().size() - 1;
        }

        default public void cycleValues() {
            int currentIndex = this.getCurrentIndex();
            this.setCurrentIndex(currentIndex >= this.getMaxIndex() ? 0 : ++currentIndex);
            this.setValue(this.getCycleValues().get(this.getCurrentIndex()));
        }

        @Override
        default public Type getType() {
            return Type.CYCLE;
        }

        @Override
        default public JsonElement toJson(String value) {
            return new JsonPrimitive(value);
        }

        @Override
        default public String fromJson(JsonElement value) {
            return value.getAsString();
        }

        @Override
        default public void setValueFromString(String value) {
            this.setValue(value);
        }

        @Override
        default public void setValue(String value) {
            int index = this.getCycleValues().indexOf(value);
            if (index == -1) {
                this.logCannotSet(value);
                return;
            }
            this.setCurrentIndex(index);
            Rule.super.setValue(value);
        }

        @Override
        default public void resetToDefault() {
            Rule.super.resetToDefault();
            this.setCurrentIndex(0);
        }
    }

    public static interface Str
    extends Rule<String> {
        @Override
        default public Type getType() {
            return Type.STRING;
        }

        @Override
        default public String fromJson(JsonElement element) {
            return element.getAsString();
        }

        @Override
        default public JsonElement toJson(String value) {
            return new JsonPrimitive(value);
        }

        @Override
        default public void setValueFromString(String value) {
            this.setValue(value);
        }

        public int getMaxLength();

        public void setMaxLength(int var1);
    }

    public static interface Slider<T extends Number>
    extends Num<T> {
        public String getFormatted();

        public T getMin();

        public T getMax();

        public T getNewValue(double var1);

        public double getPercentage();

        default public void setFromPercentage(double percentage) {
            this.setValue(this.getNewValue(percentage));
        }

        @Override
        default public Type getType() {
            return Type.SLIDER;
        }
    }

    public static interface Num<T extends Number>
    extends Rule<T> {
        @Override
        public Type getType();

        @Override
        default public JsonElement toJson(T value) {
            return new JsonPrimitive(value);
        }
    }

    public static interface Bool
    extends Rule<Boolean> {
        default public void invert() {
            this.setValue((Boolean)this.getValue() == false);
        }

        @Override
        default public Type getType() {
            return Type.BOOLEAN;
        }

        @Override
        default public Boolean fromJson(JsonElement element) {
            return element.getAsBoolean();
        }

        @Override
        default public JsonElement toJson(Boolean value) {
            return new JsonPrimitive(value);
        }

        @Override
        default public void setValueFromString(String value) {
            this.setValue("true".equals(value));
        }
    }
}

