/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import me.senseiwells.essentialclient.utils.command.PlayerData;
import me.senseiwells.essentialclient.utils.command.WorldEnum;
import me.senseiwells.essentialclient.utils.config.MappedStringConfig;
import net.minecraft.class_1934;
import net.minecraft.class_2172;
import net.minecraft.class_241;
import net.minecraft.class_243;

public class ConfigPlayerClient
extends MappedStringConfig<PlayerData> {
    public static final ConfigPlayerClient INSTANCE = new ConfigPlayerClient();

    private ConfigPlayerClient() {
    }

    public CompletableFuture<Suggestions> suggestPlayer(SuggestionsBuilder builder) {
        return this.map.isEmpty() ? builder.buildFuture() : class_2172.method_9265(this.map.keySet(), (SuggestionsBuilder)builder);
    }

    @Override
    public String getConfigName() {
        return "PlayerClient";
    }

    @Override
    protected JsonElement valueToJson(PlayerData value) {
        JsonObject playerData = new JsonObject();
        playerData.addProperty("x", (Number)value.pos().field_1352);
        playerData.addProperty("y", (Number)value.pos().field_1351);
        playerData.addProperty("z", (Number)value.pos().field_1350);
        playerData.addProperty("yaw", (Number)Float.valueOf(value.rotation().field_1343));
        playerData.addProperty("pitch", (Number)Float.valueOf(value.rotation().field_1342));
        playerData.addProperty("dimension", value.world().name().toLowerCase());
        playerData.addProperty("gamemode", value.gamemode() == null ? "" : value.gamemode().method_8381());
        return playerData;
    }

    @Override
    protected PlayerData jsonToValue(String key, JsonElement valueElement) {
        JsonObject playerData = valueElement.getAsJsonObject();
        double x = playerData.get("x").getAsDouble();
        double y = playerData.get("y").getAsDouble();
        double z = playerData.get("z").getAsDouble();
        float yaw = playerData.get("yaw").getAsFloat();
        float pitch = playerData.get("pitch").getAsFloat();
        WorldEnum world = WorldEnum.valueOf(playerData.get("dimension").getAsString().toUpperCase());
        class_1934 gameMode = class_1934.method_8378((String)playerData.get("gamemode").getAsString(), null);
        return new PlayerData(new class_243(x, y, z), new class_241(yaw, pitch), world, gameMode);
    }
}

