/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.senseiwells.arucas.utils.FileUtils;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.utils.EssentialUtils;

public interface Config<T extends JsonElement> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();

    public String getConfigName();

    public Class<T> getJsonType();

    public JsonElement getSaveData();

    public void readConfig(T var1);

    default public void readConfig() {
        T element = this.getConfigData();
        if (element != null) {
            this.readConfig(element);
        }
    }

    default public Path getConfigPath() {
        return this.getConfigRootPath().resolve(this.getConfigName() + ".json");
    }

    default public Path getConfigRootPath() {
        Path root = EssentialUtils.getEssentialConfigFile();
        FileUtils.ensureExists((Path)root);
        return root;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public T getConfigData() {
        Path configPath = this.getConfigPath();
        if (!Files.isRegularFile(configPath, new LinkOption[0])) return null;
        try (BufferedReader reader = Files.newBufferedReader(configPath);){
            JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)reader, this.getJsonType());
            return (T)jsonElement;
        }
        catch (JsonParseException | IOException e) {
            EssentialClient.LOGGER.error("Failed to read '{}': {}", (Object)this.getConfigName(), (Object)e);
        }
        return null;
    }

    default public void saveConfig() {
        Path configPath = this.getConfigPath();
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            GSON.toJson(this.getSaveData(), (Appendable)writer);
        }
        catch (IOException e) {
            EssentialClient.LOGGER.error("Failed to save '{}': {}", (Object)this.getConfigName(), (Object)e);
        }
    }

    public static interface CMap
    extends Config<JsonObject> {
        @Override
        default public Class<JsonObject> getJsonType() {
            return JsonObject.class;
        }
    }

    public static interface CList
    extends Config<JsonArray> {
        @Override
        default public Class<JsonArray> getJsonType() {
            return JsonArray.class;
        }
    }
}

