/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.command.FakeCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2641;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class CommandHelper {
    private static final Map<UUID, Set<LiteralCommandNode<class_2168>>> FUNCTION_COMMAND_NODES = new ConcurrentHashMap<UUID, Set<LiteralCommandNode<class_2168>>>();
    public static final Set<String> CLIENT_COMMANDS = new HashSet<String>();
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.UK));
    private static class_2641 fakeCommandPacket;
    private static MethodHandle argumentHandle;

    public static CompletableFuture<Suggestions> suggestOnlinePlayers(SuggestionsBuilder builder) {
        class_634 networkHandler = EssentialUtils.getNetworkHandler();
        if (networkHandler == null || networkHandler.method_2880() == null) {
            return class_2172.method_9265(List.of(), (SuggestionsBuilder)builder);
        }
        ArrayList playerList = new ArrayList();
        networkHandler.method_2880().forEach(p -> playerList.add(p.method_2966().getName()));
        return class_2172.method_9253((String[])((String[])playerList.toArray(String[]::new)), (SuggestionsBuilder)builder);
    }

    public static boolean isClientCommand(String command) {
        if (CLIENT_COMMANDS.contains(command)) {
            return true;
        }
        for (Set<LiteralCommandNode<class_2168>> commandNodes : FUNCTION_COMMAND_NODES.values()) {
            for (LiteralCommandNode<class_2168> commandNode : commandNodes) {
                if (!commandNode.getLiteral().equals(command)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addComplexCommand(Interpreter interpreter, LiteralCommandNode<class_2168> commandNode) {
        if (interpreter.isRunning()) {
            Set commandNodeSet = FUNCTION_COMMAND_NODES.computeIfAbsent(interpreter.getProperties().getId(), id -> {
                interpreter.addStopEvent(() -> FUNCTION_COMMAND_NODES.remove(id));
                return ConcurrentHashMap.newKeySet();
            });
            commandNodeSet.add(commandNode);
        }
    }

    public static void registerFunctionCommands(CommandDispatcher<class_2168> dispatcher) {
        for (Set<LiteralCommandNode<class_2168>> commandNodes : FUNCTION_COMMAND_NODES.values()) {
            for (LiteralCommandNode<class_2168> commandNode : commandNodes) {
                dispatcher.getRoot().addChild(commandNode);
            }
        }
    }

    public static void clearClientCommands() {
        CLIENT_COMMANDS.clear();
    }

    public static void executeCommand(StringReader reader, String command) {
        class_746 player = EssentialUtils.getPlayer();
        try {
            player.field_3944.method_2886().execute(reader, (Object)new FakeCommandSource(player));
        }
        catch (CommandSyntaxException e) {
            EssentialUtils.sendMessage("\u00a7c" + e.getMessage());
            if (e.getInput() != null && e.getCursor() >= 0) {
                int cursor = Math.min(e.getCursor(), e.getInput().length());
                class_5250 text = class_2561.method_43470((String)"").method_27692(class_124.field_1080).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, command)));
                if (cursor > 10) {
                    text.method_27693("...");
                }
                text.method_27693(e.getInput().substring(Math.max(0, cursor - 10), cursor));
                if (cursor < e.getInput().length()) {
                    text.method_10852((class_2561)class_2561.method_43470((String)e.getInput().substring(cursor)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1073}));
                }
                text.method_10852((class_2561)class_2561.method_43471((String)"command.context.here").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                EssentialUtils.sendMessage((class_2561)text);
            }
        }
        catch (Exception e) {
            class_5250 error = class_2561.method_43470((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            EssentialUtils.getPlayer().method_7353((class_2561)class_2561.method_43471((String)"command.failed").method_27694(arg_0 -> CommandHelper.lambda$executeCommand$5((class_2561)error, arg_0)), false);
            e.printStackTrace();
        }
    }

    public static void setCommandPacket(class_2641 packet, class_7157 registryAccess) {
        if (packet == null) {
            return;
        }
        Collection commandNodes = packet.method_11403(registryAccess).getChildren();
        RootCommandNode newRootCommandNode = new RootCommandNode();
        for (CommandNode commandNode : commandNodes) {
            newRootCommandNode.addChild(commandNode);
        }
        fakeCommandPacket = new class_2641(newRootCommandNode);
    }

    public static class_2641 getCommandPacket() {
        return fakeCommandPacket;
    }

    public static Collection<ParsedArgument<?, ?>> getArguments(CommandContext<class_2168> context) {
        try {
            if (argumentHandle == null) {
                Field field = CommandContext.class.getDeclaredField("arguments");
                field.setAccessible(true);
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                argumentHandle = lookup.unreflectGetter(field);
            }
            Map parsedArgumentMap = argumentHandle.invokeExact(context);
            return parsedArgumentMap.values();
        }
        catch (Throwable throwable) {
            EssentialClient.LOGGER.error((Object)throwable);
            return null;
        }
    }

    private static /* synthetic */ class_2583 lambda$executeCommand$5(class_2561 error, class_2583 style) {
        return style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)error));
    }

    static {
        DECIMAL_FORMAT.setGroupingUsed(false);
    }
}

