/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.command;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_243;
import net.minecraft.class_638;

public class ClientEntitySelector {
    private final BiPredicate<class_243, class_1297> filter;
    private final BiConsumer<class_243, List<class_1297>> sorter;
    private final int limit;
    private final boolean senderOnly;
    private final Double originX;
    private final Double originY;
    private final Double originZ;
    private boolean isSingleTarget;

    public ClientEntitySelector(BiPredicate<class_243, class_1297> filter, BiConsumer<class_243, List<class_1297>> sorter, int limit, boolean senderOnly, Double originX, Double originY, Double originZ) {
        this.filter = filter;
        this.sorter = sorter;
        this.limit = limit;
        this.senderOnly = senderOnly;
        this.originX = originX;
        this.originY = originY;
        this.originZ = originZ;
    }

    public class_1297 getEntity(class_2168 source) throws CommandSyntaxException {
        List<class_1297> entities = this.getEntities(source);
        if (entities.isEmpty()) {
            throw class_2186.field_9863.create();
        }
        if (entities.size() > 1) {
            throw class_2186.field_9860.create();
        }
        return entities.get(0);
    }

    public List<class_1297> getEntities(class_2168 source) {
        class_243 origin = source.method_9222();
        origin = new class_243(this.originX == null ? origin.field_1352 : this.originX, this.originY == null ? origin.field_1351 : this.originY, this.originZ == null ? origin.field_1350 : this.originZ);
        if (this.senderOnly) {
            return this.filter.test(origin, source.method_9228()) ? Collections.singletonList(source.method_9228()) : Collections.emptyList();
        }
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        class_638 world = EssentialUtils.getWorld();
        if (world == null) {
            return List.of();
        }
        for (class_1297 entity : world.method_18112()) {
            if (!this.filter.test(origin, entity)) continue;
            entities.add(entity);
        }
        this.sorter.accept(origin, entities);
        return entities.size() <= this.limit ? entities : entities.subList(0, this.limit);
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isSingleTarget() {
        return this.isSingleTarget;
    }

    public void setSingleTarget(boolean isSingleTarget) {
        this.isSingleTarget = isSingleTarget;
    }
}

