/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import me.senseiwells.essentialclient.utils.command.ClientEntitySelector;
import me.senseiwells.essentialclient.utils.command.RegexArgumentType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2096;
import net.minecraft.class_2152;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2303;
import net.minecraft.class_2306;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ClientEntityArgumentType
implements ArgumentType<ClientEntitySelector> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "@e", "@e[type=foo]");
    private final boolean singleTarget;

    private ClientEntityArgumentType(boolean singleTarget) {
        this.singleTarget = singleTarget;
    }

    public static ClientEntityArgumentType entity() {
        return new ClientEntityArgumentType(true);
    }

    public static ClientEntityArgumentType entities() {
        return new ClientEntityArgumentType(false);
    }

    public static ClientEntitySelector getEntitySelector(CommandContext<class_2168> context, String arg) {
        return (ClientEntitySelector)context.getArgument(arg, ClientEntitySelector.class);
    }

    public static class_1297 getEntity(CommandContext<class_2168> context, String arg) throws CommandSyntaxException {
        return ((ClientEntitySelector)context.getArgument(arg, ClientEntitySelector.class)).getEntity((class_2168)context.getSource());
    }

    public static List<class_1297> getEntities(CommandContext<class_2168> context, String arg) {
        return ((ClientEntitySelector)context.getArgument(arg, ClientEntitySelector.class)).getEntities((class_2168)context.getSource());
    }

    public ClientEntitySelector parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        ClientEntitySelector ret = new Parser(reader).parse();
        ret.setSingleTarget(this.singleTarget);
        if (ret.getLimit() > 1 && this.singleTarget) {
            reader.setCursor(start);
            throw class_2186.field_9860.createWithContext((ImmutableStringReader)reader);
        }
        return ret;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof class_2172) {
            class_2172 source = (class_2172)object;
            StringReader reader = new StringReader(builder.getInput());
            reader.setCursor(builder.getStart());
            Parser parser = new Parser(reader);
            try {
                parser.parse();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            Collection suggestions = source.method_9262();
            suggestions.addAll(source.method_9269());
            return parser.listSuggestions(builder, (SuggestionsBuilder b) -> class_2172.method_9265((Iterable)suggestions, (SuggestionsBuilder)b));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static class Parser {
        private static final BiConsumer<class_243, List<class_1297>> UNSORTED = (origin, list) -> {};
        private static final BiConsumer<class_243, List<class_1297>> NEAREST = (origin, list) -> list.sort(Comparator.comparingDouble(entity -> entity.method_5707(origin)));
        private static final BiConsumer<class_243, List<class_1297>> FURTHEST = (origin, list) -> list.sort(Comparator.comparingDouble(entity -> -entity.method_5707(origin)));
        private static final BiConsumer<class_243, List<class_1297>> RANDOM = (origin, list) -> Collections.shuffle(list);
        private final StringReader reader;
        private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestor;
        private boolean playersOnly = false;
        private boolean playersOnlyForced = false;
        private BiPredicate<class_243, class_1297> filter = (origin, entity) -> true;
        private BiConsumer<class_243, List<class_1297>> sorter = UNSORTED;
        private int limit = Integer.MAX_VALUE;
        private boolean senderOnly = false;
        private Double originX = null;
        private Double originY = null;
        private Double originZ = null;
        private Double boxX = null;
        private Double boxY = null;
        private Double boxZ = null;
        private boolean hasName = false;
        private boolean hasDistance = false;
        private boolean hasXRotation = false;
        private boolean hasYRotation = false;
        private boolean hasLimit = false;
        private boolean hasSort = false;
        private boolean hasType = false;

        Parser(StringReader reader) {
            this.reader = reader;
        }

        ClientEntitySelector parse() throws CommandSyntaxException {
            this.suggestor = this::suggestStart;
            if (this.reader.canRead() && this.reader.peek() == '@') {
                this.parseAtSelector();
            } else {
                this.parsePlayerNameOrUuid();
            }
            if (this.boxX != null || this.boxY != null || this.boxZ != null) {
                boolean xNeg = this.boxX != null && this.boxX < 0.0;
                boolean yNeg = this.boxY != null && this.boxY < 0.0;
                boolean zNeg = this.boxZ != null && this.boxZ < 0.0;
                double xMin = xNeg ? this.boxX : 0.0;
                double yMin = yNeg ? this.boxY : 0.0;
                double zMin = zNeg ? this.boxZ : 0.0;
                double xMax = (xNeg || this.boxX == null ? 0.0 : this.boxX) + 1.0;
                double yMax = (yNeg || this.boxY == null ? 0.0 : this.boxY) + 1.0;
                double zMax = (zNeg || this.boxZ == null ? 0.0 : this.boxZ) + 1.0;
                this.addFilter((origin, entity) -> entity.method_23317() - origin.field_1352 >= xMin && entity.method_23317() - origin.field_1352 < xMax && entity.method_23318() - origin.field_1351 >= yMin && entity.method_23318() - origin.field_1351 < yMax && entity.method_23321() - origin.field_1350 >= zMin && entity.method_23321() - origin.field_1350 < zMax);
            }
            if (this.playersOnly || this.playersOnlyForced) {
                this.addFilter((origin, entity) -> entity instanceof class_1657);
            }
            return new ClientEntitySelector(this.filter, this.sorter, this.limit, this.senderOnly, this.originX, this.originY, this.originZ);
        }

        void parsePlayerNameOrUuid() throws CommandSyntaxException {
            int start;
            if (this.reader.canRead()) {
                start = this.reader.getCursor();
                this.suggestor = (builder, playerNameSuggestor) -> {
                    SuggestionsBuilder newBuilder = builder.createOffset(start);
                    playerNameSuggestor.accept(newBuilder);
                    builder.add(newBuilder);
                    return builder.buildFuture();
                };
            }
            start = this.reader.getCursor();
            String playerName = this.reader.readString();
            try {
                UUID uuid = UUID.fromString(playerName);
                this.filter = (origin, entity) -> entity.method_5667().equals(uuid);
                this.limit = 1;
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (playerName.isEmpty() || playerName.length() > 16) {
                    this.reader.setCursor(start);
                    throw class_2303.field_10875.createWithContext((ImmutableStringReader)this.reader);
                }
                this.playersOnlyForced = true;
                this.filter = (origin, entity) -> ((class_1657)entity).method_7334().getName().equals(playerName);
                this.limit = 1;
                return;
            }
        }

        void parseAtSelector() throws CommandSyntaxException {
            this.suggestor = (builder, playerNameSuggestor) -> this.suggestAtSelectors(builder.createOffset(builder.getStart() - 1), (Consumer<SuggestionsBuilder>)playerNameSuggestor);
            this.reader.skip();
            if (!this.reader.canRead()) {
                throw class_2303.field_10844.createWithContext((ImmutableStringReader)this.reader);
            }
            char type = this.reader.read();
            switch (type) {
                case 'p': {
                    this.playersOnly = true;
                    this.sorter = NEAREST;
                    this.limit = 1;
                    this.hasType = true;
                    break;
                }
                case 'a': {
                    this.playersOnly = true;
                    this.sorter = UNSORTED;
                    this.limit = Integer.MAX_VALUE;
                    this.hasType = true;
                    break;
                }
                case 'r': {
                    this.playersOnly = true;
                    this.sorter = RANDOM;
                    this.limit = 1;
                    break;
                }
                case 'e': {
                    this.playersOnly = false;
                    this.sorter = UNSORTED;
                    this.limit = Integer.MAX_VALUE;
                    break;
                }
                case 's': {
                    this.playersOnly = true;
                    this.sorter = UNSORTED;
                    this.limit = 1;
                    this.senderOnly = true;
                    this.addFilter((origin, entity) -> entity.method_5805());
                    break;
                }
                default: {
                    throw class_2303.field_10853.createWithContext((ImmutableStringReader)this.reader, (Object)("@" + type));
                }
            }
            this.suggestor = (builder, playerNameSuggest) -> {
                builder.suggest("[");
                return builder.buildFuture();
            };
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.reader.skip();
                this.reader.skipWhitespace();
                this.parseOptions();
            }
        }

        void parseOptions() throws CommandSyntaxException {
            this.suggestor = this::suggestOption;
            while (true) {
                int cursor = this.reader.getCursor();
                String optionName = this.reader.readString();
                Option option = Option.options.get(optionName);
                if (option == null) {
                    this.reader.setCursor(cursor);
                    throw class_2306.field_10885.createWithContext((ImmutableStringReader)this.reader, (Object)optionName);
                }
                if (!option.applicable(this)) {
                    this.reader.setCursor(cursor);
                    throw class_2306.field_10887.createWithContext((ImmutableStringReader)this.reader, (Object)optionName);
                }
                this.reader.skipWhitespace();
                if (!this.reader.canRead() || this.reader.read() != '=') {
                    this.reader.setCursor(cursor);
                    throw class_2303.field_10855.createWithContext((ImmutableStringReader)this.reader, (Object)optionName);
                }
                this.reader.skipWhitespace();
                this.suggestor = class_2303.field_10867;
                option.apply(this);
                this.reader.skipWhitespace();
                this.suggestor = (builder, playerNameSuggest) -> {
                    builder.suggest(",");
                    builder.suggest("]");
                    return builder.buildFuture();
                };
                if (!this.reader.canRead() || this.reader.peek() != ',' && this.reader.peek() != ']') {
                    throw class_2303.field_10837.createWithContext((ImmutableStringReader)this.reader);
                }
                char delimiter = this.reader.read();
                if (delimiter != ',') break;
                this.suggestor = this::suggestOption;
                this.reader.skipWhitespace();
            }
            this.suggestor = class_2303.field_10867;
        }

        boolean readNegationCharacter() {
            if (this.reader.canRead() && this.reader.peek() == '!') {
                this.reader.skip();
                this.reader.skipWhitespace();
                return true;
            }
            return false;
        }

        boolean readTagCharacter() {
            this.reader.skipWhitespace();
            if (this.reader.canRead() && this.reader.peek() == '#') {
                this.reader.skip();
                this.reader.skipWhitespace();
                return true;
            }
            return false;
        }

        void addFilter(BiPredicate<class_243, class_1297> filter) {
            BiPredicate<class_243, class_1297> prevFilter = this.filter;
            this.filter = (origin, entity) -> filter.test((class_243)origin, (class_1297)entity) && prevFilter.test((class_243)origin, (class_1297)entity);
        }

        CompletableFuture<Suggestions> listSuggestions(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> playerNameSuggestor) {
            return this.suggestor.apply(builder.createOffset(this.reader.getCursor()), playerNameSuggestor);
        }

        private CompletableFuture<Suggestions> suggestStart(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> playerNameSuggestor) {
            playerNameSuggestor.accept(builder);
            this.suggestAtSelectors(builder, playerNameSuggestor);
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestAtSelectors(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> playerNameSuggestor) {
            builder.suggest("@p", (Message)class_2561.method_43471((String)"argument.entity.selector.nearestPlayer"));
            builder.suggest("@a", (Message)class_2561.method_43471((String)"argument.entity.selector.allPlayers"));
            builder.suggest("@r", (Message)class_2561.method_43471((String)"argument.entity.selector.randomPlayer"));
            builder.suggest("@s", (Message)class_2561.method_43471((String)"argument.entity.selector.self"));
            builder.suggest("@e", (Message)class_2561.method_43471((String)"argument.entity.selector.allEntities"));
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestOption(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> playerNameSuggestor) {
            String arg = builder.getRemaining().toLowerCase(Locale.ROOT);
            Option.options.forEach((name, opt) -> {
                if (opt.applicable(this) && name.toLowerCase(Locale.ROOT).startsWith(arg)) {
                    builder.suggest(name + "=", (Message)opt.desc);
                }
            });
            return builder.buildFuture();
        }

        private static abstract class Option {
            static Map<String, Option> options = new HashMap<String, Option>();
            final class_2561 desc;

            private Option(String desc) {
                this.desc = class_2561.method_43471((String)desc);
            }

            abstract void apply(Parser var1) throws CommandSyntaxException;

            abstract boolean applicable(Parser var1);

            static {
                options.put("name", new Option("argument.entity.options.name.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        boolean neg = parser.readNegationCharacter();
                        if (parser.reader.canRead() && parser.reader.peek() == '/') {
                            Pattern regex = RegexArgumentType.parseSlashyRegex(parser.reader);
                            parser.addFilter((origin, entity) -> regex.matcher(entity.method_5477().getString()).matches() != neg);
                        } else {
                            String name = parser.reader.readString();
                            parser.addFilter((origin, entity) -> entity.method_5477().getString().equals(name) != neg);
                        }
                        if (!neg) {
                            parser.hasName = true;
                        }
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return !parser.hasName;
                    }
                });
                options.put("distance", new Option("argument.entity.options.distance.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        int cursor = parser.reader.getCursor();
                        class_2096.class_2099 range = class_2096.class_2099.method_9049((StringReader)parser.reader);
                        if (range.comp_1805().isPresent() && (Double)range.comp_1805().get() < 0.0 || range.comp_1806().isPresent() && (Double)range.comp_1806().get() < 0.0) {
                            parser.reader.setCursor(cursor);
                            throw class_2306.field_10890.createWithContext((ImmutableStringReader)parser.reader);
                        }
                        parser.hasDistance = true;
                        parser.addFilter((origin, entity) -> range.method_9045(entity.method_5707(origin)));
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return !parser.hasDistance;
                    }
                });
                options.put("x", new Option("argument.entity.options.x.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        parser.originX = parser.reader.readDouble();
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return parser.originX == null;
                    }
                });
                options.put("y", new Option("argument.entity.options.y.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        parser.originY = parser.reader.readDouble();
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return parser.originY == null;
                    }
                });
                options.put("z", new Option("argument.entity.options.z.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        parser.originZ = parser.reader.readDouble();
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return parser.originZ == null;
                    }
                });
                options.put("dx", new Option("argument.entity.options.dx.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        parser.boxX = parser.reader.readDouble();
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return parser.boxX == null;
                    }
                });
                options.put("dy", new Option("argument.entity.options.dy.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        parser.boxY = parser.reader.readDouble();
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return parser.boxY == null;
                    }
                });
                options.put("dz", new Option("argument.entity.options.dz.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        parser.boxZ = parser.reader.readDouble();
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return parser.boxZ == null;
                    }
                });
                options.put("x_rotation", new Option("argument.entity.options.x_rotation.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        float max;
                        class_2152 range = class_2152.method_9172((StringReader)parser.reader, (boolean)true, class_3532::method_15393);
                        float min = range.comp_1840() == null ? 0.0f : range.comp_1840().floatValue();
                        float f = max = range.comp_1841() == null ? 359.0f : range.comp_1841().floatValue();
                        if (max < min) {
                            parser.addFilter((origin, entity) -> entity.method_36455() >= min || entity.method_36455() <= max);
                        } else {
                            parser.addFilter((origin, entity) -> entity.method_36455() >= min && entity.method_36455() <= max);
                        }
                        parser.hasXRotation = true;
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return !parser.hasXRotation;
                    }
                });
                options.put("y_rotation", new Option("argument.entity.options.y_rotation.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        float max;
                        class_2152 range = class_2152.method_9172((StringReader)parser.reader, (boolean)true, class_3532::method_15393);
                        float min = range.comp_1840() == null ? 0.0f : range.comp_1840().floatValue();
                        float f = max = range.comp_1841() == null ? 359.0f : range.comp_1841().floatValue();
                        if (max < min) {
                            parser.addFilter((origin, entity) -> entity.method_36454() >= min || entity.method_36454() <= max);
                        } else {
                            parser.addFilter((origin, entity) -> entity.method_36454() >= min && entity.method_36454() <= max);
                        }
                        parser.hasYRotation = true;
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return !parser.hasYRotation;
                    }
                });
                options.put("limit", new Option("argument.entity.options.limit.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        int cursor = parser.reader.getCursor();
                        int limit = parser.reader.readInt();
                        if (limit < 1) {
                            parser.reader.setCursor(cursor);
                            throw class_2306.field_10886.createWithContext((ImmutableStringReader)parser.reader);
                        }
                        parser.limit = limit;
                        parser.hasLimit = true;
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return !parser.hasLimit;
                    }
                });
                options.put("sort", new Option("argument.entity.options.sort.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        int cursor = parser.reader.getCursor();
                        String sort = parser.reader.readUnquotedString();
                        parser.suggestor = (builder, playerNameSuggest) -> class_2172.method_9265(Arrays.asList("nearest", "furthest", "random", "arbitrary"), (SuggestionsBuilder)builder);
                        switch (sort) {
                            case "nearest": {
                                parser.sorter = NEAREST;
                                break;
                            }
                            case "furthest": {
                                parser.sorter = FURTHEST;
                                break;
                            }
                            case "random": {
                                parser.sorter = RANDOM;
                                break;
                            }
                            case "arbitrary": {
                                parser.sorter = UNSORTED;
                                break;
                            }
                            default: {
                                parser.reader.setCursor(cursor);
                                throw class_2306.field_10888.createWithContext((ImmutableStringReader)parser.reader, (Object)sort);
                            }
                        }
                        parser.hasSort = true;
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return !parser.hasSort;
                    }
                });
                options.put("type", new Option("argument.entity.options.type.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        parser.suggestor = (builder, playerNameSuggest) -> {
                            class_7922 entityTypes = class_7923.field_41177;
                            class_2172.method_9258((Iterable)entityTypes.method_10235(), (SuggestionsBuilder)builder, (String)"!");
                            class_2172.method_40182(entityTypes.method_40273().map(class_6862::comp_327), (SuggestionsBuilder)builder, (String)"!#");
                            if (!parser.hasType) {
                                class_2172.method_9270((Iterable)entityTypes.method_10235(), (SuggestionsBuilder)builder);
                                class_2172.method_40182(entityTypes.method_40273().map(class_6862::comp_327), (SuggestionsBuilder)builder, (String)String.valueOf('#'));
                            }
                            return builder.buildFuture();
                        };
                        int cursor = parser.reader.getCursor();
                        boolean neg = parser.readNegationCharacter();
                        if (parser.readTagCharacter()) {
                            class_5321 keyEntityTypes = class_7924.field_41266;
                            class_6862 tagKey = class_6862.method_40092((class_5321)keyEntityTypes, (class_2960)class_2960.method_12835((StringReader)parser.reader));
                            parser.addFilter((origin, entity) -> entity.method_5864().method_20210(tagKey) != neg);
                        } else {
                            class_7922 entityTypes = class_7923.field_41177;
                            class_2960 typeId = class_2960.method_12835((StringReader)parser.reader);
                            class_1299 type = (class_1299)entityTypes.method_17966(typeId).orElseThrow(() -> {
                                parser.reader.setCursor(cursor);
                                return class_2306.field_10892.createWithContext((ImmutableStringReader)parser.reader, (Object)typeId);
                            });
                            parser.playersOnly = false;
                            if (!neg) {
                                parser.hasType = true;
                                if (type == class_1299.field_6097) {
                                    parser.playersOnly = true;
                                }
                            }
                            parser.addFilter((origin, entity) -> entity.method_5864() == type != neg);
                        }
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return !parser.hasType;
                    }
                });
                options.put("nbt", new Option("argument.entity.options.nbt.description"){

                    @Override
                    void apply(Parser parser) throws CommandSyntaxException {
                        boolean neg = parser.readNegationCharacter();
                        class_2487 nbt = new class_2522(parser.reader).method_10727();
                        parser.addFilter((origin, entity) -> {
                            class_1799 heldItem;
                            class_2487 entityNbt = entity.method_5647(new class_2487());
                            if (!(entity instanceof class_1657) || !(heldItem = ((class_1657)entity).method_6118(class_1304.field_6173)).method_7960()) {
                                // empty if block
                            }
                            return class_2512.method_10687((class_2520)nbt, (class_2520)entityNbt, (boolean)true) != neg;
                        });
                    }

                    @Override
                    boolean applicable(Parser parser) {
                        return true;
                    }
                });
            }
        }
    }
}

