/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.clientscript.impl;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.DelayedFunction;
import me.senseiwells.arucas.utils.impl.Task;
import me.senseiwells.essentialclient.utils.misc.Scheduler;
import org.jetbrains.annotations.NotNull;

public class ScriptTask
extends Task {
    public ScriptTask(Interpreter interpreter) {
        super(interpreter);
    }

    @NotNull
    public Future<ClassInstance> run(Iterator<DelayedFunction> tasks) {
        int totalTicks = 0;
        while (tasks.hasNext()) {
            DelayedFunction next = tasks.next();
            if (!tasks.hasNext()) {
                return Scheduler.schedule(totalTicks + next.getTime(), () -> {
                    Interpreter interpreter = this.getInterpreter();
                    return (ClassInstance)interpreter.runSafe(() -> {
                        if (interpreter.isRunning()) {
                            return next.getFunction().invoke(interpreter.branch(), List.of());
                        }
                        return interpreter.getNull();
                    });
                });
            }
            Scheduler.schedule(totalTicks += next.getTime(), () -> {
                Interpreter interpreter = this.getInterpreter();
                interpreter.runSafe(() -> {
                    if (interpreter.isRunning()) {
                        next.getFunction().invoke(interpreter.branch(), List.of());
                    }
                    return null;
                });
            });
        }
        return CompletableFuture.completedFuture(this.getInterpreter().getNull());
    }
}

