/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.clientscript.impl;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptShape;
import net.minecraft.class_243;

public class ScriptSphere
extends ScriptShape.Centred {
    private static final Map<UUID, Set<ScriptShape>> REGULAR_SPHERES = new ConcurrentHashMap<UUID, Set<ScriptShape>>();
    private static final Map<UUID, Set<ScriptShape>> IGNORE_DEPTH_SPHERES = new ConcurrentHashMap<UUID, Set<ScriptShape>>();
    private float steps = 30.0f;

    public ScriptSphere(Interpreter interpreter, class_243 position) {
        super(interpreter, position);
    }

    public void setSteps(float steps) {
        this.steps = steps;
    }

    public float getSteps() {
        return this.steps;
    }

    @Override
    protected Map<UUID, Set<ScriptShape>> getRegularDepthMap() {
        return REGULAR_SPHERES;
    }

    @Override
    protected Map<UUID, Set<ScriptShape>> getIgnoreDepthMap() {
        return IGNORE_DEPTH_SPHERES;
    }

    public static boolean hasRegular() {
        return REGULAR_SPHERES.size() > 0;
    }

    public static boolean hasIgnoreDepth() {
        return IGNORE_DEPTH_SPHERES.size() > 0;
    }

    public static void forEachRegular(Consumer<ScriptSphere> consumer) {
        REGULAR_SPHERES.values().forEach(set -> set.forEach(s -> consumer.accept((ScriptSphere)s)));
    }

    public static void forEachIgnoreDepth(Consumer<ScriptSphere> consumer) {
        IGNORE_DEPTH_SPHERES.values().forEach(set -> set.forEach(s -> consumer.accept((ScriptSphere)s)));
    }
}

