/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.clientscript.impl;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_638;

public class ScriptFakeEntity {
    private static final Map<UUID, IntSet> FAKE_IDS = new HashMap<UUID, IntSet>();
    private static final AtomicInteger FAKE_ID_COUNTER = new AtomicInteger(Integer.MAX_VALUE);
    private final class_1297 entity;
    private class_638 world;
    private class_243 pos;
    private float bodyYaw;
    private float yaw;
    private float pitch;

    public ScriptFakeEntity(Interpreter interpreter, class_1297 entity, class_638 world) {
        this.entity = entity.method_5864().method_5883((class_1937)world);
        if (this.entity == null) {
            throw new RuntimeError("Could not create fake entity");
        }
        entity.method_5838(ScriptFakeEntity.getNextFakeId(interpreter));
        this.world = world;
        this.pos = class_243.field_1353;
        this.pitch = 0.0f;
        this.yaw = 0.0f;
        this.bodyYaw = 0.0f;
    }

    public void setWorld(class_638 world) {
        this.world = world;
    }

    public class_638 getWorld() {
        return this.world;
    }

    public void setPos(class_243 pos) {
        this.setPos(pos, 0);
    }

    public void setPos(class_243 pos, int interpolation) {
        this.pos = pos;
        this.updatePosition(interpolation);
    }

    public class_243 getPos() {
        return this.pos;
    }

    public void setYaw(float yaw) {
        this.setYaw(yaw, 0);
    }

    public void setYaw(float yaw, int interpolation) {
        this.yaw = yaw;
        this.updatePosition(interpolation);
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setBodyYaw(float bodyYaw) {
        this.setBodyYaw(bodyYaw, 0);
    }

    public void setBodyYaw(float bodyYaw, int interpolation) {
        this.bodyYaw = bodyYaw;
        this.updatePosition(interpolation);
    }

    public float getBodyYaw() {
        return this.bodyYaw;
    }

    public void setPitch(float pitch) {
        this.setPitch(pitch, 0);
    }

    public void setPitch(float pitch, int interpolation) {
        this.pitch = pitch;
        this.updatePosition(interpolation);
    }

    public float getPitch() {
        return this.pitch;
    }

    public void updatePosAndRotation(class_243 pos, float yaw, float pitch) {
        this.updatePosAndRotation(pos, yaw, pitch, 0);
    }

    public void updatePosAndRotation(class_243 pos, float yaw, float pitch, int interpolation) {
        this.pos = pos;
        this.entity.method_5847(yaw);
        this.entity.method_36457(pitch);
        this.updatePosition(interpolation);
    }

    public void spawn() {
        EssentialUtils.getClient().execute(() -> {
            this.entity.method_5808(this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, this.yaw, this.pitch);
            this.entity.method_5759(this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, this.yaw, this.pitch, 3);
            this.world.method_53875(this.entity);
        });
    }

    public void despawn() {
        this.world.method_2945(this.entity.method_5628(), class_1297.class_5529.field_26999);
    }

    private void updatePosition(int interpolation) {
        EssentialUtils.getClient().execute(() -> {
            this.entity.method_5636(this.bodyYaw);
            this.entity.method_5759(this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, this.yaw, this.pitch, interpolation);
        });
    }

    public static synchronized boolean isFakeEntity(int id) {
        for (IntSet set : FAKE_IDS.values()) {
            if (!set.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static synchronized int getNextFakeId(Interpreter interpreter) {
        int id = FAKE_ID_COUNTER.getAndDecrement();
        IntSet fakeIds = FAKE_IDS.computeIfAbsent(interpreter.getProperties().getId(), uuid -> {
            interpreter.addStopEvent(() -> {
                IntSet ids = FAKE_IDS.get(uuid);
                class_638 world = EssentialUtils.getWorld();
                if (ids != null && world != null) {
                    EssentialUtils.getClient().execute(() -> ids.forEach(i -> world.method_2945(i, class_1297.class_5529.field_26999)));
                }
            });
            return new IntOpenHashSet();
        });
        fakeIds.add(id);
        return id;
    }
}

