/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.clientscript.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.essentialclient.clientscript.definitions.ConfigDef;
import me.senseiwells.essentialclient.gui.RulesScreen;
import me.senseiwells.essentialclient.gui.entries.BaseListEntry;
import me.senseiwells.essentialclient.rule.client.BooleanClientRule;
import me.senseiwells.essentialclient.rule.client.ClientRule;
import me.senseiwells.essentialclient.rule.client.CycleClientRule;
import me.senseiwells.essentialclient.rule.client.DoubleClientRule;
import me.senseiwells.essentialclient.rule.client.DoubleSliderClientRule;
import me.senseiwells.essentialclient.rule.client.IntegerClientRule;
import me.senseiwells.essentialclient.rule.client.IntegerSliderClientRule;
import me.senseiwells.essentialclient.rule.client.ListClientRule;
import me.senseiwells.essentialclient.rule.client.StringClientRule;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.config.Config;
import me.senseiwells.essentialclient.utils.interfaces.Rule;
import net.minecraft.class_2561;

public class ScriptConfigHandler
implements Config.CList {
    private final Map<String, ClassInstance> configs = new ConcurrentHashMap<String, ClassInstance>();
    private final Interpreter interpreter;
    private final String name;
    private Path path;
    private boolean save;

    public ScriptConfigHandler(Interpreter interpreter, String name, boolean read) {
        this.interpreter = interpreter;
        this.name = name;
        this.save = true;
        if (read) {
            this.readConfig();
        }
        interpreter.addStopEvent(() -> {
            if (this.save) {
                this.saveConfig();
            }
        });
    }

    public RulesScreen createScreen(class_2561 title, final boolean alphabetical) {
        return new RulesScreen(title, EssentialUtils.getClient().field_1755){

            @Override
            public Collection<? extends Rule<?>> getRules(String filter) {
                return ScriptConfigHandler.this.configs.values().stream().map(i -> (ClientRule)i.getPrimitive(ConfigDef.class)).toList();
            }

            @Override
            public Comparator<BaseListEntry<?>> entryComparator() {
                return alphabetical ? super.entryComparator() : (a, b) -> 0;
            }

            @Override
            public boolean shouldCategorise() {
                return true;
            }
        };
    }

    public void addConfig(ClassInstance instance) {
        ClientRule rule = (ClientRule)instance.getPrimitive(ConfigDef.class);
        if (rule != null) {
            this.configs.put(rule.getName(), instance);
        }
    }

    public void resetAllToDefault() {
        this.forEachConfig(Rule::resetToDefault);
    }

    public void removeConfig(String name) {
        this.configs.remove(name);
    }

    public ClassInstance getConfig(String name) {
        return this.configs.get(name);
    }

    public ArucasList getAllConfigs() {
        return new ArucasList(this.configs.values());
    }

    public void setSaveOnClose(boolean save) {
        this.save = save;
    }

    public boolean willSaveOnClose() {
        return this.save;
    }

    public void setSavePath(Path path) {
        this.path = path;
    }

    @Override
    public String getConfigName() {
        return this.name;
    }

    @Override
    public JsonElement getSaveData() {
        JsonArray array = new JsonArray();
        for (ClassInstance instance : this.configs.values()) {
            array.add((JsonElement)((ClientRule)instance.asPrimitive(ConfigDef.class)).serialise());
        }
        return array;
    }

    @Override
    public void readConfig(JsonArray array) {
        for (JsonElement element : array) {
            this.parse(element.getAsJsonObject());
        }
    }

    @Override
    public Path getConfigRootPath() {
        return this.path == null ? Config.CList.super.getConfigRootPath() : this.path;
    }

    private void forEachConfig(Consumer<ClientRule<?>> consumer) {
        this.configs.values().forEach(i -> {
            ClientRule rule = (ClientRule)i.getPrimitive(ConfigDef.class);
            consumer.accept(rule);
        });
    }

    private <T> void parse(JsonObject object) {
        ClientRule config;
        String name = object.get("name").getAsString();
        JsonElement value = object.get("value");
        ClassInstance instance = this.configs.get(name);
        if (instance != null && (config = (ClientRule)this.configs.get(name).getPrimitive(ConfigDef.class)) != null) {
            config.setValueQuietly(config.fromJson(value));
            return;
        }
        String type = object.get("type").getAsString();
        JsonElement objectElement = object.get("description");
        String description = objectElement != null && objectElement.isJsonPrimitive() ? objectElement.getAsString() : null;
        objectElement = object.get("optional_info");
        String optionalInfo = objectElement != null && objectElement.isJsonPrimitive() ? objectElement.getAsString() : null;
        objectElement = object.get("max_length");
        int maxLength = objectElement != null && objectElement.isJsonPrimitive() ? objectElement.getAsInt() : 32;
        objectElement = object.get("category");
        String category = objectElement != null && objectElement.isJsonPrimitive() ? objectElement.getAsString() : null;
        objectElement = object.get("display");
        boolean display = objectElement == null || objectElement.isJsonPrimitive() && objectElement.getAsBoolean();
        JsonElement defaultValue = object.get("default_value");
        ClientRule rule = switch (type) {
            case "boolean" -> new BooleanClientRule(name, description, defaultValue != null && defaultValue.getAsBoolean(), category);
            case "cycle" -> {
                JsonArray cycleValues = object.getAsJsonArray("cycle_values");
                ArrayList<String> cycles = new ArrayList<String>();
                for (JsonElement element : cycleValues) {
                    cycles.add(element.getAsString());
                }
                if (defaultValue != null) {
                    yield new CycleClientRule(name, description, cycles, defaultValue.getAsString(), category, null);
                }
                yield new CycleClientRule(name, description, (List<String>)cycles, category);
            }
            case "double" -> new DoubleClientRule(name, description, defaultValue == null ? 0.0 : defaultValue.getAsDouble(), category);
            case "double_slider" -> {
                double min = object.get("min").getAsDouble();
                double max = object.get("max").getAsDouble();
                yield new DoubleSliderClientRule(name, description, defaultValue == null ? 0.0 : defaultValue.getAsDouble(), category, min, max);
            }
            case "integer" -> new IntegerClientRule(name, description, defaultValue == null ? 0 : defaultValue.getAsInt(), category);
            case "integer_slider" -> {
                int min = object.get("min").getAsInt();
                int max = object.get("max").getAsInt();
                yield new IntegerSliderClientRule(name, description, defaultValue == null ? 0 : defaultValue.getAsInt(), category, min, max);
            }
            case "list" -> {
                ArrayList<String> configData = new ArrayList<String>();
                if (defaultValue != null && defaultValue.isJsonArray()) {
                    for (JsonElement element : defaultValue.getAsJsonArray()) {
                        configData.add(element.getAsString());
                    }
                }
                ListClientRule listClientRule = new ListClientRule(name, description, (List<String>)configData, category);
                listClientRule.setMaxLength(maxLength);
                yield listClientRule;
            }
            case "string" -> {
                StringClientRule stringClientRule = new StringClientRule(name, description, defaultValue == null ? "" : defaultValue.getAsString(), category);
                stringClientRule.setMaxLength(maxLength);
                yield stringClientRule;
            }
            default -> throw new IllegalArgumentException("Invalid config type '%s'".formatted(type));
        };
        if (value != null) {
            rule.setValueQuietly(rule.fromJson(value));
        }
        rule.setOptionalInfo(optionalInfo);
        rule.display(display);
        this.configs.put(name, this.interpreter.create(ConfigDef.class, (Object)rule));
    }
}

