/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.clientscript;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.senseiwells.arucas.utils.NetworkUtils;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.clientscript.core.ClientScript;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.minecraft.class_2561;

public class ScriptRepositoryManager {
    private static final Gson GSON = new GsonBuilder().create();
    public static final ScriptRepositoryManager INSTANCE = new ScriptRepositoryManager();
    private final Map<Category, Set<ScriptFile>> children = new HashMap<Category, Set<ScriptFile>>();

    private ScriptRepositoryManager() {
        ClientRules.CLIENT_SCRIPT_REPOS.addListener(v -> {
            Thread thread = new Thread(() -> {
                for (Category category : Category.values()) {
                    this.clearChildren(category);
                    this.loadChildren(category);
                }
            }, "ClientScriptRepoLoader");
            thread.setDaemon(false);
            thread.start();
        });
    }

    public String getScriptFromWeb(Category category, String name, boolean fromCache) {
        ScriptFile scriptFile = this.getScriptFromName(category, name);
        if (scriptFile == null) {
            return null;
        }
        if (fromCache && scriptFile.content != null) {
            return scriptFile.content;
        }
        String content = NetworkUtils.getStringFromUrl((String)scriptFile.downloadUrl);
        if (content == null) {
            return null;
        }
        scriptFile.content = content;
        return scriptFile.content;
    }

    public boolean downloadScript(Category category, String name, boolean overwrite) {
        String fileContent;
        Set<ScriptFile> scriptFileSet = this.getChildren(category);
        if (!scriptFileSet.contains(new ScriptFile(name, null, null))) {
            return true;
        }
        Path scriptDir = ClientScript.INSTANCE.getScriptDirectory();
        Path newScript = scriptDir.resolve(name + ".arucas");
        if (!overwrite && Files.exists(newScript, new LinkOption[0])) {
            int i = 1;
            while (Files.exists(newScript = scriptDir.resolve(name + i + ".arucas"), new LinkOption[0])) {
                ++i;
            }
        }
        if ((fileContent = this.getScriptFromWeb(category, name, false)) != null) {
            boolean bl;
            block12: {
                BufferedWriter writer = Files.newBufferedWriter(newScript, new OpenOption[0]);
                try {
                    writer.write(fileContent);
                    bl = false;
                    if (writer == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                writer.close();
            }
            return bl;
        }
        return true;
    }

    public String getViewableLink(Category category, String scriptName) {
        ScriptFile scriptFile = this.getScriptFromName(category, scriptName);
        if (scriptFile == null || scriptFile.viewableUrl == null) {
            return "https://github.com/senseiwells/clientscript";
        }
        return scriptFile.viewableUrl;
    }

    public List<String> getChildrenNames(Category category) {
        return this.getChildren(category).stream().map(scriptFile -> scriptFile.name).toList();
    }

    private ScriptFile getScriptFromName(Category category, String name) {
        return this.getChildren(category).stream().filter(s -> s.name.equals(name)).findAny().orElse(null);
    }

    private Set<ScriptFile> getChildren(Category category) {
        if (!this.children.containsKey((Object)category) && !this.loadChildren(category)) {
            return Set.of();
        }
        return this.children.get((Object)category);
    }

    private String getApiAddress(String targetString) {
        if (targetString.startsWith("https://api.github.com/repos/")) {
            return targetString;
        }
        if (targetString.startsWith("https://github.com/")) {
            targetString = targetString.substring(19);
        }
        String[] split = targetString.split("/");
        if (targetString.contains("/tree/") || targetString.contains("/blob/")) {
            if (split.length < 4) {
                return targetString;
            }
            String authorName = split[0];
            String repositoryName = split[1];
            String branchName = split[3];
            return "https://api.github.com/repos/" + authorName + "/" + repositoryName + "/contents/scripts?ref=" + branchName;
        }
        if (split.length < 2) {
            return targetString;
        }
        String authorName = split[0];
        String repositoryName = split[1];
        return "https://api.github.com/repos/" + authorName + "/" + repositoryName + "/contents/scripts";
    }

    private void clearChildren(Category category) {
        if (!this.children.containsKey((Object)category)) {
            return;
        }
        this.children.get((Object)category).clear();
    }

    private boolean loadChildren(Category category) {
        for (String repo : (List)ClientRules.CLIENT_SCRIPT_REPOS.getValue()) {
            String response;
            repo = this.getApiAddress(repo);
            String reference = "";
            if (repo.contains("?")) {
                reference = repo.substring(repo.indexOf("?"));
                repo = repo.substring(0, repo.indexOf("?"));
            }
            if ((response = NetworkUtils.getStringFromUrl((String)(repo + "/" + category.toString() + reference))) == null) {
                EssentialClient.LOGGER.error("Couldn't request data from: " + repo + "/" + String.valueOf((Object)category));
                continue;
            }
            try {
                JsonArray childrenFiles = (JsonArray)GSON.fromJson(response, JsonArray.class);
                HashSet<ScriptFile> scriptFileSet = new HashSet<ScriptFile>();
                for (JsonElement element : childrenFiles) {
                    JsonObject object = element.getAsJsonObject();
                    String childName = object.get("name").getAsString();
                    if (!childName.endsWith(".arucas")) continue;
                    childName = childName.substring(0, childName.length() - 7);
                    String childDownload = object.get("download_url").getAsString();
                    JsonObject links = object.get("_links").getAsJsonObject();
                    String viewableUrl = links.get("html").getAsString();
                    scriptFileSet.add(new ScriptFile(childName, childDownload, viewableUrl));
                }
                Set files = this.children.computeIfAbsent(category, c -> new LinkedHashSet());
                files.addAll(scriptFileSet);
            }
            catch (Exception e) {
                EssentialClient.LOGGER.error("Failed to load scripts from: " + repo, (Throwable)e);
            }
        }
        return this.children.containsKey((Object)category);
    }

    public static enum Category {
        AUTOMATION(Texts.AUTOMATION),
        UTILITIES(Texts.UTILITIES),
        MISCELLANEOUS(Texts.MISCELLANEOUS);

        private final class_2561 prettyName;

        private Category(class_2561 prettyName) {
            this.prettyName = prettyName;
        }

        public class_2561 getPrettyName() {
            return this.prettyName;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static class ScriptFile {
        private final String name;
        private final String downloadUrl;
        private final String viewableUrl;
        private String content;

        ScriptFile(String name, String downloadUrl, String viewableUrl) {
            this.name = name;
            this.downloadUrl = downloadUrl;
            this.viewableUrl = viewableUrl;
            this.content = null;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ScriptFile)) return false;
            ScriptFile scriptFile = (ScriptFile)o;
            if (!scriptFile.name.equals(this.name)) return false;
            return true;
        }
    }
}

