/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.clientscript;

import com.google.common.net.UrlEscapers;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import net.fabricmc.loader.impl.lib.mappingio.MappedElementKind;
import net.fabricmc.loader.impl.lib.mappingio.MappingVisitor;
import net.fabricmc.loader.impl.lib.mappingio.format.tiny.Tiny2FileReader;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public final class MinecraftDeobfuscator {
    private static final Map<String, String> CLASS_DEOBFUSCATION_MAPPINGS;
    private static final Map<String, String> OBFUSCATION_MAPPINGS;
    private static final String MAPPINGS_JAR_LOCATION;
    private static final Path MAPPINGS_DIRECTORY;
    private static final Path CACHED_MAPPINGS;
    private static boolean triedLoadingMappings;

    public static void load() {
    }

    public static String obfuscate(String name) {
        if (!triedLoadingMappings) {
            MinecraftDeobfuscator.loadMappings();
        }
        String mapped = OBFUSCATION_MAPPINGS.get(name);
        if (((Boolean)ClientRules.CLIENTSCRIPT_DEBUGGER.getValue()).booleanValue()) {
            EssentialClient.LOGGER.info("Obfuscating {} -> {}", (Object)name, (Object)Objects.requireNonNullElse(mapped, name));
        }
        return mapped == null ? name : mapped;
    }

    public static String deobfuscateClass(String name) {
        if (!triedLoadingMappings) {
            MinecraftDeobfuscator.loadMappings();
        }
        String mapped = CLASS_DEOBFUSCATION_MAPPINGS.get(name);
        if (((Boolean)ClientRules.CLIENTSCRIPT_DEBUGGER.getValue()).booleanValue()) {
            EssentialClient.LOGGER.info("Deobfuscating {} -> {}", (Object)name, (Object)Objects.requireNonNullElse(mapped, name));
        }
        return mapped == null ? name : mapped;
    }

    private static void downloadAndCacheMappings() {
        String yarnVersion;
        try {
            yarnVersion = Yarn.getLatestYarn();
        }
        catch (Exception e) {
            EssentialClient.LOGGER.error("Could not get latest yarn build for version");
            return;
        }
        EssentialClient.LOGGER.info("Downloading deobfuscation mappings: " + yarnVersion + " for the first launch");
        String encodedYarnVersion = UrlEscapers.urlFragmentEscaper().escape(yarnVersion);
        String artifactUrl = "https://maven.fabricmc.net/net/fabricmc/yarn/" + encodedYarnVersion + "/yarn-" + encodedYarnVersion + "-v2.jar";
        File jarFile = MAPPINGS_DIRECTORY.resolve("yarn-mappings.jar").toFile();
        jarFile.deleteOnExit();
        try {
            FileUtils.copyURLToFile((URL)new URL(artifactUrl), (File)jarFile);
        }
        catch (IOException e) {
            EssentialClient.LOGGER.error("Failed to downloads mappings!", (Throwable)e);
            return;
        }
        try (FileSystem jar = FileSystems.newFileSystem(jarFile.toPath(), (ClassLoader)null);){
            Files.copy(jar.getPath(MAPPINGS_JAR_LOCATION, new String[0]), CACHED_MAPPINGS, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            EssentialClient.LOGGER.error("Failed to extract mappings!", (Throwable)e);
        }
    }

    private static void loadMappings() {
        if (!Files.exists(CACHED_MAPPINGS, new LinkOption[0])) {
            EssentialClient.LOGGER.warn("Could not download mappings");
            return;
        }
        triedLoadingMappings = true;
        try (BufferedReader mappingReader = Files.newBufferedReader(CACHED_MAPPINGS);){
            Tiny2FileReader.read((Reader)mappingReader, (MappingVisitor)new MappingVisitorImpl());
        }
        catch (IOException e) {
            EssentialClient.LOGGER.error("Could not load mappings", (Throwable)e);
        }
    }

    static {
        OBFUSCATION_MAPPINGS = new HashMap<String, String>();
        CLASS_DEOBFUSCATION_MAPPINGS = new HashMap<String, String>();
        MAPPINGS_JAR_LOCATION = "mappings/mappings.tiny";
        triedLoadingMappings = false;
        MAPPINGS_DIRECTORY = EssentialUtils.getEssentialConfigFile().resolve("Mappings");
        try {
            if (!Files.exists(MAPPINGS_DIRECTORY, new LinkOption[0])) {
                Files.createDirectory(MAPPINGS_DIRECTORY, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            EssentialClient.LOGGER.error("Failed to create Mappings directory");
        }
        CACHED_MAPPINGS = MAPPINGS_DIRECTORY.resolve("mappings-" + EssentialUtils.getMinecraftVersion() + ".tiny");
        if (!Files.exists(CACHED_MAPPINGS, new LinkOption[0])) {
            MinecraftDeobfuscator.downloadAndCacheMappings();
        }
    }

    private static class Yarn {
        private static final String YARN_API_ENTRYPOINT = "https://meta.fabricmc.net/v2/versions/yarn/" + EssentialUtils.getMinecraftVersion();
        private static final Path YARN_VERSION = MAPPINGS_DIRECTORY.resolve("yarn-version.txt");
        private static String VERSION_CACHE;
        public String gameVersion;
        public String separator;
        public int build;
        public String maven;
        public String version;
        public boolean stable;

        private Yarn() {
        }

        private static String getLatestYarn() throws IOException {
            if (VERSION_CACHE == null) {
                if (!Files.exists(YARN_VERSION, new LinkOption[0])) {
                    URL url = new URL(YARN_API_ENTRYPOINT);
                    URLConnection request = url.openConnection();
                    request.connect();
                    InputStream response = (InputStream)request.getContent();
                    Yarn[] versions = (Yarn[])new Gson().fromJson((Reader)new InputStreamReader(response), Yarn[].class);
                    if (versions.length == 0) {
                        throw new IllegalStateException("No yarn versions were received at the API endpoint. Received json: " + Yarn.getString(response));
                    }
                    String version = Arrays.stream(versions).max(Comparator.comparingInt((ToIntFunction<Yarn>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$getLatestYarn$0(me.senseiwells.essentialclient.utils.clientscript.MinecraftDeobfuscator$Yarn ), (Lme/senseiwells/essentialclient/utils/clientscript/MinecraftDeobfuscator$Yarn;)I)())).get().version;
                    Files.write(YARN_VERSION, version.getBytes(), new OpenOption[0]);
                    VERSION_CACHE = version;
                } else {
                    VERSION_CACHE = new String(Files.readAllBytes(YARN_VERSION));
                }
            }
            return VERSION_CACHE;
        }

        private static String getString(InputStream inputStream) throws IOException {
            return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        }

        private static /* synthetic */ int lambda$getLatestYarn$0(Yarn v) {
            return v.build;
        }
    }

    private static class MappingVisitorImpl
    implements MappingVisitor {
        private String fromClass;
        private String toClass;
        private String intermediary;

        private MappingVisitorImpl() {
        }

        public void visitNamespaces(String s, List<String> list) {
        }

        public boolean visitClass(String s) {
            this.fromClass = s.replace('/', '.');
            return true;
        }

        public boolean visitField(String s, @Nullable String s1) {
            this.intermediary = s;
            return true;
        }

        public boolean visitMethod(String s, @Nullable String s1) {
            this.intermediary = s;
            return true;
        }

        public boolean visitMethodArg(int i, int i1, @Nullable String s) {
            return true;
        }

        public boolean visitMethodVar(int i, int i1, int i2, int i3, @Nullable String s) {
            return true;
        }

        public void visitDstName(MappedElementKind mappedElementKind, int i, String s) {
            if (s.equals("<init>")) {
                return;
            }
            if (mappedElementKind == MappedElementKind.CLASS) {
                this.toClass = s.replace('/', '.');
                CLASS_DEOBFUSCATION_MAPPINGS.put(this.fromClass, this.toClass);
                OBFUSCATION_MAPPINGS.put(this.toClass, this.fromClass);
                return;
            }
            String from = this.fromClass + "#" + this.intermediary;
            String to = this.toClass + "#" + s;
            if (mappedElementKind == MappedElementKind.METHOD) {
                from = from + "()";
                to = to + "()";
            } else if (mappedElementKind != MappedElementKind.FIELD) {
                return;
            }
            OBFUSCATION_MAPPINGS.put(to, from);
        }

        public void visitComment(MappedElementKind mappedElementKind, String s) {
        }
    }
}

