/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.clientscript;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import me.senseiwells.arucas.api.ArucasAPI;
import me.senseiwells.arucas.api.docs.visitor.ArucasDocParser;
import me.senseiwells.arucas.api.docs.visitor.ArucasDocVisitor;
import me.senseiwells.arucas.api.docs.visitor.impl.JsonDocVisitor;
import me.senseiwells.arucas.api.docs.visitor.impl.MarkdownDocVisitor;
import me.senseiwells.arucas.api.docs.visitor.impl.VSCSnippetDocVisitor;
import me.senseiwells.arucas.utils.FileUtils;
import me.senseiwells.arucas.utils.NetworkUtils;
import me.senseiwells.essentialclient.clientscript.core.ClientScriptInstance;
import me.senseiwells.essentialclient.utils.clientscript.ScriptMarkdownHelper;
import me.senseiwells.essentialclient.utils.misc.WikiParser;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;

public class DocGenerator
implements ModInitializer {
    public void onInitialize() {
        String[] launchArgs = FabricLoader.getInstance().getLaunchArguments(true);
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec pathSpec = parser.accepts("generate").withRequiredArg();
        parser.allowsUnrecognizedOptions();
        OptionSet options = parser.parse(launchArgs);
        if (!options.has((OptionSpec)pathSpec)) {
            return;
        }
        Path path = FileUtils.ensureExists((Path)Path.of((String)options.valueOf((OptionSpec)pathSpec), new String[0]));
        ArucasAPI api = ClientScriptInstance.getApi();
        Path libPath = FileUtils.ensureExists((Path)path.resolve("libs"));
        Path docPath = FileUtils.ensureExists((Path)path.getParent().resolve("docs"));
        Path jsonPath = FileUtils.ensureExists((Path)path.resolve("json"));
        Path mdPath = FileUtils.ensureExists((Path)path.resolve("markdown"));
        Path snippetPath = FileUtils.ensureExists((Path)path.resolve("snippets"));
        JsonDocVisitor jsonVisitor = new JsonDocVisitor();
        MarkdownDocVisitor markdownVisitor = new MarkdownDocVisitor();
        VSCSnippetDocVisitor snippetVisitor = new VSCSnippetDocVisitor();
        new ArucasDocParser(api).addVisitors(new ArucasDocVisitor[]{jsonVisitor, markdownVisitor, snippetVisitor}).parse();
        try {
            Files.writeString(jsonPath.resolve("AllDocs.json"), (CharSequence)jsonVisitor.getJson(), new OpenOption[0]);
            api.generateNativeFiles(libPath);
            Files.writeString(snippetPath.resolve("arucas.json"), (CharSequence)snippetVisitor.getJson(), new OpenOption[0]);
            String extensions = markdownVisitor.getExtensions();
            String classes = markdownVisitor.getClasses();
            String events = ScriptMarkdownHelper.parseEvents();
            Files.writeString(mdPath.resolve("Extensions.md"), (CharSequence)extensions, new OpenOption[0]);
            Files.writeString(mdPath.resolve("Classes.md"), (CharSequence)classes, new OpenOption[0]);
            Files.writeString(mdPath.resolve("Events.md"), (CharSequence)events, new OpenOption[0]);
            Files.writeString(FileUtils.ensureParentExists((Path)docPath.resolve("wiki/Home.md")), (CharSequence)WikiParser.generateWiki(), new OpenOption[0]);
            Object full = NetworkUtils.getStringFromUrl((String)"https://raw.githubusercontent.com/senseiwells/Arucas/main/docs/FullLang.md");
            full = (String)full + "\n\n" + extensions;
            full = (String)full + "\n\n" + classes;
            full = (String)full + "\n\n" + events;
            Files.writeString(docPath.resolve("Full.md"), (CharSequence)full, new OpenOption[0]);
        }
        catch (IOException e) {
            LogManager.getLogger((String)"DocGenerator").info("Failed to generate docs", (Throwable)e);
        }
        System.exit(0);
    }
}

