/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.clientscript;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kotlin.Pair;
import me.senseiwells.arucas.builtin.BooleanDef;
import me.senseiwells.arucas.builtin.CollectionDef;
import me.senseiwells.arucas.builtin.FunctionDef;
import me.senseiwells.arucas.builtin.ListDef;
import me.senseiwells.arucas.builtin.MapDef;
import me.senseiwells.arucas.builtin.NumberDef;
import me.senseiwells.arucas.builtin.StringDef;
import me.senseiwells.arucas.builtin.TypeDef;
import me.senseiwells.arucas.classes.ClassDefinition;
import me.senseiwells.arucas.classes.EnumDefinition;
import me.senseiwells.arucas.classes.PrimitiveDefinition;
import me.senseiwells.arucas.classes.instance.ClassInstance;
import me.senseiwells.arucas.exceptions.RuntimeError;
import me.senseiwells.arucas.functions.ArucasFunction;
import me.senseiwells.arucas.interpreter.Interpreter;
import me.senseiwells.arucas.utils.impl.ArucasCollection;
import me.senseiwells.arucas.utils.impl.ArucasList;
import me.senseiwells.arucas.utils.impl.ArucasMap;
import me.senseiwells.essentialclient.clientscript.definitions.EntityDef;
import me.senseiwells.essentialclient.clientscript.definitions.ItemStackDef;
import me.senseiwells.essentialclient.clientscript.definitions.TextDef;
import me.senseiwells.essentialclient.commands.CommandRegister;
import me.senseiwells.essentialclient.mixins.clientScript.KeyBindingAccessor;
import me.senseiwells.essentialclient.rule.client.BooleanClientRule;
import me.senseiwells.essentialclient.rule.client.ClientRule;
import me.senseiwells.essentialclient.rule.client.CycleClientRule;
import me.senseiwells.essentialclient.rule.client.DoubleClientRule;
import me.senseiwells.essentialclient.rule.client.DoubleSliderClientRule;
import me.senseiwells.essentialclient.rule.client.IntegerClientRule;
import me.senseiwells.essentialclient.rule.client.IntegerSliderClientRule;
import me.senseiwells.essentialclient.rule.client.ListClientRule;
import me.senseiwells.essentialclient.rule.client.StringClientRule;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.clientscript.FunctionClickEvent;
import me.senseiwells.essentialclient.utils.clientscript.impl.ScriptItemStack;
import me.senseiwells.essentialclient.utils.command.ClientEntityArgumentType;
import me.senseiwells.essentialclient.utils.command.ClientEntitySelector;
import me.senseiwells.essentialclient.utils.command.CommandHelper;
import me.senseiwells.essentialclient.utils.command.DefinitionArgumentType;
import me.senseiwells.essentialclient.utils.command.FakeCommandSource;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_151;
import net.minecraft.class_1713;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2223;
import net.minecraft.class_2232;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_2287;
import net.minecraft.class_2321;
import net.minecraft.class_2350;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3959;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;

public class ClientScriptUtils {
    private static final Set<String> WARNED = ConcurrentHashMap.newKeySet();
    private static final Map<String, TickedKey> HELD_KEYS = new ConcurrentHashMap<String, TickedKey>();

    public static void load() {
    }

    public static void warnMainThread(String name, Interpreter interpreter) {
        class_310 client = EssentialUtils.getClient();
        if (!client.method_18854() && !WARNED.contains(name)) {
            WARNED.add(name);
            interpreter.logDebug("'%s' was not called on the Minecraft main thread, this may lead to unexpected behavior".formatted(name));
        }
    }

    public static Future<Void> ensureMainThread(String name, Interpreter interpreter, Runnable runnable) {
        return ClientScriptUtils.ensureMainThread(name, interpreter, () -> {
            runnable.run();
            return null;
        });
    }

    public static <V> Future<V> ensureMainThread(String name, Interpreter interpreter, Supplier<V> callable) {
        class_310 client = EssentialUtils.getClient();
        if (client.method_18854()) {
            return CompletableFuture.completedFuture(callable.get());
        }
        if (!WARNED.contains(name)) {
            WARNED.add(name);
            interpreter.logDebug("'%s' was not called on the Minecraft main thread, this may lead to unexpected behavior".formatted(name));
        }
        return client.method_5385(() -> interpreter.runSafe(callable));
    }

    public static void holdKey(Interpreter interpreter, class_304 key, int interval) {
        if (interpreter.isRunning()) {
            HELD_KEYS.put(key.method_1431(), new TickedKey(key, interval));
            interpreter.addStopEvent(() -> ClientScriptUtils.releaseKey(key));
        }
    }

    public static void releaseKey(class_304 key) {
        HELD_KEYS.remove(key.method_1431());
        key.method_23481(false);
    }

    public static void modifyKey(Interpreter interpreter, boolean held, class_304 key) {
        if (held) {
            ClientScriptUtils.holdKey(interpreter, key, 0);
        } else {
            ClientScriptUtils.releaseKey(key);
        }
    }

    public static class_2350 stringToDirection(String string, class_2350 defaultDirection) {
        return switch (string.toLowerCase()) {
            case "north", "n" -> class_2350.field_11043;
            case "east", "e" -> class_2350.field_11034;
            case "south", "s" -> class_2350.field_11035;
            case "west", "w" -> class_2350.field_11039;
            case "up", "u" -> class_2350.field_11036;
            case "down", "d" -> class_2350.field_11033;
            default -> {
                if (defaultDirection != null) {
                    yield defaultDirection;
                }
                throw new RuntimeError("Invalid direction '%s'".formatted(string));
            }
        };
    }

    public static String mouseButtonToString(int number) {
        return switch (number) {
            case 1 -> "right";
            case 0 -> "left";
            case 2 -> "middle";
            default -> "unknown";
        };
    }

    public static class_124 stringToFormatting(String string) {
        class_124 formatting = class_124.method_533((String)string);
        if (formatting == null) {
            throw new RuntimeError("Invalid formatting: %s".formatted(string));
        }
        return formatting;
    }

    public static class_2558 stringToClickEvent(Interpreter interpreter, String string, ClassInstance object) {
        return switch (string.toLowerCase()) {
            case "function", "run_function" -> {
                ArucasFunction function = (ArucasFunction)object.getPrimitive(FunctionDef.class);
                if (function == null) {
                    throw new RuntimeError("Invalid function value: %s".formatted(object.toString(interpreter)));
                }
                yield new FunctionClickEvent(interpreter, function);
            }
            default -> {
                class_2558.class_2559 action = Arrays.stream(class_2558.class_2559.values()).filter(a -> a.method_15434().equalsIgnoreCase(string)).findFirst().orElseThrow(() -> new RuntimeError("Invalid click event action: %s".formatted(string)));
                String eventString = (String)object.getPrimitive(StringDef.class);
                if (eventString == null) {
                    throw new RuntimeError("Invalid event value: %s".formatted(object.toString(interpreter)));
                }
                yield new class_2558(action, eventString);
            }
        };
    }

    public static class_2568 stringToHoverEvent(String string, ClassInstance object) {
        return switch (string.toLowerCase()) {
            case "show_text", "text" -> {
                class_5250 text = (class_5250)object.getPrimitive(TextDef.class);
                if (text == null) {
                    throw new RuntimeError("Expected 'Text' for 'show_text' hover event");
                }
                yield new class_2568(class_2568.class_5247.field_24342, (Object)text);
            }
            case "show_item", "item" -> {
                ScriptItemStack stack = (ScriptItemStack)object.getPrimitive(ItemStackDef.class);
                if (stack == null) {
                    throw new RuntimeError("Expected 'ItemStack' for 'show_item' hover event");
                }
                yield new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(stack.stack));
            }
            case "show_entity", "entity" -> {
                class_1297 entity = (class_1297)object.getPrimitive(EntityDef.class);
                if (entity == null) {
                    throw new RuntimeError("Expected 'Entity' for 'show_entity' hover event");
                }
                yield new class_2568(class_2568.class_5247.field_24344, (Object)new class_2568.class_5248(entity.method_5864(), entity.method_5667(), entity.method_5477()));
            }
            default -> throw new RuntimeError("Invalid action '%s'".formatted(string));
        };
    }

    public static class_2960 stringToIdentifier(String string) {
        try {
            return class_2960.method_60654((String)string);
        }
        catch (class_151 e) {
            throw new RuntimeError("Invalid id '%s'".formatted(string), (Throwable)e);
        }
    }

    public static class_3959.class_242 stringToFluidType(String string) {
        return switch (string.toLowerCase()) {
            case "none" -> class_3959.class_242.field_1348;
            case "source", "sources", "sources_only" -> class_3959.class_242.field_1345;
            case "all", "any" -> class_3959.class_242.field_1347;
            default -> throw new RuntimeError("'%s' is not a valid fluid type".formatted(string));
        };
    }

    public static class_1268 stringToHand(String string) {
        return switch (string.toLowerCase()) {
            case "main", "main_hand" -> class_1268.field_5808;
            case "off", "off_hand" -> class_1268.field_5810;
            default -> throw new RuntimeError("'%s' is not a valid hand".formatted(string));
        };
    }

    public static class_1713 stringToSlotActionType(String string) {
        return switch (string.toLowerCase()) {
            case "click", "pickup" -> class_1713.field_7790;
            case "shift_click", "quick_move" -> class_1713.field_7794;
            case "swap" -> class_1713.field_7791;
            case "middle_click", "clone" -> class_1713.field_7796;
            case "throw" -> class_1713.field_7795;
            case "drag", "quick_craft" -> class_1713.field_7789;
            case "double_click", "pickup_all" -> class_1713.field_7793;
            default -> throw new RuntimeError("Invalid slotActionType, see Wiki");
        };
    }

    public static class_2520 stringToNbt(String string) {
        try {
            return new class_2522(new StringReader(string)).method_10723();
        }
        catch (CommandSyntaxException cse) {
            throw new RuntimeError("'%s' couldn't be parsed".formatted(string));
        }
    }

    public static class_2561 instanceToText(ClassInstance instance, Interpreter interpreter) {
        class_2561 text = (class_2561)instance.getPrimitive(TextDef.class);
        return text != null ? text : class_2561.method_43470((String)instance.toString(interpreter));
    }

    public static ArucasMap nbtToMap(Interpreter interpreter, class_2487 compound, int depth) {
        ArucasMap nbtMap = new ArucasMap();
        if (compound == null || --depth < 0) {
            return nbtMap;
        }
        for (String tagName : compound.method_10541()) {
            class_2520 element = compound.method_10580(tagName);
            if (element == null) continue;
            nbtMap.put(interpreter, interpreter.create(StringDef.class, (Object)tagName), ClientScriptUtils.nbtToValue(interpreter, element, depth));
        }
        return nbtMap;
    }

    public static ArucasList nbtToList(Interpreter interpreter, class_2483<?> list, int depth) {
        ArucasList nbtList = new ArucasList();
        if (list == null || --depth < 0) {
            return nbtList;
        }
        for (class_2520 element : list) {
            nbtList.add(ClientScriptUtils.nbtToValue(interpreter, element, depth));
        }
        return nbtList;
    }

    public static ClassInstance nbtToValue(Interpreter interpreter, class_2520 element, int depth) {
        if (element instanceof class_2487) {
            class_2487 inCompound = (class_2487)element;
            return interpreter.create(MapDef.class, (Object)ClientScriptUtils.nbtToMap(interpreter, inCompound, depth));
        }
        if (element instanceof class_2483) {
            class_2483 nbtList = (class_2483)element;
            return interpreter.create(ListDef.class, (Object)ClientScriptUtils.nbtToList(interpreter, nbtList, depth));
        }
        if (element instanceof class_2514) {
            class_2514 nbtNumber = (class_2514)element;
            return interpreter.create(NumberDef.class, (Object)nbtNumber.method_10697());
        }
        if (element == class_2491.field_21033) {
            return interpreter.getNull();
        }
        return interpreter.create(StringDef.class, (Object)element.method_10714());
    }

    public static class_2487 mapToNbt(Interpreter interpreter, ArucasMap map, int depth) {
        class_2487 compound = new class_2487();
        if (map == null || depth < 0) {
            return compound;
        }
        for (Pair values : map.pairSet()) {
            compound.method_10566(((ClassInstance)values.component1()).toString(interpreter), ClientScriptUtils.valueToNbt(interpreter, (ClassInstance)values.component2(), depth));
        }
        return compound;
    }

    public static class_2499 collectionToNbt(Interpreter interpreter, Collection<ClassInstance> collection, int depth) {
        class_2499 list = new class_2499();
        if (collection == null || depth < 0) {
            return list;
        }
        for (ClassInstance instance : collection) {
            class_2520 element = ClientScriptUtils.valueToNbt(interpreter, instance, depth);
            list.method_10533(list.size(), element);
        }
        return list;
    }

    public static class_2520 valueToNbt(Interpreter interpreter, ClassInstance value, int depth) {
        Object primitive = value.getPrimitive(MapDef.class);
        if (primitive != null) {
            return ClientScriptUtils.mapToNbt(interpreter, (ArucasMap)primitive, depth);
        }
        primitive = value.getPrimitive(CollectionDef.class);
        if (primitive != null) {
            return ClientScriptUtils.collectionToNbt(interpreter, ((ArucasCollection)primitive).asCollection(), depth);
        }
        primitive = value.getPrimitive(NumberDef.class);
        if (primitive != null) {
            return class_2489.method_23241((double)((Double)primitive));
        }
        if (value == interpreter.getNull()) {
            return class_2491.field_21033;
        }
        return class_2519.method_23256((String)value.toString(interpreter));
    }

    public static ClassInstance mapToRule(ArucasMap map, Interpreter interpreter) {
        String type = (String)ClientScriptUtils.getFieldInMap(map, interpreter, "type", StringDef.class);
        if (type == null) {
            throw new RuntimeError("Config map must contain 'type' that is a string");
        }
        String name = (String)ClientScriptUtils.getFieldInMap(map, interpreter, "name", StringDef.class);
        if (name == null) {
            throw new RuntimeError("Config map must contain 'name' that is a string");
        }
        String description = (String)ClientScriptUtils.getFieldInMap(map, interpreter, "description", StringDef.class);
        String optionalInfo = (String)ClientScriptUtils.getFieldInMap(map, interpreter, "optional_info", StringDef.class);
        String currentValue = (String)ClientScriptUtils.getFieldInMap(map, interpreter, "value", StringDef.class);
        String category = (String)ClientScriptUtils.getFieldInMap(map, interpreter, "category", StringDef.class);
        ArucasFunction function = (ArucasFunction)ClientScriptUtils.getFieldInMap(map, interpreter, "listener", FunctionDef.class);
        int maxLength = ((Number)Objects.requireNonNullElse((Number)ClientScriptUtils.getFieldInMap(map, interpreter, "max_length", NumberDef.class), 32)).intValue();
        ClassInstance defaultValue = map.get(interpreter, interpreter.create(StringDef.class, (Object)"default_value"));
        ClientRule clientRule = switch (type.toLowerCase()) {
            case "boolean" -> {
                Boolean bool;
                Boolean v0 = bool = defaultValue == null ? null : (Boolean)defaultValue.getPrimitive(BooleanDef.class);
                if (bool != null) {
                    yield new BooleanClientRule(name, description, bool, category);
                }
                yield new BooleanClientRule(name, description, category);
            }
            case "cycle" -> {
                String defaultCycle;
                ArucasList list = (ArucasList)ClientScriptUtils.getFieldInMap(map, interpreter, "cycle_values", ListDef.class);
                if (list == null) {
                    throw new RuntimeError("'cycle' type must have 'cycle_values' as a list");
                }
                ArrayList<String> cycles = new ArrayList<String>();
                for (ClassInstance classInstance : list) {
                    cycles.add(classInstance.toString(interpreter));
                }
                String v2 = defaultCycle = defaultValue == null ? null : (String)defaultValue.getPrimitive(StringDef.class);
                if (defaultCycle != null) {
                    yield new CycleClientRule(name, description, cycles, defaultCycle, category, null);
                }
                yield new CycleClientRule(name, description, (List<String>)cycles, category);
            }
            case "double" -> {
                Double defaultNumber;
                Double v3 = defaultNumber = defaultValue == null ? null : (Double)defaultValue.getPrimitive(NumberDef.class);
                if (defaultNumber != null) {
                    yield new DoubleClientRule(name, description, defaultNumber, category);
                }
                yield new DoubleClientRule(name, description, 0.0, category);
            }
            case "double_slider" -> {
                ArucasList.ArucasListIterator defaultNumber;
                Double min = (Double)ClientScriptUtils.getFieldInMap(map, interpreter, "min", NumberDef.class);
                if (min == null) {
                    throw new RuntimeError("'double_slider' type must have 'min' as a number");
                }
                Double max = (Double)ClientScriptUtils.getFieldInMap(map, interpreter, "max", NumberDef.class);
                if (max == null) {
                    throw new RuntimeError("'double_slider' type must have 'max' as a number");
                }
                Double v4 = defaultNumber = defaultValue == null ? null : (Double)defaultValue.getPrimitive(NumberDef.class);
                if (defaultNumber != null) {
                    yield new DoubleSliderClientRule(name, description, defaultNumber.doubleValue(), category, min, max);
                }
                yield new DoubleSliderClientRule(name, description, 0.0, category, min, max);
            }
            case "integer" -> {
                Double defaultNumber;
                Double v5 = defaultNumber = defaultValue == null ? null : (Double)defaultValue.getPrimitive(NumberDef.class);
                if (defaultNumber != null) {
                    yield new IntegerClientRule(name, description, defaultNumber.intValue(), category);
                }
                yield new IntegerClientRule(name, description, 0, category);
            }
            case "integer_slider" -> {
                ArucasList.ArucasListIterator defaultNumber;
                Double min = (Double)ClientScriptUtils.getFieldInMap(map, interpreter, "min", NumberDef.class);
                if (min == null) {
                    throw new RuntimeError("'integer_slider' type must have 'min' as a number");
                }
                Double max = (Double)ClientScriptUtils.getFieldInMap(map, interpreter, "max", NumberDef.class);
                if (max == null) {
                    throw new RuntimeError("'integer_slider' type must have 'max' as a number");
                }
                Number v6 = defaultNumber = defaultValue == null ? (Number)null : (Number)((Number)defaultValue.getPrimitive(NumberDef.class));
                if (defaultNumber != null) {
                    yield new IntegerSliderClientRule(name, description, defaultNumber.intValue(), category, min.intValue(), max.intValue());
                }
                yield new IntegerSliderClientRule(name, description, 0, category, min.intValue(), max.intValue());
            }
            case "list" -> {
                ArucasList defaultList;
                ArrayList<String> configData = new ArrayList<String>();
                ArucasList v7 = defaultList = defaultValue == null ? null : (ArucasList)defaultValue.getPrimitive(ListDef.class);
                if (defaultList != null) {
                    for (ClassInstance listValue : defaultList) {
                        configData.add(listValue.toString(interpreter));
                    }
                }
                ListClientRule listClientRule = new ListClientRule(name, description, (List<String>)configData, category);
                listClientRule.setMaxLength(maxLength);
                yield listClientRule;
            }
            case "string" -> {
                StringClientRule stringClientRule = new StringClientRule(name, description, defaultValue == null ? "" : defaultValue.toString(interpreter), category);
                stringClientRule.setMaxLength(maxLength);
                yield stringClientRule;
            }
            default -> throw new RuntimeError("Invalid config type '%s'".formatted(type));
        };
        ClassInstance instance = interpreter.convertValue((Object)clientRule);
        if (function != null) {
            Interpreter parent = interpreter.branch();
            clientRule.addListener(object -> parent.runAsync(() -> {
                function.invoke(parent.branch(), List.of(instance));
                return null;
            }));
        }
        if (currentValue != null) {
            clientRule.setValueFromString(currentValue);
        }
        clientRule.setOptionalInfo(optionalInfo);
        return instance;
    }

    public static ArgumentBuilder<class_2168, ?> mapToCommand(ArucasMap arucasMap, Interpreter interpreter) {
        return new CommandParser(arucasMap, interpreter).parse();
    }

    public static RequiredArgumentBuilder<class_2168, ?> parseArgument(String argumentName, String typeName, Collection<String> suggests, CommandParser.ArgumentGetter getter) {
        SuggestionProvider extraSuggestion = null;
        Object type = switch (typeName.toLowerCase()) {
            case "word" -> StringArgumentType.word();
            case "string", "quote" -> StringArgumentType.word();
            case "boolean" -> BoolArgumentType.bool();
            case "itemstack" -> class_2287.method_9776((class_7157)CommandRegister.getRegistryAccess());
            case "block" -> class_2257.method_9653((class_7157)CommandRegister.getRegistryAccess());
            case "greedystring" -> StringArgumentType.greedyString();
            case "entity" -> ClientEntityArgumentType.entity();
            case "entities" -> ClientEntityArgumentType.entities();
            case "blockpos" -> class_2262.method_9698();
            case "pos" -> class_2277.method_9737();
            case "effect" -> class_7733.method_45603((class_7157)CommandRegister.getRegistryAccess(), (class_5321)class_7924.field_41208);
            case "particle" -> class_2223.method_9417((class_7157)CommandRegister.getRegistryAccess());
            case "enchantmentid" -> class_7733.method_45603((class_7157)CommandRegister.getRegistryAccess(), (class_5321)class_7924.field_41265);
            case "entityid" -> {
                extraSuggestion = class_2321.field_10935;
                yield class_7733.method_45603((class_7157)CommandRegister.getRegistryAccess(), (class_5321)class_7924.field_41266);
            }
            case "recipeid" -> {
                extraSuggestion = class_2321.field_10932;
                yield class_2232.method_9441();
            }
            case "biomeid" -> class_7733.method_45603((class_7157)CommandRegister.getRegistryAccess(), (class_5321)class_7924.field_41236);
            case "playername" -> {
                extraSuggestion = (c, b) -> CommandHelper.suggestOnlinePlayers(b);
                yield StringArgumentType.word();
            }
            case "double" -> {
                Double max;
                Double min;
                Double v1 = min = getter == null ? null : (Double)getter.get("min", NumberDef.class);
                if (min != null) {
                    max = (Double)getter.get("max", NumberDef.class);
                    if (max != null) {
                        yield DoubleArgumentType.doubleArg((double)min, (double)max);
                    }
                    yield DoubleArgumentType.doubleArg((double)min);
                }
                yield DoubleArgumentType.doubleArg();
            }
            case "integer" -> {
                Double max;
                Double min;
                Double v2 = min = getter == null ? null : (Double)getter.get("min", NumberDef.class);
                if (min != null) {
                    max = (Double)getter.get("max", NumberDef.class);
                    if (max != null) {
                        yield IntegerArgumentType.integer((int)min.intValue(), (int)max.intValue());
                    }
                    yield IntegerArgumentType.integer((int)min.intValue());
                }
                yield IntegerArgumentType.integer();
            }
            case "enum" -> {
                ClassDefinition definition;
                ClassDefinition v3 = definition = getter == null ? null : (ClassDefinition)getter.get("enum", TypeDef.class);
                if (definition instanceof EnumDefinition) {
                    EnumDefinition enumDefinition = (EnumDefinition)definition;
                    yield DefinitionArgumentType.enumeration(enumDefinition);
                }
                throw new RuntimeError("Enum argument type must contain 'enum: <Type>'");
            }
            default -> throw new RuntimeError("Invalid argument type");
        };
        RequiredArgumentBuilder argumentBuilder = class_2170.method_9244((String)argumentName, (ArgumentType)type);
        if (extraSuggestion != null) {
            argumentBuilder.suggests(extraSuggestion);
        }
        if (suggests != null) {
            argumentBuilder.suggests((c, b) -> class_2172.method_9265((Iterable)suggests, (SuggestionsBuilder)b));
        }
        return argumentBuilder;
    }

    public static ClassInstance commandArgumentToValue(Object object, Interpreter interpreter) throws CommandSyntaxException {
        if (object instanceof class_2267) {
            class_2267 posArgument = (class_2267)object;
            object = posArgument.method_9708((class_2168)new FakeCommandSource(EssentialUtils.getPlayer()));
        }
        if (object instanceof ClientEntitySelector) {
            ClientEntitySelector selector = (ClientEntitySelector)object;
            FakeCommandSource source = new FakeCommandSource(EssentialUtils.getPlayer());
            Object object2 = object = selector.isSingleTarget() ? selector.getEntity(source) : selector.getEntities(source);
        }
        if (object instanceof class_6880.class_6883) {
            class_6880.class_6883 reference = (class_6880.class_6883)object;
            return interpreter.convertValue(reference.comp_349());
        }
        return interpreter.convertValue(object);
    }

    private static <T extends PrimitiveDefinition<V>, V> V getFieldInMap(ArucasMap map, Interpreter interpreter, String field, Class<T> type) {
        ClassInstance instance = map.get(interpreter, interpreter.create(StringDef.class, (Object)field));
        return (V)(instance == null ? null : instance.getPrimitive(type));
    }

    static {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            for (TickedKey key : HELD_KEYS.values()) {
                key.tick();
            }
        });
    }

    public static class TickedKey {
        private final class_304 binding;
        private final int interval;
        private int tick = 0;

        public TickedKey(class_304 binding, int interval) {
            this.binding = binding;
            this.interval = interval;
        }

        void tick() {
            if (this.tick++ >= this.interval) {
                this.binding.method_23481(true);
                class_3675.class_306 key = ((KeyBindingAccessor)this.binding).getBoundKey();
                class_304.method_1420((class_3675.class_306)key);
                this.tick = 0;
            }
        }
    }

    public static class CommandParser {
        public static final SimpleCommandExceptionType NO_ARGS = new SimpleCommandExceptionType((Message)Texts.NO_ARGUMENTS);
        private final Interpreter interpreter;
        private final String commandName;
        private final ArucasMap subCommandMap;
        private final ArucasMap argumentMap;

        CommandParser(ArucasMap commandMap, Interpreter interpreter) {
            this.interpreter = interpreter.branch();
            this.commandName = (String)ClientScriptUtils.getFieldInMap(commandMap, interpreter, "name", StringDef.class);
            if (this.commandName == null) {
                throw new RuntimeError("Command map must contain 'name: <String>'");
            }
            this.subCommandMap = (ArucasMap)ClientScriptUtils.getFieldInMap(commandMap, interpreter, "subcommands", MapDef.class);
            this.argumentMap = (ArucasMap)ClientScriptUtils.getFieldInMap(commandMap, interpreter, "arguments", MapDef.class);
        }

        ArgumentBuilder<class_2168, ?> parse() {
            LiteralArgumentBuilder baseCommand = class_2170.method_9247((String)this.commandName);
            if (this.subCommandMap == null) {
                return baseCommand;
            }
            return this.command((ArgumentBuilder<class_2168, ?>)baseCommand, this.subCommandMap);
        }

        private ArgumentBuilder<class_2168, ?> command(ArgumentBuilder<class_2168, ?> parent, ArucasMap childMap) {
            for (Pair pair : childMap.pairSet()) {
                String key = (String)((ClassInstance)pair.component1()).getPrimitive(StringDef.class);
                if (key == null) {
                    throw new RuntimeError("Expected string value in subcommand map");
                }
                if (key.isBlank()) {
                    ArucasFunction function = (ArucasFunction)((ClassInstance)pair.component2()).getPrimitive(FunctionDef.class);
                    if (function == null) {
                        throw new RuntimeError("Expected function value");
                    }
                    parent.executes(c -> {
                        Collection<ParsedArgument<?, ?>> arguments = CommandHelper.getArguments((CommandContext<class_2168>)c);
                        if (arguments == null) {
                            throw NO_ARGS.create();
                        }
                        ArrayList<ClassInstance> list = new ArrayList<ClassInstance>(arguments.size());
                        for (ParsedArgument<?, ?> argument : arguments) {
                            list.add(ClientScriptUtils.commandArgumentToValue(argument.getResult(), this.interpreter));
                        }
                        this.interpreter.runAsync(() -> {
                            function.invoke(this.interpreter.branch(), list);
                            return null;
                        });
                        return 1;
                    });
                    continue;
                }
                ArucasMap value = (ArucasMap)((ClassInstance)pair.component2()).getPrimitive(MapDef.class);
                if (value == null) {
                    throw new RuntimeError("Expected map value for '%s'".formatted(key));
                }
                String[] arguments = key.split(" ");
                if (arguments.length > 1) {
                    ArgumentBuilder current = this.subCommand(arguments[arguments.length - 1], value);
                    for (int i = arguments.length - 2; i >= 0; --i) {
                        String name = arguments[i];
                        current = this.connectedCommand(name).then(current);
                    }
                    parent.then(current);
                    continue;
                }
                parent.then(this.subCommand(key, value));
            }
            return parent;
        }

        private ArgumentBuilder<class_2168, ?> subCommand(String string, ArucasMap childMap) {
            return this.command(this.connectedCommand(string), childMap);
        }

        private ArgumentBuilder<class_2168, ?> connectedCommand(String string) {
            ArucasMap subMap;
            if (string.charAt(0) != '<' || string.charAt(string.length() - 1) != '>') {
                return class_2170.method_9247((String)string);
            }
            string = string.substring(1, string.length() - 1);
            if (this.argumentMap != null && (subMap = (ArucasMap)ClientScriptUtils.getFieldInMap(this.argumentMap, this.interpreter, string, MapDef.class)) != null) {
                return this.getArgument(string, subMap);
            }
            throw new RuntimeError("Expected map value for argument '%s'".formatted(string));
        }

        private ArgumentBuilder<class_2168, ?> getArgument(String name, final ArucasMap arguments) {
            String argument = (String)ClientScriptUtils.getFieldInMap(arguments, this.interpreter, "type", StringDef.class);
            if (argument == null) {
                throw new RuntimeError("Expected string for 'type' for argument '%s'".formatted(name));
            }
            List<String> suggestions = null;
            ArucasList suggests = (ArucasList)ClientScriptUtils.getFieldInMap(arguments, this.interpreter, "suggests", ListDef.class);
            if (suggests != null) {
                suggestions = suggests.stream().map(i -> i.toString(this.interpreter)).toList();
            }
            RequiredArgumentBuilder<class_2168, ?> argumentBuilder = ClientScriptUtils.parseArgument(name, argument, suggestions, new ArgumentGetter(){

                @Override
                public <T extends PrimitiveDefinition<V>, V> V get(String fieldName, Class<T> clazz) {
                    return ClientScriptUtils.getFieldInMap(arguments, interpreter, fieldName, clazz);
                }
            });
            ArucasFunction suggester = (ArucasFunction)ClientScriptUtils.getFieldInMap(arguments, this.interpreter, "suggester", FunctionDef.class);
            if (suggester != null) {
                argumentBuilder.suggests((c, b) -> {
                    Collection<ParsedArgument<?, ?>> commandArguments = CommandHelper.getArguments((CommandContext<class_2168>)c);
                    if (commandArguments == null) {
                        throw NO_ARGS.create();
                    }
                    Interpreter branch = this.interpreter.branch();
                    ArrayList<ClassInstance> list = new ArrayList<ClassInstance>();
                    for (ParsedArgument<?, ?> arg : commandArguments) {
                        list.add(ClientScriptUtils.commandArgumentToValue(arg.getResult(), branch));
                    }
                    return (CompletableFuture)branch.runSafe((Object)Suggestions.empty(), () -> {
                        ArucasCollection collection = (ArucasCollection)suggester.invoke(branch, list).getPrimitive(CollectionDef.class);
                        if (collection != null) {
                            List<String> suggested = collection.asCollection().stream().map(i -> i.toString(branch)).toList();
                            return class_2172.method_9265(suggested, (SuggestionsBuilder)b);
                        }
                        throw new RuntimeError("Suggester did not return a list");
                    });
                });
            }
            return argumentBuilder;
        }

        public static interface ArgumentGetter {
            public <T extends PrimitiveDefinition<V>, V> V get(String var1, Class<T> var2);
        }
    }
}

