/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils.carpet;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.RuleHelper;
import carpet.api.settings.SettingsManager;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class CarpetUtils {
    public static boolean isRuleCommand(CarpetRule<?> rule) {
        return rule.categories().contains("command");
    }

    public static String getRuleSettingsManagerId(CarpetRule<?> rule) {
        return rule.settingsManager().identifier();
    }

    public static String getRuleDescription(CarpetRule<?> rule) {
        return RuleHelper.translatedDescription(rule);
    }

    public static String getRuleExtraInfo(CarpetRule<?> rule) {
        StringBuilder builder = new StringBuilder();
        if (rule.extraInfo() != null) {
            for (class_2561 info : rule.extraInfo()) {
                builder.append(info.getString()).append(" ");
            }
        }
        return builder.toString();
    }

    public static String getRuleValueAsString(CarpetRule<?> rule) {
        return RuleHelper.toRuleString((Object)rule.value());
    }

    public static String getRuleDefaultValueAsString(CarpetRule<?> rule) {
        return RuleHelper.toRuleString((Object)rule.defaultValue());
    }

    @Nullable
    public static CarpetRule<?> getCarpetRule(String name) {
        for (SettingsManager manager : CarpetUtils.getAllCarpetSettingsManagers()) {
            CarpetRule rule = manager.getCarpetRule(name);
            if (rule == null) continue;
            return rule;
        }
        return null;
    }

    public static void forEachCarpetRule(BiConsumer<CarpetRule<?>, String> consumer) {
        for (SettingsManager manager : CarpetUtils.getAllCarpetSettingsManagers()) {
            for (CarpetRule rule : manager.getCarpetRules()) {
                String id = manager.identifier();
                consumer.accept(rule, id);
            }
        }
    }

    private static Collection<SettingsManager> getAllCarpetSettingsManagers() {
        LinkedList<SettingsManager> managers = new LinkedList<SettingsManager>();
        managers.add((SettingsManager)CarpetServer.settingsManager);
        for (CarpetExtension extension : CarpetServer.extensions) {
            SettingsManager manager = extension.extensionSettingsManager();
            if (manager == null) continue;
            managers.add(manager);
        }
        return managers;
    }
}

