/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import me.senseiwells.essentialclient.feature.CarpetClient;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.rule.carpet.CarpetClientRule;
import me.senseiwells.essentialclient.rule.carpet.IntegerCarpetRule;
import me.senseiwells.essentialclient.rule.carpet.StringCarpetRule;
import me.senseiwells.essentialclient.rule.client.BooleanClientRule;
import me.senseiwells.essentialclient.utils.misc.Scheduler;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3797;
import net.minecraft.class_5134;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_746;

public class EssentialUtils {
    private static final Path ESSENTIAL_CLIENT_PATH = FabricLoader.getInstance().getConfigDir().resolve("EssentialClient");
    private static final ModContainer ESSENTIAL_CONTAINER;
    private static final boolean DEV;
    public static final URI WIKI_URL;
    public static final URI SCRIPT_WIKI_URL;

    public static void sendMessageToActionBar(String message) {
        class_310 client = EssentialUtils.getClient();
        if (client.field_1724 != null) {
            client.execute(() -> client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), true));
        }
    }

    public static void sendMessageToActionBar(class_2561 text) {
        class_310 client = EssentialUtils.getClient();
        if (client.field_1724 != null) {
            client.execute(() -> client.field_1724.method_7353(text, true));
        }
    }

    public static void sendMessage(String message) {
        class_310 client = EssentialUtils.getClient();
        if (client.field_1724 != null) {
            client.execute(() -> client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false));
        }
    }

    public static void sendMessage(class_2561 text) {
        class_310 client = EssentialUtils.getClient();
        if (client.field_1724 != null) {
            client.execute(() -> client.field_1724.method_7353(text, false));
        }
    }

    public static void sendChatMessage(String message) {
        class_310 client = EssentialUtils.getClient();
        if (client.field_1724 != null) {
            client.execute(() -> {
                if (message.startsWith("/")) {
                    client.field_1724.field_3944.method_45730(message.substring(1));
                    return;
                }
                client.field_1724.field_3944.method_45729(message);
            });
        }
    }

    public static Path getEssentialConfigFile() {
        return ESSENTIAL_CLIENT_PATH;
    }

    public static class_310 getClient() {
        return class_310.method_1551();
    }

    public static class_746 getPlayer() {
        return EssentialUtils.getClient().field_1724;
    }

    public static class_638 getWorld() {
        return EssentialUtils.getClient().field_1687;
    }

    public static class_636 getInteractionManager() {
        return EssentialUtils.getClient().field_1761;
    }

    public static class_634 getNetworkHandler() {
        return EssentialUtils.getClient().method_1562();
    }

    public static class_5455 getRegistryManager() {
        return EssentialUtils.getWorld().method_30349();
    }

    public static class_640 getPlayerListEntry() {
        return EssentialUtils.getNetworkHandler().method_2871(EssentialUtils.getPlayer().method_5667());
    }

    public static boolean playerHasOp() {
        class_746 player = EssentialUtils.getPlayer();
        return player != null && player.method_5687(2);
    }

    public static String getMinecraftVersion() {
        return class_3797.field_25319.method_48019();
    }

    public static boolean isDev() {
        return DEV;
    }

    public static boolean isModInstalled(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static String getEssentialVersion() {
        return ESSENTIAL_CONTAINER.getMetadata().getVersion().getFriendlyString();
    }

    public static boolean isStackableShulkers(class_1792 item) {
        if (EssentialUtils.getClient() != null && EssentialUtils.isRuleWithCarpet(ClientRules.STACKABLE_SHULKERS_IN_PLAYER_INVENTORIES)) {
            class_1747 b;
            return item instanceof class_1747 && (b = (class_1747)item).method_7711() instanceof class_2480;
        }
        return false;
    }

    public static boolean isStackableShulkerWithItems() {
        return EssentialUtils.isRuleWithCarpet(ClientRules.STACKABLE_SHULKERS_WITH_ITEMS);
    }

    public static boolean isRuleWithCarpet(BooleanClientRule rule) {
        return EssentialUtils.getClient().method_1542() && (Boolean)rule.getValue() != false || EssentialUtils.isCarpetRuleTrue(rule.getName());
    }

    private static boolean isCarpetRuleTrue(String string) {
        Boolean b;
        Object t;
        CarpetClientRule<?> rule = CarpetClient.INSTANCE.getRule(string);
        return rule != null && (t = rule.getValue()) instanceof Boolean && (b = (Boolean)t) != false;
    }

    public static boolean canMineBlock(class_2338 pos) {
        double z;
        double y;
        class_746 player = EssentialUtils.getPlayer();
        double x = player.method_23317() - (double)pos.method_10263() - 0.5;
        if (x * x + (y = player.method_23318() - (double)pos.method_10264() + 1.0) * y + (z = player.method_23321() - (double)pos.method_10260() - 0.5) * z > 36.0 || player.method_5770().method_31606(pos) || !player.method_5770().method_8621().method_11952(pos)) {
            return false;
        }
        if (player.method_21701(player.method_5770(), pos, EssentialUtils.getInteractionManager().method_2920())) {
            return false;
        }
        class_2680 state = player.method_5770().method_8320(pos);
        return !state.method_26215() && !state.method_28498((class_2769)class_2404.field_11278) && state.method_26214((class_1922)EssentialUtils.getWorld(), pos) >= 0.0f;
    }

    public static void mineBlock(class_2338 pos, Supplier<Boolean> condition, CompletableFuture<Void> future) {
        if (future.isCancelled()) {
            return;
        }
        if (EssentialUtils.canMineBlock(pos) && condition.get().booleanValue()) {
            EssentialUtils.getInteractionManager().method_2902(pos, class_2350.field_11033);
            EssentialUtils.getPlayer().method_6104(class_1268.field_5808);
            Scheduler.schedule(0, () -> EssentialUtils.mineBlock(pos, condition, future));
            return;
        }
        future.complete(null);
    }

    public static float getBlockBreakingSpeed(class_1799 itemStack, class_2680 blockState, class_1657 player) {
        class_1324 attribute;
        class_1293 effectInstance;
        float multiplier = itemStack.method_7924(blockState);
        if (multiplier > 1.0f) {
            multiplier += (float)player.method_45325(class_5134.field_51581);
        }
        if (class_1292.method_5576((class_1309)player)) {
            multiplier *= 1.0f + ((float)class_1292.method_5575((class_1309)player) + 1.0f) * 0.2f;
        }
        if ((effectInstance = player.method_6112(class_1294.field_5901)) != null) {
            multiplier *= (switch (effectInstance.method_5578()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.027f;
                default -> 8.1E-4f;
            });
        }
        if (player.method_5777(class_3486.field_15517) && (attribute = player.method_5996(class_5134.field_51576)) != null) {
            multiplier *= (float)attribute.method_6194();
        }
        if (!player.method_24828()) {
            multiplier /= 5.0f;
        }
        return multiplier;
    }

    public static class_2338 vec3dToBlockPos(class_243 position) {
        return new class_2338(class_3532.method_15357((double)position.field_1352), class_3532.method_15357((double)position.field_1351), class_3532.method_15357((double)position.field_1350));
    }

    public static class_2338 vec3dToBlockPos(double x, double y, double z) {
        return new class_2338(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z));
    }

    public static int getMaxChatLength(int fallback) {
        if (CarpetClient.INSTANCE.isServerCarpet()) {
            IntegerCarpetRule intRule;
            int maxLength;
            CarpetClientRule<?> rule = CarpetClient.INSTANCE.getRule("maxChatLength");
            if (rule instanceof IntegerCarpetRule && (maxLength = ((Integer)(intRule = (IntegerCarpetRule)rule).getValue()).intValue()) > 0) {
                return maxLength;
            }
            if (rule instanceof StringCarpetRule) {
                StringCarpetRule stringRule = (StringCarpetRule)rule;
                try {
                    maxLength = Integer.parseInt((String)stringRule.getValue());
                    if (maxLength >= 0) {
                        return maxLength;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return fallback;
    }

    public static <T extends Throwable, V> V throwUnchecked(Throwable throwable) throws T {
        throw throwable;
    }

    public static void throwAsUnchecked(ThrowableRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception throwable) {
            EssentialUtils.throwUnchecked(throwable);
        }
    }

    public static <T> T throwAsUnchecked(ThrowableSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception throwable) {
            return (T)EssentialUtils.throwUnchecked(throwable);
        }
    }

    static {
        DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
        Optional optional = FabricLoader.getInstance().getModContainer("essential-client");
        if (optional.isEmpty()) {
            throw new IllegalStateException("EssentialClient mod container was not found?!");
        }
        ESSENTIAL_CONTAINER = (ModContainer)optional.get();
        try {
            WIKI_URL = new URI("https://github.com/senseiwells/EssentialClient/wiki");
            SCRIPT_WIKI_URL = new URI("https://github.com/senseiwells/EssentialClient/wiki/ClientScript");
            Files.createDirectories(ESSENTIAL_CLIENT_PATH, new FileAttribute[0]);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface ThrowableRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowableSupplier<T> {
        public T get() throws Exception;
    }
}

