/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.rule.game;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.senseiwells.essentialclient.mixins.gameRuleSync.GameRuleAccessor;
import me.senseiwells.essentialclient.rule.game.BooleanGameRule;
import me.senseiwells.essentialclient.rule.game.GameRule;
import me.senseiwells.essentialclient.rule.game.IntegerGameRule;
import net.minecraft.class_1928;

public class VanillaGameRules {
    private static final Map<String, GameRule<?>> GAME_RULES = new HashMap();
    public static final BooleanGameRule DO_FIRE_TICK = VanillaGameRules.registerBoolean("doFireTick", "Whether fire should spread and naturally extinguish", true, class_1928.field_19387);
    public static final BooleanGameRule MOB_GRIEFING = VanillaGameRules.registerBoolean("mobGriefing", "Whether creepers, zombies, endermen, ghasts, withers, ender dragons, rabbits, sheep, villagers, silverfish, snow golems, and end crystals should be able to change blocks, and whether mobs can pick up items. When mobGriefing is disabled, piglins will not pick up gold ingots, but a player can still barter with them by using the item on the mob. Similarly, villagers will not pick up food items but can still breed until they run out of any food already in their inventory. This also affects the capability of zombie-like creatures like zombified piglins and drowned to pathfind to turtle eggs", true, class_1928.field_19388);
    public static final BooleanGameRule KEEP_INVENTORY = VanillaGameRules.registerBoolean("keepInventory", "Whether the player should keep items and experience in their inventory after death", false, class_1928.field_19389);
    public static final BooleanGameRule DO_MOB_SPAWNING = VanillaGameRules.registerBoolean("doMobSpawning", "Whether mobs should naturally spawn. Does not affect monster spawners", true, class_1928.field_19390);
    public static final BooleanGameRule DO_MOB_LOOT = VanillaGameRules.registerBoolean("doMobLoot", "Whether mobs should drop items and experience orbs", true, class_1928.field_19391);
    public static final BooleanGameRule DO_TILE_DROPS = VanillaGameRules.registerBoolean("doTileDrops", "Whether blocks should have drops", true, class_1928.field_19392);
    public static final BooleanGameRule DO_ENTITY_DROPS = VanillaGameRules.registerBoolean("doEntityDrops", "Whether entities that are not mobs should have drops", true, class_1928.field_19393);
    public static final BooleanGameRule COMMAND_BLOCK_OUTPUT = VanillaGameRules.registerBoolean("commandBlockOutput", "Whether command blocks should notify admins when they perform commands", true, class_1928.field_19394);
    public static final BooleanGameRule NATURAL_REGENERATION = VanillaGameRules.registerBoolean("naturalRegeneration", "Whether the player can regenerate health naturally if their hunger is full enough (doesn't affect external healing, such as golden apples, the Regeneration effect, etc.)", true, class_1928.field_19395);
    public static final BooleanGameRule DO_DAYLIGHT_CYCLE = VanillaGameRules.registerBoolean("doDaylightCycle", "Whether the daylight cycle and moon phases progress", true, class_1928.field_19396);
    public static final BooleanGameRule LOG_ADMIN_COMMANDS = VanillaGameRules.registerBoolean("logAdminCommands", "Whether to log admin commands to server log", true, class_1928.field_19397);
    public static final BooleanGameRule SHOW_DEATH_MESSAGES = VanillaGameRules.registerBoolean("showDeathMessages", "Whether death messages are put into chat when a player dies. Also affects whether a message is sent to the pet's owner when the pet dies.", true, class_1928.field_19398);
    public static final BooleanGameRule SEND_COMMAND_FEEDBACK = VanillaGameRules.registerBoolean("sendCommandFeedback", "Whether the feedback from commands executed by a player should show up in chat. Also affects the default behavior of whether command blocks store their output text", true, class_1928.field_19400);
    public static final BooleanGameRule REDUCED_DEBUG_INFO = VanillaGameRules.registerBoolean("reducedDebugInfo", "Whether the debug screen shows all or reduced information; and whether the effects of F3 + B (entity hitboxes) and F3 + G (chunk boundaries) are shown", false, class_1928.field_19401);
    public static final BooleanGameRule SPECTATORS_GENERATE_CHUNKS = VanillaGameRules.registerBoolean("spectatorsGenerateChunks", "Whether players in spectator mode can generate chunks", true, class_1928.field_19402);
    public static final BooleanGameRule DISABLE_ELYTRA_MOVEMENT_CHECK = VanillaGameRules.registerBoolean("disableElytraMovementCheck", "Whether the server should skip checking player speed when the player is wearing elytra. Often helps with jittering due to lag in multiplayer", false, class_1928.field_19404);
    public static final BooleanGameRule DO_WEATHER_CYCLE = VanillaGameRules.registerBoolean("doWeatherCycle", "Whether the weather can change naturally. The /weather command can still change weather", true, class_1928.field_19406);
    public static final BooleanGameRule DO_LIMITED_CRAFTING = VanillaGameRules.registerBoolean("doLimitedCrafting", "Whether players should be able to craft only those recipes that they've unlocked first", false, class_1928.field_19407);
    public static final BooleanGameRule ANNOUNCE_ADVANCEMENTS = VanillaGameRules.registerBoolean("announceAdvancements", "Whether advancements should be announced in chat", true, class_1928.field_19409);
    public static final BooleanGameRule DISABLE_RAIDS = VanillaGameRules.registerBoolean("disableRaids", "Whether raids are disabled", false, class_1928.field_19422);
    public static final BooleanGameRule DO_INSOMNIA = VanillaGameRules.registerBoolean("doInsomnia", "Whether phantoms can spawn in the nighttime", true, class_1928.field_20637);
    public static final BooleanGameRule DO_IMMEDIATE_RESPAWN = VanillaGameRules.registerBoolean("doImmediateRespawn", "Players respawn immediately without showing the death screen", false, class_1928.field_20638);
    public static final BooleanGameRule DROWNING_DAMAGE = VanillaGameRules.registerBoolean("drowningDamage", "Whether the player should take damage when drowning", true, class_1928.field_20634);
    public static final BooleanGameRule FALL_DAMAGE = VanillaGameRules.registerBoolean("fallDamage", "Whether the player should take fall damage", true, class_1928.field_20635);
    public static final BooleanGameRule FIRE_DAMAGE = VanillaGameRules.registerBoolean("fireDamage", "Whether the player should take damage in fire, lava, campfires, or on magma blocks", true, class_1928.field_20636);
    public static final BooleanGameRule FREEZE_DAMAGE = VanillaGameRules.registerBoolean("freezeDamage", "Whether the player should take damage when inside powder snow", true, null);
    public static final BooleanGameRule DO_PATROL_SPAWNING = VanillaGameRules.registerBoolean("doPatrolSpawning", "Whether patrols can spawn", true, class_1928.field_21831);
    public static final BooleanGameRule DO_TRADER_SPAWNING = VanillaGameRules.registerBoolean("doTraderSpawning", "Whether wandering traders can spawn", true, class_1928.field_21832);
    public static final BooleanGameRule FORGIVE_DEAD_PLAYERS = VanillaGameRules.registerBoolean("forgiveDeadPlayers", "Makes angered neutral mobs stop being angry when the targeted player dies nearby", true, class_1928.field_25401);
    public static final BooleanGameRule UNIVERSAL_ANGER = VanillaGameRules.registerBoolean("universalAnger", "Makes angered neutral mobs attack any nearby player, not just the player that angered them. Works best if forgiveDeadPlayers is disabled", false, class_1928.field_25402);
    public static final BooleanGameRule DO_WARDEN_SPAWNING = VanillaGameRules.registerBoolean("doWardenSpawning", "Whether wardens can spawn", true, null);
    public static final BooleanGameRule BLOCK_EXPLOSION_DROP_DECAY = VanillaGameRules.registerBoolean("blockExplosionDropDecay", "Whether block loot is dropped by all blocks (false) or randomly (true) depending on how far the block is from the center of a block explosion (e.g. clicking a bed in dimensions other than the Overworld)", true, null);
    public static final BooleanGameRule MOB_EXPLOSION_DROP_DECAY = VanillaGameRules.registerBoolean("mobExplosionDropDecay", "Whether block loot is dropped by all blocks (false) or randomly (true) depending on how far the block is from the center of a mob explosion (e.g. Creeper explosion)", true, null);
    public static final BooleanGameRule TNT_EXPLOSION_DROP_DECAY = VanillaGameRules.registerBoolean("tntExplosionDropDecay", "Whether block loot is dropped by all blocks (false) or randomly (true) depending on how far the block is from the center of a TNT explosion", false, null);
    public static final BooleanGameRule GLOBAL_SOUND_EVENTS = VanillaGameRules.registerBoolean("globalSoundEvents", "Whether certain sound events are heard by all players regardless of location", true, null);
    public static final BooleanGameRule LAVA_SOURCE_CONVERSION = VanillaGameRules.registerBoolean("lavaSourceConversion", "Whether new sources of lava are allowed to form", false, null);
    public static final BooleanGameRule WATER_SOURCE_CONVERSION = VanillaGameRules.registerBoolean("waterSourceConversion", "Whether new sources of water are allowed to form", true, null);
    public static final IntegerGameRule RANDOM_TICK_SPEED = VanillaGameRules.registerInteger("randomTickSpeed", "How often a random block tick occurs (such as plant growth, leaf decay, etc.) per chunk section per game tick. 0 and negative values disables random ticks, higher numbers increase random ticks. Setting to a high integer results in high speeds of decay and growth. Numbers over 4096 make plant growth or leaf decay instantaneous", 3, class_1928.field_19399);
    public static final IntegerGameRule SPAWN_RADIUS = VanillaGameRules.registerInteger("spawnRadius", "The number of blocks outward from the world spawn coordinates that a player spawns in when first joining a server or when dying without a personal spawnpoint. Has no effect on servers where the default game mode is adventure", 10, class_1928.field_19403);
    public static final IntegerGameRule MAX_ENTITY_CRAMMING = VanillaGameRules.registerInteger("maxEntityCramming", "The maximum number of pushable entities a mob or player can push, before taking 3\u2665 suffocation damage per half-second. Setting to 0 or lower disables the rule. Damage affects survival-mode or adventure-mode players, and all mobs but bats. Pushable entities include non-spectator-mode players, any mob except bats, as well as boats and minecarts", 24, class_1928.field_19405);
    public static final IntegerGameRule MAX_COMMAND_CHAIN_LENGTH = VanillaGameRules.registerInteger("maxCommandChainLength", "The maximum length of a chain of commands that can be executed during one tick. Applies to command blocks and functions", 65536, class_1928.field_19408);
    public static final IntegerGameRule PLAYERS_SLEEPING_PERCENTAGE = VanillaGameRules.registerInteger("playersSleepingPercentage", "What percentage of players must sleep to skip the night", 100, null);
    public static final IntegerGameRule SNOW_ACCUMULATION_HEIGHT = VanillaGameRules.registerInteger("snowAccumulationHeight", "The maximum number of snow layers that can be accumulated on each block", 1, null);

    private static BooleanGameRule registerBoolean(String name, String description, boolean defaultValue, class_1928.class_4313<?> ruleKey) {
        description = (String)description + ((ruleKey = VanillaGameRules.getRuleKey(name, ruleKey)) == null ? "\n\nThis Game Rule is not available in your version" : "");
        return VanillaGameRules.register(new BooleanGameRule(name, (String)description, defaultValue, ruleKey));
    }

    private static IntegerGameRule registerInteger(String name, String description, int defaultValue, class_1928.class_4313<?> ruleKey) {
        description = (String)description + ((ruleKey = VanillaGameRules.getRuleKey(name, ruleKey)) == null ? "\n\nThis Game Rule is not available in your version" : "");
        return VanillaGameRules.register(new IntegerGameRule(name, (String)description, defaultValue, ruleKey));
    }

    private static <T extends GameRule<?>> T register(T rule) {
        GAME_RULES.put(rule.getName(), rule);
        return rule;
    }

    public static GameRule<?> ruleFromString(String name) {
        return GAME_RULES.get(name);
    }

    public static Collection<GameRule<?>> getGameRules() {
        return GAME_RULES.values();
    }

    private static class_1928.class_4313<?> getRuleKey(String name, class_1928.class_4313<?> existing) {
        if (existing != null) {
            return existing;
        }
        for (class_1928.class_4313<?> key : VanillaGameRules.getAllKeys()) {
            if (!key.method_20771().equals(name)) continue;
            return key;
        }
        return null;
    }

    private static void loadRest() {
        for (class_1928.class_4313<?> key : VanillaGameRules.getAllKeys()) {
            if (GAME_RULES.containsKey(key.method_20771())) continue;
            class_1928.class_4315 rule = GameRuleAccessor.getRules().get(key).method_20773();
            String noDescription = "Game Rule doesn't have a description... (Please Report this as a bug!)";
            if (rule instanceof class_1928.class_4310) {
                class_1928.class_4310 booleanRule = (class_1928.class_4310)rule;
                VanillaGameRules.registerBoolean(key.method_20771(), noDescription, booleanRule.method_20753(), key);
                continue;
            }
            if (!(rule instanceof class_1928.class_4312)) continue;
            class_1928.class_4312 intRule = (class_1928.class_4312)rule;
            VanillaGameRules.registerInteger(key.method_20771(), noDescription, intRule.method_20763(), key);
        }
    }

    private static Collection<class_1928.class_4313<?>> getAllKeys() {
        return GameRuleAccessor.getRules().keySet();
    }

    static {
        VanillaGameRules.loadRest();
    }
}

