/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.rule.game;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Objects;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.rule.impl.SimpleRule;
import me.senseiwells.essentialclient.utils.interfaces.Rule;
import net.minecraft.class_1074;
import net.minecraft.class_1928;

public abstract class GameRule<T>
extends SimpleRule<T> {
    private final class_1928.class_4313<?> gameRuleKey;
    private boolean isAvailable;

    public GameRule(String name, String description, T defaultValue, class_1928.class_4313<?> gameRuleKey) {
        super(name, description, defaultValue);
        this.gameRuleKey = gameRuleKey;
        this.isAvailable = false;
    }

    public final void setFromServer(String stringValue) {
        this.isAvailable = true;
        T value = this.getValueFromString(stringValue);
        if (value != null) {
            this.setValueQuietly(value);
        }
    }

    public final void reset() {
        this.isAvailable = false;
        this.setValueQuietly(this.getDefaultValue());
    }

    public final class_1928.class_4313<?> getKey() {
        return this.gameRuleKey;
    }

    @Override
    public abstract GameRule<T> shallowCopy();

    @Override
    public String getCategory() {
        return this.gameRuleKey == null ? "X" : class_1074.method_4662((String)this.gameRuleKey.method_27335().method_27328(), (Object[])new Object[0]);
    }

    public abstract T getValueFromString(String var1);

    @Override
    public final boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    public final void setValueFromString(String stringValue) {
        T value = this.getValueFromString(stringValue);
        if (value != null) {
            this.setValue(value);
        }
    }

    @Override
    public boolean changeable() {
        return EssentialClient.GAME_RULE_NET_HANDLER.canModifyRules();
    }

    @Override
    public void setValue(T value) {
        if (this.isAvailable && !Objects.equals(this.getValue(), value)) {
            EssentialClient.GAME_RULE_NET_HANDLER.sendServerRuleChange(this, value.toString());
        }
    }

    @Override
    public final T fromJson(JsonElement element) {
        return null;
    }

    @Override
    public final JsonElement toJson(T value) {
        return null;
    }

    @Override
    public final List<Rule.RuleListener<T>> getListeners() {
        return null;
    }

    @Override
    public void onValueChange() {
    }

    @Override
    public final JsonElement getValueAsJson() {
        return null;
    }

    @Override
    public final JsonElement getDefaultValueAsJson() {
        return null;
    }

    @Override
    public final void setValueFromJson(JsonElement element) {
    }
}

