/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.rule.client;

import com.google.gson.JsonElement;
import me.senseiwells.essentialclient.rule.client.NumberClientRule;
import me.senseiwells.essentialclient.utils.interfaces.Rule;

public class IntegerClientRule
extends NumberClientRule<Integer> {
    public IntegerClientRule(String name, String description, int defaultValue, String category, Rule.RuleListener<Integer> ruleListener) {
        super(name, description, defaultValue, category, ruleListener);
    }

    public IntegerClientRule(String name, String description, int defaultValue, String category) {
        this(name, description, defaultValue, category, (Rule.RuleListener<Integer>)null);
    }

    public IntegerClientRule(String name, String description, String category) {
        this(name, description, 0, category);
    }

    @Override
    public Rule.Type getType() {
        return Rule.Type.INTEGER;
    }

    @Override
    public Integer fromJson(JsonElement value) {
        return value.getAsInt();
    }

    @Override
    public String getTypeAsString() {
        return "integer";
    }

    @Override
    public IntegerClientRule shallowCopy() {
        IntegerClientRule rule = new IntegerClientRule(this.getName(), this.getDescription(), (Integer)this.getDefaultValue(), this.getCategory());
        if (this.getListeners() != null) {
            for (Rule.RuleListener listener : this.getListeners()) {
                rule.addListener(listener);
            }
        }
        return rule;
    }

    @Override
    public void setValueFromString(String value) {
        try {
            this.setValue(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            this.logCannotSet(value);
        }
    }
}

