/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.rule.client;

import com.google.gson.JsonElement;
import me.senseiwells.essentialclient.rule.client.NumberClientRule;
import me.senseiwells.essentialclient.utils.interfaces.Rule;

public class DoubleClientRule
extends NumberClientRule<Double> {
    public DoubleClientRule(String name, String description, Double defaultValue, String category, Rule.RuleListener<Double> ruleListener) {
        super(name, description, defaultValue, category, ruleListener);
    }

    public DoubleClientRule(String name, String description, Double defaultValue, String category) {
        this(name, description, defaultValue, category, (Rule.RuleListener<Double>)null);
    }

    @Override
    public String getTypeAsString() {
        return "double";
    }

    @Override
    public Rule.Type getType() {
        return Rule.Type.DOUBLE;
    }

    @Override
    public Double fromJson(JsonElement value) {
        return value.getAsDouble();
    }

    @Override
    public DoubleClientRule shallowCopy() {
        DoubleClientRule rule = new DoubleClientRule(this.getName(), this.getDescription(), (Double)this.getDefaultValue(), this.getCategory());
        if (this.getListeners() != null) {
            for (Rule.RuleListener listener : this.getListeners()) {
                rule.addListener(listener);
            }
        }
        return rule;
    }

    @Override
    public void setValueFromString(String value) {
        try {
            this.setValue(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            this.logCannotSet(value);
        }
    }
}

