/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.rule.carpet;

import com.google.gson.JsonElement;
import me.senseiwells.essentialclient.rule.carpet.CarpetClientRule;
import me.senseiwells.essentialclient.rule.carpet.NumberCarpetRule;
import me.senseiwells.essentialclient.utils.interfaces.Rule;

public class IntegerCarpetRule
extends NumberCarpetRule<Integer> {
    public IntegerCarpetRule(String name, String description, Integer defaultValue) {
        super(name, description, defaultValue);
    }

    @Override
    public Rule.Type getType() {
        return Rule.Type.INTEGER;
    }

    @Override
    public Integer fromJson(JsonElement element) {
        return element.getAsInt();
    }

    @Override
    public CarpetClientRule<Integer> shallowCopy() {
        return new IntegerCarpetRule(this.getName(), this.getDescription(), (Integer)this.getDefaultValue());
    }

    @Override
    public Integer getValueFromString(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.logCannotSet(value);
            return null;
        }
    }
}

