/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.rule.carpet;

import com.google.gson.JsonElement;
import me.senseiwells.essentialclient.rule.carpet.CarpetClientRule;
import me.senseiwells.essentialclient.rule.carpet.NumberCarpetRule;
import me.senseiwells.essentialclient.utils.interfaces.Rule;

public class DoubleCarpetRule
extends NumberCarpetRule<Double> {
    public DoubleCarpetRule(String name, String description, Double defaultValue) {
        super(name, description, defaultValue);
    }

    @Override
    public Rule.Type getType() {
        return Rule.Type.DOUBLE;
    }

    @Override
    public Double fromJson(JsonElement element) {
        return element.getAsDouble();
    }

    @Override
    public CarpetClientRule<Double> shallowCopy() {
        return new DoubleCarpetRule(this.getName(), this.getDescription(), (Double)this.getDefaultValue());
    }

    @Override
    public Double getValueFromString(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            this.logCannotSet(value);
            return null;
        }
    }
}

