/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.rule.carpet;

import java.util.List;
import me.senseiwells.essentialclient.rule.carpet.CarpetClientRule;
import me.senseiwells.essentialclient.utils.interfaces.Rule;

public class CycleCarpetRule
extends CarpetClientRule<String>
implements Rule.Cycle {
    private final List<String> cycleValues;
    private int index;

    public CycleCarpetRule(String name, String description, List<String> cycleValues, String defaultValue) {
        super(name, description, defaultValue);
        this.cycleValues = cycleValues;
        this.index = cycleValues.indexOf(defaultValue);
        if (this.index == -1) {
            this.index = 0;
        }
    }

    public static CycleCarpetRule commandOf(String name, String description, String defaultValue) {
        switch (defaultValue) {
            case "true": 
            case "false": 
            case "ops": {
                break;
            }
            default: {
                defaultValue = "false";
            }
        }
        return new CycleCarpetRule(name, description, List.of("true", "false", "ops"), defaultValue);
    }

    @Override
    public CarpetClientRule<String> shallowCopy() {
        return new CycleCarpetRule(this.getName(), this.getDescription(), this.cycleValues, (String)this.getDefaultValue());
    }

    @Override
    public String getValueFromString(String value) {
        return value;
    }

    @Override
    public List<String> getCycleValues() {
        return this.cycleValues;
    }

    @Override
    public int getCurrentIndex() {
        return this.index;
    }

    @Override
    public void setCurrentIndex(int index) {
        this.index = index;
    }
}

