/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.rule;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.List;
import me.senseiwells.essentialclient.feature.AFKRules;
import me.senseiwells.essentialclient.feature.BetterAccurateBlockPlacement;
import me.senseiwells.essentialclient.feature.CustomClientCape;
import me.senseiwells.essentialclient.feature.HighlightLiquids;
import me.senseiwells.essentialclient.gui.RulesScreen;
import me.senseiwells.essentialclient.rule.client.BooleanClientRule;
import me.senseiwells.essentialclient.rule.client.ClientRule;
import me.senseiwells.essentialclient.rule.client.CycleClientRule;
import me.senseiwells.essentialclient.rule.client.DoubleClientRule;
import me.senseiwells.essentialclient.rule.client.DoubleSliderClientRule;
import me.senseiwells.essentialclient.rule.client.IntegerClientRule;
import me.senseiwells.essentialclient.rule.client.IntegerSliderClientRule;
import me.senseiwells.essentialclient.rule.client.ListClientRule;
import me.senseiwells.essentialclient.rule.client.StringClientRule;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.command.CommandHelper;
import me.senseiwells.essentialclient.utils.config.MappedStringConfig;
import me.senseiwells.essentialclient.utils.interfaces.Rule;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;

public class ClientRules
extends MappedStringConfig<ClientRule<?>> {
    public static final ClientRules INSTANCE = new ClientRules();
    public static final String RENDERING = "Rendering";
    public static final String UTILITY = "Utility";
    public static final String COMMANDS = "Commands";
    public static final String MISCELLANEOUS = "Miscellaneous";
    public static final BooleanClientRule BETTER_ACCURATE_BLOCK_PLACEMENT = ClientRules.register(new BooleanClientRule("betterAccurateBlockPlacement", "This is the same as accurate block placement for tweakeroo but handled all client side, see controls...", "Utility"));
    public static final BooleanClientRule CARPET_ALWAYS_SET_DEFAULT = ClientRules.register(new BooleanClientRule("carpetAlwaysSetDefault", "This makes it so whenever you set a carpet rule it automatically sets it to default", "Utility"));
    public static final BooleanClientRule CHUNK_DEBUG_MINIMAP_BACKGROUND = ClientRules.register(new BooleanClientRule("chunkDebugMinimapBackground", "This renders a box showing the bounds of the chunk debug minimap", true, "Rendering"));
    public static final BooleanClientRule CHUNK_DEBUG_SHOW_UNLOADED_CHUNKS = ClientRules.register(new BooleanClientRule("chunkDebugShowUnloadedChunks", "This shows you unloaded chunks in ChunkDebug", "Rendering"));
    public static final BooleanClientRule CLIENT_SCRIPT_ANNOUNCEMENTS = ClientRules.register(new BooleanClientRule("clientScriptAnnouncements", "This messages in chat when a script starts and finishes", true, "Miscellaneous"));
    public static final BooleanClientRule COMMAND_ALTERNATE_DIMENSION = ClientRules.register(new BooleanClientRule("commandAlternateDimension", "This command calculates the coordinates of the alternate dimension", "Commands", ClientRules::refreshCommand));
    public static final BooleanClientRule COMMAND_CLIENT_NICK = ClientRules.register(new BooleanClientRule("commandClientNick", "This allows you to rename player names on the client", "Commands", ClientRules::refreshCommand));
    public static final BooleanClientRule COMMAND_PLAYER_CLIENT = ClientRules.register(new BooleanClientRule("commandPlayerClient", "This command allows you to save /player... commands and execute them", "Commands", ClientRules::refreshCommand));
    public static final BooleanClientRule COMMAND_PLAYER_LIST = ClientRules.register(new BooleanClientRule("commandPlayerList", "This command allows you to execute /player... commands in one command (requires commandPlayerClient)", "Commands", ClientRules::refreshCommand));
    public static final BooleanClientRule COMMAND_REGION = ClientRules.register(new BooleanClientRule("commandRegion", "This command allows you to determine the region you are in or the region at set coords", "Commands", ClientRules::refreshCommand));
    public static final BooleanClientRule COMMAND_SUGGESTER_IGNORES_SPACES = ClientRules.register(new BooleanClientRule("commandSuggesterIgnoresSpaces", "This makes the command suggester ignore spaces", "Utility"));
    public static final BooleanClientRule CRAFTING_HAX = ClientRules.register(new BooleanClientRule("craftingHax", "This allows you to craft items with the mouse", "Utility"));
    public static final BooleanClientRule DISABLE_BOB_VIEW_WHEN_HURT = ClientRules.register(new BooleanClientRule("disableBobViewWhenHurt", "Disables the camera bobbing when you get hurt", "Utility"));
    public static final BooleanClientRule DISABLE_BOSS_BAR = ClientRules.register(new BooleanClientRule("disableBossBar", "This will disable the boss bar from rendering", "Rendering"));
    public static final BooleanClientRule DISABLE_HOTBAR_SCROLLING = ClientRules.register(new BooleanClientRule("disableHotbarScrolling", "This will prevent you from scrolling in your hotbar, learn to use hotkeys :)", "Utility"));
    public static final BooleanClientRule DISABLE_JOIN_LEAVE_MESSAGES = ClientRules.register(new BooleanClientRule("disableJoinLeaveMessages", "This will prevent join/leave messages from displaying", "Rendering"));
    public static final BooleanClientRule DISABLE_MAP_RENDERING = ClientRules.register(new BooleanClientRule("disableMapRendering", "This disables maps rendering in item frames", "Rendering"));
    public static final BooleanClientRule DISABLE_NAME_TAGS = ClientRules.register(new BooleanClientRule("disableNameTags", "This disables all name tags from rendering", "Rendering"));
    public static final BooleanClientRule DISABLE_NARRATOR = ClientRules.register(new BooleanClientRule("disableNarrator", "Disables cycling narrator when pressing CTRL + B", "Miscellaneous"));
    public static final BooleanClientRule DISABLE_NIGHT_VISION_FLASH = ClientRules.register(new BooleanClientRule("disableNightVisionFlash", "Disables the flash that occurs when night vision is about to run out", "Rendering"));
    public static final BooleanClientRule DISABLE_OP_MESSAGES = ClientRules.register(new BooleanClientRule("disableOpMessages", "This will prevent system messages from displaying", "Rendering"));
    public static final BooleanClientRule DISABLE_RECIPE_NOTIFICATIONS = ClientRules.register(new BooleanClientRule("disableRecipeNotifications", "Disables the recipe toast from showing", "Rendering"));
    public static final BooleanClientRule DISABLE_SCREENSHOT_MESSAGE = ClientRules.register(new BooleanClientRule("disableScreenshotMessage", "Disables the message that pops up when you take a screenshot", "Rendering"));
    public static final BooleanClientRule DISABLE_TUTORIAL_NOTIFICATIONS = ClientRules.register(new BooleanClientRule("disableTutorialNotifications", "Disables the tutorial toast from showing", "Rendering"));
    public static final BooleanClientRule DISPLAY_TIME_PLAYED = ClientRules.register(new BooleanClientRule("displayTimePlayed", "This will display how long you have had your current client open for in the corner of the pause menu", "Miscellaneous"));
    public static final BooleanClientRule ESSENTIAL_CLIENT_BUTTON = ClientRules.register(new BooleanClientRule("essentialClientButton", "This renders the Essential Client Menu on the main menu screen, and pause screen", true, "Utility"));
    public static final BooleanClientRule TITLE_TEXT_TO_TOP = ClientRules.register(new BooleanClientRule("titleTextToTop", "Forces the Minecraft version and Mojang text to the top of the screen", "Rendering"));
    public static final BooleanClientRule HIGHLIGHT_LAVA_SOURCES = ClientRules.register(new BooleanClientRule("highlightLavaSources", "Highlights lava sources, credit to plusls for the original code for this", "Rendering", ClientRules::refreshWorld));
    public static final BooleanClientRule HIGHLIGHT_WATER_SOURCES = ClientRules.register(new BooleanClientRule("highlightWaterSources", "highlights water sources", "Rendering", ClientRules::refreshWorld));
    public static final BooleanClientRule INCREASE_SPECTATOR_SCROLL_SPEED = ClientRules.register(new BooleanClientRule("increaseSpectatorScrollSpeed", "Increases the limit at which you can scroll to go faster in spectator", "Utility"));
    public static final BooleanClientRule OPEN_SCREENSHOT_DIRECTORY = ClientRules.register(new BooleanClientRule("openScreenshotDirectory", "This opens the screenshot directory instead of directly opening the screenshot", "Utility"));
    public static final BooleanClientRule PERMANENT_CHAT_HUD = ClientRules.register(new BooleanClientRule("permanentChatHud", "This prevents the chat from being cleared, also applies when changing worlds/servers", "Rendering"));
    public static final BooleanClientRule QUICK_LOCK_RECIPE = ClientRules.register(new BooleanClientRule("quickLockRecipe", "If you middle click a recipe it will put the name of the item in the search bar stopping you from craftin the wrong recipe", "Utility"));
    public static final BooleanClientRule REMOVE_WARN_RECEIVED_PASSENGERS = ClientRules.register(new BooleanClientRule("removeWarnReceivedPassengers", "This removes the 'Received passengers for unknown entity' warning on the client", "Miscellaneous"));
    public static final BooleanClientRule STACKABLE_SHULKERS_IN_PLAYER_INVENTORIES = ClientRules.register(new BooleanClientRule("stackableShulkersInPlayerInventories", "This allows for shulkers to stack only in your inventory", "Utility"));
    public static final BooleanClientRule STACKABLE_SHULKERS_WITH_ITEMS = ClientRules.register(new BooleanClientRule("stackableShulkersWithItems", "This allows for shulkers with items to stack only in your inventory", "Utility"));
    public static final BooleanClientRule START_SELECTED_SCRIPTS_ON_JOIN = ClientRules.register(new BooleanClientRule("startSelectedScriptsOnJoin", "This will enable your selected scripts when you join a world automatically", "Miscellaneous"));
    public static final BooleanClientRule SURVIVAL_INVENTORY_IN_CREATIVE = ClientRules.register(new BooleanClientRule("survivalInventoryInCreative", "This lets you open the survival inventory in creative mode", "Utility"));
    public static final BooleanClientRule TOGGLE_TAB = ClientRules.register(new BooleanClientRule("toggleTab", "This allows you to toggle tab instead of holding to see tab", "Utility"));
    public static final BooleanClientRule UNLOCK_ALL_RECIPES_ON_JOIN = ClientRules.register(new BooleanClientRule("unlockAllRecipesOnJoin", "Unlocks every recipe when joining a world", "Utility"));
    public static final BooleanClientRule CLIENTSCRIPT_DEBUGGER = ClientRules.register(new BooleanClientRule("clientscriptDebugger", "You probably shouldn't touch this", "Utility"));
    public static final IntegerClientRule ANNOUNCE_AFK = ClientRules.register(new IntegerClientRule("announceAFK", "This announces when you become afk after a set amount of time (ticks)", "Utility"));
    public static final IntegerClientRule AFK_LOGOUT = ClientRules.register(new IntegerClientRule("afkLogout", "Number of ticks until client will disconnect you from world (must be >= 200 to be active)", "Utility"));
    public static final IntegerClientRule AUTO_WALK = ClientRules.register(new IntegerClientRule("autoWalk", "This will auto walk after you have held your key for set amount of ticks", "Utility"));
    public static final IntegerClientRule INCREASE_SPECTATOR_SCROLL_SENSITIVITY = ClientRules.register(new IntegerClientRule("increaseSpectatorScrollSensitivity", "Increases the sensitivity at which you can scroll to go faster in spectator", "Utility"));
    public static final IntegerClientRule SWITCH_TO_TOTEM = ClientRules.register(new IntegerClientRule("switchToTotem", "This will switch to a totem (if you have one), under a set amount of health", "Utility"));
    public static final IntegerSliderClientRule PERMANENT_TIME = ClientRules.register(new IntegerSliderClientRule("permanentTime", "This forces your client to set a time of day", -1, "Rendering", -1, 23999));
    public static final DoubleClientRule OVERRIDE_CREATIVE_WALK_SPEED = ClientRules.register(new DoubleClientRule("overrideCreativeWalkSpeed", "This allows you to override the vanilla walk speed in creative mode", 0.0, "Utility"));
    public static final DoubleSliderClientRule SOUL_SPEED_FOV_MULTIPLIER = ClientRules.register(new DoubleSliderClientRule("soulSpeedFovMultiplier", "Determines the percentage of Fov scaling when walking on soil soul or soul sand", 0.0, "Rendering", 0.0, 1.0));
    public static final DoubleSliderClientRule WATER_FOV_MULTIPLIER = ClientRules.register(new DoubleSliderClientRule("waterFovMultiplier", "Determines the percentage of Fov scaling when fully submerged in water", 0.0, "Rendering", 0.0, 1.0));
    public static final StringClientRule ANNOUNCE_AFK_MESSAGE = ClientRules.register(new StringClientRule("announceAFKMessage", "This is the message you announce after you are afk", "I am now AFK", "Utility"));
    public static final StringClientRule ANNOUNCE_BACK_MESSAGE = ClientRules.register(new StringClientRule("announceBackMessage", "This is the message you announce after you are back from being afk", "", "Utility"));
    public static final CycleClientRule CLIENT_SCRIPT_FONT = ClientRules.register(new CycleClientRule("clientScriptFont", "This allows you to change the font for client script errors", List.of("Minecraft", "Jetbrains"), "Rendering"));
    public static final CycleClientRule CUSTOM_CLIENT_CAPE = ClientRules.register(new CycleClientRule("customClientCape", "This allows you to select a Minecraft cape to wear, this only appears client side", CustomClientCape.getCapeNames(), "Rendering", ClientRules::refreshCape));
    public static final CycleClientRule DISABLE_ARMOUR_RENDERING = ClientRules.register(new CycleClientRule("disableArmourRendering", "This allows you to disable armour rendering for entities", List.of("None", "You", "Players", "Entities"), "Rendering"));
    public static final CycleClientRule DISPLAY_RULE_TYPE = ClientRules.register(new CycleClientRule("displayRuleType", "This allows you to choose the order you want rules to be displayed", List.of("Alphabetical", "Rule Type", "Categories"), "Miscellaneous", ClientRules::refreshScreen));
    public static final ListClientRule CLIENT_SCRIPT_REPOS = ClientRules.register(new ListClientRule("clientScriptRepos", "This allows you to define where you can download your scripts from", List.of("https://api.github.com/repos/senseiwells/clientscript/contents/scripts"), "Miscellaneous"));

    private ClientRules() {
    }

    public static void load() {
    }

    public static void addRule(String name, ClientRule<?> rule) {
        INSTANCE.set(name, rule);
    }

    public static ClientRule<?> ruleFromString(String name) {
        return (ClientRule)INSTANCE.get(name);
    }

    public static Collection<ClientRule<?>> getClientRules() {
        return ClientRules.INSTANCE.map.values();
    }

    private static void refreshCommand(Rule<Boolean> value) {
        class_746 playerEntity = EssentialUtils.getPlayer();
        if (playerEntity != null) {
            playerEntity.field_3944.method_11145(CommandHelper.getCommandPacket());
        }
    }

    private static void refreshCape(Rule<String> value) {
        CustomClientCape.setCurrentCape(value.getValue());
    }

    private static void refreshScreen(Rule<String> value) {
        class_310 client = EssentialUtils.getClient();
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof RulesScreen) {
            RulesScreen rulesScreen = (RulesScreen)class_4372;
            rulesScreen.refreshRules(rulesScreen.getSearchBoxText());
        }
    }

    private static void refreshWorld(Rule<Boolean> value) {
        class_310 client = EssentialUtils.getClient();
        if (client.field_1769 != null) {
            client.field_1769.method_3279();
        }
    }

    @Override
    public String getConfigName() {
        return "ClientRules";
    }

    @Override
    protected JsonElement valueToJson(ClientRule<?> value) {
        JsonObject clientRuleObject = new JsonObject();
        clientRuleObject.add("value", value.getValueAsJson());
        clientRuleObject.addProperty("extras", value.getOptionalInfo());
        return clientRuleObject;
    }

    @Override
    protected ClientRule<?> jsonToValue(String key, JsonElement valueElement) {
        JsonObject clientRuleObject = valueElement.getAsJsonObject();
        JsonElement value = clientRuleObject.get("value");
        JsonElement info = clientRuleObject.get("extras");
        ClientRule clientRule = (ClientRule)this.get(key);
        if (clientRule != null) {
            clientRule.setValueFromJson(value);
            if (info instanceof JsonPrimitive) {
                clientRule.setOptionalInfo(info.getAsString());
            }
        }
        return clientRule;
    }

    private static <T extends ClientRule<?>> T register(T clientRule) {
        ClientRules.addRule(clientRule.getName(), clientRule);
        clientRule.onValueChange();
        clientRule.addListener(rule -> INSTANCE.saveConfig());
        return clientRule;
    }

    static {
        CLIENT_SCRIPT_REPOS.setMaxLength(Integer.MAX_VALUE);
        AFKRules.load();
        BetterAccurateBlockPlacement.load();
        if (EssentialUtils.isModInstalled("fabric-resource-loader-v0")) {
            HighlightLiquids.load();
        }
    }
}

