/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.gui.entries;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.senseiwells.essentialclient.gui.RulesScreen;
import me.senseiwells.essentialclient.gui.config.ConfigListWidget;
import me.senseiwells.essentialclient.utils.interfaces.Rule;
import me.senseiwells.essentialclient.utils.render.RuleWidget;
import me.senseiwells.essentialclient.utils.render.Texts;
import me.senseiwells.essentialclient.utils.render.WidgetHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public abstract class BaseListEntry<T extends class_339>
extends ConfigListWidget.Entry {
    protected final Rule<?> rule;
    protected final RulesScreen rulesScreen;
    protected final class_310 client;
    protected final String ruleName;
    protected final RuleWidget ruleWidget;
    protected final T editButton;
    protected final class_4185 resetButton;
    private Consumer<class_4185> resetConsumer;

    public BaseListEntry(Rule<?> rule, class_310 client, RulesScreen rulesScreen, Supplier<T> editButton) {
        this.rule = rule;
        this.client = client;
        this.rulesScreen = rulesScreen;
        this.ruleName = rule.getName();
        this.ruleWidget = new RuleWidget(this.ruleName, 190, 15);
        this.editButton = (class_339)editButton.get();
        this.resetButton = WidgetHelper.newButton(0, 0, 50, 20, Texts.RESET, button -> this.resetConsumer.accept(button));
        this.resetConsumer = buttonWidget -> {
            this.rule.resetToDefault();
            this.editButton.method_25355((class_2561)class_2561.method_43470((String)this.rule.getDefaultValue().toString()));
        };
        this.checkDisabled();
    }

    protected void setResetButton(Consumer<class_4185> consumer) {
        this.resetConsumer = consumer;
    }

    protected void renderEditButton(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
        this.editButton.method_48229(x + 180, y);
        this.editButton.method_25394(context, mouseX, mouseY, delta);
    }

    protected void checkDisabled() {
        if (this.cannotEdit() || !this.rule.isAvailable() || !this.rule.changeable()) {
            this.method_25396().forEach(child -> {
                child.field_22763 = false;
            });
        }
    }

    protected boolean cannotEdit() {
        return !this.rulesScreen.canModify();
    }

    protected boolean isRuleWidgetHovered(double mouseX, double mouseY) {
        return this.ruleWidget.isHovered((int)mouseX, (int)mouseY) && mouseY > 32.0 && mouseY < (double)(this.rulesScreen.field_22790 - 32);
    }

    public Rule<?> getRule() {
        return this.rule;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isRuleWidgetHovered(mouseX, mouseY)) {
            this.ruleWidget.toggle();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25343(class_332 context, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        class_327 font = this.client.field_1772;
        float fontX = x + 100 - 136;
        float fontY = y + height / 2 - 4;
        this.ruleWidget.setPos(x - 50, y + 2);
        this.ruleWidget.drawRule(context, font, fontX, fontY, 0xFFFFFF);
        if (this.isRuleWidgetHovered(mouseX, mouseY)) {
            ArrayList<class_5481> lines = new ArrayList<class_5481>();
            class_5250 nameText = class_2561.method_43470((String)this.ruleName).method_27692(class_124.field_1065);
            lines.add(nameText.method_30937());
            Object info = this.ruleWidget.isToggled() && this.rule.getOptionalInfo() != null ? "\u00a73Extra Info:\u00a7r\n" + this.rule.getOptionalInfo() : this.rule.getDescription();
            if (info != null) {
                lines.addAll(this.client.field_1772.method_1728(class_5348.method_29430((String)((String)info).replace("\r", "")), 220));
                this.rulesScreen.setCurrentTooltip(lines);
            }
        }
        this.resetButton.method_48229(x + 290, y);
        this.resetButton.field_22763 = this.rule.isAvailable() && this.rule.changeable() && this.rule.isNotDefault();
        this.resetButton.method_25394(context, mouseX, mouseY, delta);
        this.renderEditButton(context, x, y, mouseX, mouseY, delta);
    }

    public List<class_339> method_25396() {
        return ImmutableList.of(this.editButton, (Object)this.resetButton);
    }

    public List<class_339> method_37025() {
        return this.method_25396();
    }
}

