/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.gui.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import me.senseiwells.essentialclient.feature.keybinds.ClientKeyBind;
import me.senseiwells.essentialclient.feature.keybinds.ClientKeyBinds;
import me.senseiwells.essentialclient.gui.config.ControlsScreen;
import me.senseiwells.essentialclient.gui.entries.AbstractListEntry;
import me.senseiwells.essentialclient.utils.render.Texts;
import me.senseiwells.essentialclient.utils.render.WidgetHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ControlsListWidget
extends class_4265<Entry> {
    private final ControlsScreen controlsScreen;
    private int maxKeyNameLength;

    public ControlsListWidget(class_310 client, ControlsScreen controlsScreen) {
        super(client, controlsScreen.field_22789 + 45, controlsScreen.field_22790 - 43 - 32, 43, 20);
        this.controlsScreen = controlsScreen;
        TreeMap<String, Set> sortedKeys = new TreeMap<String, Set>();
        for (ClientKeyBind keyBind : ClientKeyBinds.getAllKeyBinds()) {
            Set keyBinds = sortedKeys.computeIfAbsent(keyBind.getCategory(), n -> new TreeSet());
            keyBinds.add(keyBind);
        }
        sortedKeys.forEach((category, keys) -> {
            this.method_25321((class_350.class_351)new CategoryEntry((class_2561)class_2561.method_43471((String)category)));
            for (ClientKeyBind keyBind : keys) {
                class_5250 text = class_2561.method_43471((String)keyBind.getName());
                int i = client.field_1772.method_27525((class_5348)text);
                if (i > this.maxKeyNameLength) {
                    this.maxKeyNameLength = i;
                }
                this.method_25321((class_350.class_351)new KeyBindEntry(keyBind, (class_2561)text));
            }
        });
    }

    protected int method_25329() {
        return super.method_25329() + 15;
    }

    public int method_25322() {
        return super.method_25322() + 32;
    }

    class CategoryEntry
    extends Entry {
        private final int textWidth;
        final class_2561 text;

        CategoryEntry(class_2561 text) {
            this.textWidth = ((ControlsListWidget)ControlsListWidget.this).field_22740.field_1772.method_27525((class_5348)text);
            this.text = text;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_27535(((ControlsListWidget)ControlsListWidget.this).field_22740.field_1772, this.text, (int)((float)ControlsListWidget.this.controlsScreen.field_22789 / 2.0f - (float)this.textWidth / 2.0f), y + entryHeight - 9 - 1, 0xFFFFFF);
        }

        public List<class_4185> method_37025() {
            return this.method_25396();
        }

        public List<class_4185> method_25396() {
            return ImmutableList.of();
        }
    }

    class KeyBindEntry
    extends Entry {
        private final ClientKeyBind keyBind;
        private final class_2561 bindingText;
        private final class_4185 editButton;
        private final class_4185 resetButton;

        KeyBindEntry(ClientKeyBind keyBind, class_2561 text) {
            this.keyBind = keyBind;
            this.bindingText = text;
            this.editButton = WidgetHelper.newButton(0, 0, 75, 20, text, button -> ControlsListWidget.this.controlsScreen.setFocusedKeyBinding(this.keyBind));
            this.resetButton = WidgetHelper.newButton(0, 0, 50, 20, Texts.RESET, button -> {
                this.keyBind.clearKey();
                this.keyBind.resetKey();
            });
            this.resetButton.field_22763 = !this.keyBind.isDefault();
        }

        public List<class_4185> method_37025() {
            return this.method_25396();
        }

        public List<class_4185> method_25396() {
            return ImmutableList.of((Object)this.editButton, (Object)this.resetButton);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            boolean focused = ControlsListWidget.this.controlsScreen.isBindingFocused(this.keyBind);
            float width = x + 90 - ControlsListWidget.this.maxKeyNameLength;
            context.method_27535(((ControlsListWidget)ControlsListWidget.this).field_22740.field_1772, this.bindingText, (int)width, (int)((float)y + (float)entryHeight / 2.0f - 4.5f), 0xFFFFFF);
            WidgetHelper.setPosition((class_339)this.resetButton, x + 190, y);
            this.resetButton.field_22763 = !this.keyBind.isDefault();
            this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
            WidgetHelper.setPosition((class_339)this.editButton, x + 105, y);
            class_5250 editMessage = class_2561.method_43470((String)this.keyBind.getDisplay());
            int textWidth = ((ControlsListWidget)ControlsListWidget.this).field_22740.field_1772.method_27525((class_5348)editMessage);
            if (textWidth > 70) {
                editMessage = class_2561.method_43470((String)"...");
            }
            if (focused) {
                this.editButton.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)editMessage.method_27692(class_124.field_1054)).method_27693(" <").method_27692(class_124.field_1054));
            } else {
                this.editButton.method_25355((class_2561)editMessage);
            }
            this.editButton.method_25394(context, mouseX, mouseY, tickDelta);
            if (this.editButton.method_25405((double)mouseX, (double)mouseY)) {
                ControlsListWidget.this.controlsScreen.setHoveredKeyBinding(this.keyBind);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.editButton.method_25402(mouseX, mouseY, button) || this.resetButton.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return this.editButton.method_25406(mouseX, mouseY, button) || this.resetButton.method_25406(mouseX, mouseY, button);
        }
    }

    static abstract class Entry
    extends AbstractListEntry<Entry> {
        Entry() {
        }
    }
}

