/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.gui.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import me.senseiwells.essentialclient.gui.RulesScreen;
import me.senseiwells.essentialclient.gui.entries.AbstractListEntry;
import me.senseiwells.essentialclient.gui.entries.BaseListEntry;
import me.senseiwells.essentialclient.gui.entries.BooleanListEntry;
import me.senseiwells.essentialclient.gui.entries.CategoryEntry;
import me.senseiwells.essentialclient.gui.entries.CycleListEntry;
import me.senseiwells.essentialclient.gui.entries.ListListEntry;
import me.senseiwells.essentialclient.gui.entries.NumberListEntry;
import me.senseiwells.essentialclient.gui.entries.SliderListEntry;
import me.senseiwells.essentialclient.gui.entries.StringListEntry;
import me.senseiwells.essentialclient.utils.interfaces.Rule;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_4265;

public class ConfigListWidget
extends class_4265<Entry> {
    public static final int LENGTH = 136;

    public ConfigListWidget(RulesScreen rulesScreen, class_310 client, String filter) {
        super(client, rulesScreen.field_22789 + 45, rulesScreen.field_22790 - 43 - 32, 43, 20);
        this.reloadEntries(rulesScreen, filter);
    }

    public void reloadEntries(RulesScreen rulesScreen, String filter) {
        this.method_25339();
        Collection<Rule<?>> rules = rulesScreen.getRules(filter);
        TreeMap<String, Set> sortedEntries = new TreeMap<String, Set>();
        rules.forEach(rule -> {
            if (!rule.display()) {
                return;
            }
            String ruleName = rule.getName();
            if (filter != null && !ruleName.toLowerCase(Locale.ROOT).contains(filter.toLowerCase(Locale.ROOT))) {
                return;
            }
            BaseListEntry entry = switch (rule.getType()) {
                case Rule.Type.BOOLEAN -> new BooleanListEntry((Rule.Bool)rule, this.field_22740, rulesScreen);
                case Rule.Type.CYCLE -> new CycleListEntry((Rule.Cycle)rule, this.field_22740, rulesScreen);
                case Rule.Type.INTEGER, Rule.Type.DOUBLE -> new NumberListEntry((Rule<?>)rule, this.field_22740, rulesScreen);
                case Rule.Type.STRING -> new StringListEntry((Rule<?>)rule, this.field_22740, rulesScreen);
                case Rule.Type.SLIDER -> new SliderListEntry((Rule.Slider)rule, this.field_22740, rulesScreen);
                case Rule.Type.LIST -> new ListListEntry((Rule.ListRule)rule, this.field_22740, rulesScreen);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)rule.getType()));
            };
            String category = rule.getCategory() == null ? "Miscellaneous" : rule.getCategory();
            Set set = sortedEntries.computeIfAbsent(category, k -> new HashSet());
            set.add(entry);
        });
        if (sortedEntries.size() == 1 || !rulesScreen.shouldCategorise()) {
            sortedEntries.values().stream().flatMap(Collection::stream).sorted(rulesScreen.entryComparator()).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
            return;
        }
        sortedEntries.forEach((category, entries) -> {
            this.method_25321((class_350.class_351)new CategoryEntry((String)category));
            entries.stream().sorted(rulesScreen.entryComparator()).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        });
    }

    public void updateAllEntriesOnClose() {
        this.method_25396().forEach(Entry::updateEntryOnClose);
    }

    public void unFocusAll() {
        this.method_25396().forEach(Entry::unFocus);
    }

    protected int method_25329() {
        return this.field_22758 / 2 + this.method_25322() / 2;
    }

    public int method_25322() {
        return 360;
    }

    public static abstract class Entry
    extends AbstractListEntry<Entry> {
        public void unFocus() {
        }

        public void updateEntryOnClose() {
        }
    }
}

