/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.gui.clientscript;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.senseiwells.essentialclient.gui.clientscript.ClientScriptScreen;
import me.senseiwells.essentialclient.gui.clientscript.DownloadClientScriptScreen;
import me.senseiwells.essentialclient.gui.entries.AbstractListEntry;
import me.senseiwells.essentialclient.utils.clientscript.ScriptRepositoryManager;
import me.senseiwells.essentialclient.utils.render.Texts;
import me.senseiwells.essentialclient.utils.render.WidgetHelper;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5348;

public class DownloadClientScriptWidget
extends class_4265<Entry> {
    private final DownloadClientScriptScreen downloadScreen;
    private int maxScriptNameLength;

    public DownloadClientScriptWidget(class_310 minecraftClient, DownloadClientScriptScreen downloadScreen) {
        super(minecraftClient, downloadScreen.field_22789 + 45, downloadScreen.field_22790 - 43 - 32, 43, 20);
        this.downloadScreen = downloadScreen;
        for (ScriptRepositoryManager.Category category : ScriptRepositoryManager.Category.values()) {
            this.method_25321((class_350.class_351)new CategoryEntry(category.getPrettyName()));
            for (String script : ScriptRepositoryManager.INSTANCE.getChildrenNames(category)) {
                int length = script.length();
                if (length > this.maxScriptNameLength) {
                    this.maxScriptNameLength = length;
                }
                this.method_25321((class_350.class_351)new ScriptListEntry(category, script));
            }
        }
    }

    class CategoryEntry
    extends Entry {
        private final int textWidth;
        final class_2561 text;

        CategoryEntry(class_2561 text) {
            this.textWidth = ((DownloadClientScriptWidget)DownloadClientScriptWidget.this).field_22740.field_1772.method_27525((class_5348)text);
            this.text = text;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 renderer = ((DownloadClientScriptWidget)DownloadClientScriptWidget.this).field_22740.field_1772;
            context.method_27535(renderer, this.text, (int)((float)DownloadClientScriptWidget.this.downloadScreen.field_22789 / 2.0f - (float)this.textWidth / 2.0f), y + entryHeight - 9 - 1, 0xFFFFFF);
        }

        public List<class_4185> method_37025() {
            return this.method_25396();
        }

        public List<class_4185> method_25396() {
            return ImmutableList.of();
        }
    }

    class ScriptListEntry
    extends Entry {
        private final String scriptName;
        private final class_4185 viewButton;
        private final class_4185 downloadButton;

        ScriptListEntry(ScriptRepositoryManager.Category category, String scriptName) {
            this.scriptName = scriptName;
            this.viewButton = WidgetHelper.newButton(0, 0, 50, 20, Texts.VIEW, button -> class_156.method_668().method_670(ScriptRepositoryManager.INSTANCE.getViewableLink(category, scriptName)));
            this.downloadButton = WidgetHelper.newButton(0, 0, 60, 20, (class_2561)Texts.DOWNLOAD.method_27661().method_27692(class_124.field_1077), button -> {
                class_374 toastManager = DownloadClientScriptWidget.this.field_22740.method_1566();
                if (ScriptRepositoryManager.INSTANCE.downloadScript(category, scriptName, true)) {
                    class_370.method_1990((class_374)toastManager, (class_370.class_9037)class_370.class_9037.field_47587, (class_2561)Texts.DOWNLOAD_FAILED, null);
                    return;
                }
                class_370.method_1990((class_374)toastManager, (class_370.class_9037)class_370.class_9037.field_47584, (class_2561)Texts.DOWNLOAD_SUCCESSFUL, null);
                ((ClientScriptScreen)((Object)((Object)DownloadClientScriptWidget.this.downloadScreen.getParent()))).refresh();
            });
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            float width = x - 20 - DownloadClientScriptWidget.this.maxScriptNameLength;
            context.method_27535(((DownloadClientScriptWidget)DownloadClientScriptWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43470((String)this.scriptName), (int)width, (int)((float)y + (float)entryHeight / 2.0f - 4.5f), 0xFFFFFF);
            WidgetHelper.setPosition((class_339)this.downloadButton, x + 155, y);
            WidgetHelper.setPosition((class_339)this.viewButton, x + 100, y);
            this.viewButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.downloadButton.method_25394(context, mouseX, mouseY, tickDelta);
        }

        public List<class_4185> method_37025() {
            return this.method_25396();
        }

        public List<class_4185> method_25396() {
            return ImmutableList.of((Object)this.viewButton, (Object)this.downloadButton);
        }
    }

    static abstract class Entry
    extends AbstractListEntry<Entry> {
        Entry() {
        }
    }
}

