/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.gui.clientscript;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.senseiwells.essentialclient.clientscript.core.ClientScript;
import me.senseiwells.essentialclient.clientscript.core.ClientScriptInstance;
import me.senseiwells.essentialclient.gui.clientscript.ClientScriptScreen;
import me.senseiwells.essentialclient.gui.entries.AbstractListEntry;
import me.senseiwells.essentialclient.utils.render.Texts;
import me.senseiwells.essentialclient.utils.render.WidgetHelper;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4286;

public class ClientScriptWidget
extends class_4265<ScriptListEntry> {
    private final ClientScriptScreen parent;

    public ClientScriptWidget(class_310 minecraftClient, ClientScriptScreen scriptScreen) {
        super(minecraftClient, scriptScreen.field_22789 + 45, scriptScreen.field_22790 - 43 - 32, 43, 20);
        this.parent = scriptScreen;
        this.load(minecraftClient);
    }

    public void load(class_310 client) {
        this.clear();
        for (ClientScriptInstance instance : ClientScript.INSTANCE.getScriptInstancesInOrder()) {
            this.method_25321((class_350.class_351)new ScriptListEntry(client, instance));
        }
    }

    public void clear() {
        this.method_25339();
    }

    class ScriptListEntry
    extends AbstractListEntry<ScriptListEntry> {
        private final class_310 client;
        private final String name;
        private final ClientScriptInstance scriptInstance;
        private final class_4185 configButton;
        private final class_4185 startButton;
        private final class_4286 checkButton;

        ScriptListEntry(class_310 client, ClientScriptInstance instance) {
            this.client = client;
            this.name = instance.getName();
            this.scriptInstance = instance;
            boolean isTemporary = instance.isTemporary();
            this.configButton = WidgetHelper.newButton(0, 0, 45, 20, isTemporary ? Texts.REMOVE : Texts.CONFIG, buttonWidget -> {
                if (!isTemporary) {
                    ClientScriptWidget.this.parent.openScriptConfigScreen(this.scriptInstance);
                    return;
                }
                ClientScript.INSTANCE.removeInstance(this.scriptInstance);
                ClientScriptWidget.this.clear();
                ClientScriptWidget.this.load(this.client);
            });
            this.startButton = WidgetHelper.newButton(0, 0, 45, 20, instance.isScriptRunning() ? Texts.STOP : Texts.START, buttonWidget -> {
                if (this.scriptInstance.isScriptRunning()) {
                    this.scriptInstance.stopScript();
                    return;
                }
                this.scriptInstance.toggleScript();
            });
            this.checkButton = class_4286.method_54787((class_2561)Texts.EMPTY, (class_327)client.field_1772).method_54789(0, 0).method_54794(ClientScript.INSTANCE.isSelected(this.name)).method_54791((w, b) -> {
                if (b) {
                    ClientScript.INSTANCE.removeSelectedInstance(this.name);
                } else {
                    ClientScript.INSTANCE.addSelectedInstance(this.name);
                }
            }).method_54788();
            this.checkButton.field_22763 = !isTemporary;
        }

        public List<class_339> method_25396() {
            return ImmutableList.of((Object)this.configButton, (Object)this.startButton, (Object)this.checkButton);
        }

        public List<class_339> method_37025() {
            return this.method_25396();
        }

        public void method_25343(class_332 context, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_27535(this.client.field_1772, (class_2561)class_2561.method_43470((String)this.name), x - 50, y + height / 2 - 4, 0xFFFFFF);
            WidgetHelper.setPosition((class_339)this.checkButton, x + width - 20, y);
            WidgetHelper.setPosition((class_339)this.startButton, x + width - 70, y);
            WidgetHelper.setPosition((class_339)this.configButton, x + width - 120, y);
            this.startButton.field_22763 = this.client.field_1724 != null;
            this.startButton.method_25355(this.scriptInstance.isScriptRunning() ? Texts.STOP : Texts.START);
            this.configButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.startButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.checkButton.method_25394(context, mouseX, mouseY, tickDelta);
        }
    }
}

