/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.gui.clientscript;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.clientscript.core.ClientScript;
import me.senseiwells.essentialclient.clientscript.core.ClientScriptInstance;
import me.senseiwells.essentialclient.feature.keybinds.ClientKeyBind;
import me.senseiwells.essentialclient.feature.keybinds.MultiKeyBind;
import me.senseiwells.essentialclient.gui.clientscript.ClientScriptWidget;
import me.senseiwells.essentialclient.gui.clientscript.CreateClientScriptScreen;
import me.senseiwells.essentialclient.gui.clientscript.DownloadClientScriptScreen;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.render.ChildScreen;
import me.senseiwells.essentialclient.utils.render.Texts;
import me.senseiwells.essentialclient.utils.render.WidgetHelper;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ClientScriptScreen
extends ChildScreen {
    private ClientScriptWidget scriptWidget;

    public ClientScriptScreen(class_437 parent) {
        super(Texts.SCRIPT_SCREEN, parent);
    }

    protected void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        int height = this.field_22790 - 27;
        this.scriptWidget = new ClientScriptWidget(this.field_22787, this);
        this.method_37063((class_364)this.scriptWidget);
        this.method_37063((class_364)WidgetHelper.newButton(10, height, 100, 20, Texts.REFRESH, button -> this.refresh()));
        this.method_37063((class_364)WidgetHelper.newButton(this.field_22789 / 2 - 100, height, 200, 20, Texts.DONE, button -> this.method_25419()));
        this.method_37063((class_364)WidgetHelper.newButton(this.field_22789 - 110, height, 100, 20, Texts.DOCUMENTATION, button -> class_156.method_668().method_673(EssentialUtils.SCRIPT_WIKI_URL)));
        this.method_37063((class_364)WidgetHelper.newButton(10, 10, 80, 20, Texts.NEW, button -> this.field_22787.method_1507((class_437)new CreateClientScriptScreen(this))));
        this.method_37063((class_364)WidgetHelper.newButton(this.field_22789 - 90, 10, 80, 20, Texts.DOWNLOAD, button -> this.field_22787.method_1507((class_437)new DownloadClientScriptScreen(this))));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.scriptWidget.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)Texts.ARUCAS_VERSION.generate("2.3.0"), this.field_22789 / 2, 24, 0x949494);
    }

    public void refresh() {
        ClientScript.INSTANCE.refresh();
        this.scriptWidget.load(this.field_22787);
    }

    public void openScriptConfigScreen(ClientScriptInstance scriptInstance) {
        ScriptConfigScreen configScreen = new ScriptConfigScreen(this, scriptInstance);
        EssentialUtils.getClient().method_1507((class_437)configScreen);
    }

    static class ScriptConfigScreen
    extends ChildScreen.Typed<ClientScriptScreen> {
        private final ClientScriptInstance scriptInstance;
        private final class_342 nameBox;
        private final class_4185 openBox;
        private final class_4185 deleteBox;
        private final class_4185 keyBindBox;
        private final class_4286 selectedCheck;
        private boolean firstKey;
        private boolean editingKeyBind;
        private String newName;

        ScriptConfigScreen(ClientScriptScreen parent, ClientScriptInstance scriptInstance) {
            super((class_2561)Texts.SCRIPT_CONFIG.generate(scriptInstance.getName()), parent);
            this.scriptInstance = scriptInstance;
            String scriptName = scriptInstance.getName();
            this.nameBox = new class_342(EssentialUtils.getClient().field_1772, 0, 0, 200, 20, Texts.SCRIPT_NAME);
            this.nameBox.method_1852(scriptName);
            this.nameBox.method_1863(s -> {
                this.newName = s;
            });
            this.openBox = WidgetHelper.newButton(0, 0, 200, 20, Texts.OPEN_SCRIPT, button -> class_156.method_668().method_672(this.scriptInstance.getFileLocation().toFile()));
            this.deleteBox = WidgetHelper.newButton(0, 0, 200, 20, Texts.DELETE_SCRIPT, button -> {
                try {
                    this.scriptInstance.delete();
                    ((ClientScriptScreen)((Object)((Object)this.getParent()))).scriptWidget.clear();
                    ((ClientScriptScreen)((Object)((Object)this.getParent()))).scriptWidget.load(this.field_22787);
                    super.method_25419();
                }
                catch (IOException e) {
                    EssentialClient.LOGGER.error("Failed to delete script", (Throwable)e);
                }
            });
            this.keyBindBox = WidgetHelper.newButton(0, 0, 75, 20, (class_2561)class_2561.method_43471((String)scriptInstance.getKeyBind().getDisplay()), button -> {
                this.editingKeyBind = true;
                this.firstKey = true;
            });
            this.selectedCheck = class_4286.method_54787((class_2561)Texts.SELECTED, (class_327)EssentialUtils.getClient().field_1772).method_54789(0, 0).method_54794(ClientScript.INSTANCE.isSelected(scriptName)).method_54791((w, b) -> {
                if (b) {
                    ClientScript.INSTANCE.removeSelectedInstance(scriptName);
                } else {
                    ClientScript.INSTANCE.addSelectedInstance(scriptName);
                }
            }).method_54788();
            this.newName = "";
        }

        protected void method_25426() {
            int halfHeight = this.field_22790 / 2;
            int halfWidth = this.field_22789 / 2;
            this.nameBox.method_48229(halfWidth - 100, halfHeight - 55);
            this.openBox.method_48229(halfWidth - 100, halfHeight - 25);
            this.deleteBox.method_48229(halfWidth - 100, halfHeight);
            this.keyBindBox.method_48229(halfWidth - 50, halfHeight + 25);
            this.selectedCheck.method_48229(this.keyBindBox.method_46426() + 80, halfHeight + 25);
            this.method_37063((class_364)this.nameBox);
            this.method_37063((class_364)this.openBox);
            this.method_37063((class_364)this.deleteBox);
            this.method_37063((class_364)this.keyBindBox);
            this.method_37063((class_364)this.selectedCheck);
            this.method_37063((class_364)WidgetHelper.newButton(halfWidth - 100, this.field_22790 - 27, 200, 20, Texts.DONE, button -> this.method_25419()));
            this.method_25395((class_364)this.nameBox);
            super.method_25426();
        }

        @Override
        public void method_25419() {
            if (!this.newName.isEmpty() && !this.newName.equals(this.scriptInstance.getName())) {
                try {
                    Path original = this.scriptInstance.getFileLocation();
                    Path newLocation = original.resolveSibling(this.newName + ".arucas");
                    if (Files.exists(newLocation, new LinkOption[0])) {
                        throw new FileAlreadyExistsException("Tried to rename to an existing file");
                    }
                    this.scriptInstance.renameScript(this.newName, newLocation);
                    Files.move(original, newLocation, new CopyOption[0]);
                    ((ClientScriptScreen)((Object)this.getParent())).refresh();
                }
                catch (Exception exception) {
                    EssentialClient.LOGGER.error((Object)exception);
                }
            }
            super.method_25419();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.editingKeyBind) {
                this.editingKeyBind = false;
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25400(char chr, int keyCode) {
            return this.nameBox.method_25400(chr, keyCode);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.editingKeyBind) {
                MultiKeyBind keyBind = this.scriptInstance.getKeyBind();
                if (((ClientKeyBind)keyBind).isSingleKey()) {
                    class_3675.class_306 key = keyCode == 256 ? class_3675.field_16237 : class_3675.method_15985((int)keyCode, (int)scanCode);
                    ((ClientKeyBind)keyBind).addKey(key);
                    this.editingKeyBind = false;
                    return true;
                }
                if (this.firstKey) {
                    this.firstKey = false;
                    ((ClientKeyBind)keyBind).clearKey();
                }
                if (keyCode == 256) {
                    this.editingKeyBind = false;
                    return true;
                }
                ((ClientKeyBind)keyBind).addKey(class_3675.method_15985((int)keyCode, (int)scanCode));
                return true;
            }
            if (keyCode == 257 && this.nameBox.method_25370()) {
                this.newName = this.nameBox.method_1882();
                this.nameBox.method_25365(false);
            }
            return super.method_25404(keyCode, scanCode, modifiers) || this.nameBox.method_25404(keyCode, scanCode, modifiers);
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            context.method_27535(this.field_22793, Texts.SCRIPT_NAME, (int)((float)this.field_22789 / 2.0f - 100.0f), (int)((float)this.field_22790 / 2.0f - 68.0f), 0x949494);
            context.method_27535(this.field_22793, Texts.KEYBIND, (int)((float)this.field_22789 / 2.0f - 100.0f), (int)((float)this.field_22790 / 2.0f + 30.0f), 0xE0E0E0);
            context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
            MultiKeyBind keyBinding = this.scriptInstance.getKeyBind();
            class_5250 editMessage = class_2561.method_43470((String)keyBinding.getDisplay());
            if (this.field_22787 != null && this.field_22787.field_1772.method_27525((class_5348)editMessage) > 70) {
                editMessage = class_2561.method_43470((String)"...");
            }
            if (this.editingKeyBind) {
                this.keyBindBox.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)editMessage.method_27692(class_124.field_1054)).method_27693(" <").method_27692(class_124.field_1054));
            } else {
                this.keyBindBox.method_25355((class_2561)editMessage);
            }
            if (this.keyBindBox.method_25405((double)mouseX, (double)mouseY)) {
                String display = keyBinding.getDisplay();
                List<class_2561> textList = List.of(class_2561.method_43470((String)keyBinding.getName()).method_27692(class_124.field_1065), display.isEmpty() ? Texts.NO_KEYBINDING : class_2561.method_43470((String)display));
                context.method_51434(this.field_22793, textList, mouseX, mouseY);
            }
        }
    }
}

