/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.gui;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.feature.CarpetClient;
import me.senseiwells.essentialclient.gui.config.ConfigListWidget;
import me.senseiwells.essentialclient.gui.entries.BaseListEntry;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.rule.game.VanillaGameRules;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.interfaces.Rule;
import me.senseiwells.essentialclient.utils.render.ChildScreen;
import me.senseiwells.essentialclient.utils.render.Texts;
import me.senseiwells.essentialclient.utils.render.WidgetHelper;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5481;

public abstract class RulesScreen
extends ChildScreen {
    private List<class_5481> tooltip;
    private ConfigListWidget widget;
    private class_342 searchBox;
    private boolean invalid;
    private boolean isEmpty;

    public RulesScreen(class_2561 screenName, class_437 parent) {
        super(screenName, parent);
    }

    public String getSearchBoxText() {
        return this.searchBox.method_1882();
    }

    public void setCurrentTooltip(List<class_5481> tooltip) {
        this.tooltip = tooltip;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public void setEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public void refreshRules(String filter) {
        this.widget.reloadEntries(this, filter);
    }

    public void refreshScroll() {
        this.widget.method_25307(0.0);
    }

    public abstract Collection<? extends Rule<?>> getRules(String var1);

    public Comparator<BaseListEntry<?>> entryComparator() {
        return Comparator.comparing(a -> a.getRule().getName());
    }

    public boolean canModify() {
        return true;
    }

    public boolean shouldCategorise() {
        return ((String)ClientRules.DISPLAY_RULE_TYPE.getValue()).equals("Categories");
    }

    protected void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 100, 22, 200, 15, Texts.EMPTY);
        this.searchBox.method_1863(s -> {
            this.refreshScroll();
            this.refreshRules((String)s);
        });
        this.widget = new ConfigListWidget(this, this.field_22787, this.searchBox.method_1882());
        this.method_37063((class_364)this.widget);
        this.method_37063((class_364)this.searchBox);
        this.method_37063((class_364)WidgetHelper.newButton(this.field_22789 / 2 - 100, this.field_22790 - 27, 200, 20, Texts.DONE, buttonWidget -> this.method_25419()));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.widget.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        if (this.invalid) {
            String text = this.isEmpty ? "You can't leave a field empty!" : "Invalid value!";
            int n = 20 + this.field_22793.method_1727(text);
            Objects.requireNonNull(this.field_22793);
            context.method_25294(8, 9, n, 14 + 9, 0x68000000);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)text), 18, 12, 0xFF5555);
        }
        if (this.tooltip != null) {
            context.method_51447(this.field_22793, this.tooltip, mouseX, mouseY);
            this.tooltip = null;
        }
    }

    @Override
    public void method_25419() {
        if (this.field_22787 != null) {
            this.widget.updateAllEntriesOnClose();
        }
        super.method_25419();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.searchBox.method_25365(false);
        this.widget.unFocusAll();
        return super.method_25402(mouseX, mouseY, button);
    }

    public static RulesScreen getClientRulesScreen(class_437 parent) {
        return new RulesScreen(Texts.CLIENT_SCREEN, parent){

            @Override
            public Collection<? extends Rule<?>> getRules(String filter) {
                return ClientRules.getClientRules();
            }
        };
    }

    public static RulesScreen getCarpetRulesScreen(class_437 parent) {
        return new RulesScreen(Texts.SERVER_SCREEN, parent){

            @Override
            public Collection<? extends Rule<?>> getRules(String filter) {
                return CarpetClient.INSTANCE.getCurrentCarpetRules();
            }

            @Override
            public boolean canModify() {
                return EssentialUtils.getClient().method_1542() || CarpetClient.INSTANCE.isServerCarpet() && EssentialUtils.playerHasOp();
            }
        };
    }

    public static RulesScreen getGameRulesScreen(class_437 parent) {
        return new RulesScreen(Texts.GAME_RULE_SCREEN, parent){

            @Override
            public Collection<? extends Rule<?>> getRules(String filter) {
                return VanillaGameRules.getGameRules();
            }

            @Override
            public boolean canModify() {
                return EssentialClient.GAME_RULE_NET_HANDLER.canModifyRules();
            }

            @Override
            public boolean shouldCategorise() {
                return true;
            }
        };
    }
}

