/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.feature.keybinds;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.clientscript.core.ClientScript;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkDebugScreen;
import me.senseiwells.essentialclient.feature.keybinds.ClientKeyBind;
import me.senseiwells.essentialclient.feature.keybinds.MultiKeyBind;
import me.senseiwells.essentialclient.feature.keybinds.SingleKeyBind;
import me.senseiwells.essentialclient.gui.clientscript.ClientScriptScreen;
import me.senseiwells.essentialclient.gui.config.ConfigScreen;
import me.senseiwells.essentialclient.utils.config.MappedStringConfig;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class ClientKeyBinds
extends MappedStringConfig<ClientKeyBind> {
    private static final String DEFAULT_CATEGORY = "Essential Client";
    public static final ClientKeyBinds INSTANCE = new ClientKeyBinds();
    public static final MultiKeyBind ACCURATE_REVERSE = ClientKeyBinds.registerMulti("Accurate Reverse", new int[0]);
    public static final MultiKeyBind ACCURATE_INTO = ClientKeyBinds.registerMulti("Accurate Into", new int[0]);
    public static final MultiKeyBind CLIENT_SCRIPT_TOGGLE_ALL = ClientKeyBinds.registerMulti("Toggle Selected Scripts", (class_310 client) -> ClientScript.INSTANCE.startAllInstances(), new int[0]);
    public static final MultiKeyBind CLIENT_SCRIPT_STOP_ALL = ClientKeyBinds.registerMulti("Stop Selected Scripts", (class_310 client) -> ClientScript.INSTANCE.stopAllInstances(), new int[0]);
    public static final MultiKeyBind OPEN_ESSENTIAL_CLIENT_MENU = ClientKeyBinds.registerMulti("Open Essential Client Menu", (class_310 client) -> ClientKeyBinds.setScreenIfNull(client, () -> new ConfigScreen(null)), new int[0]);
    public static final MultiKeyBind OPEN_CHUNK_DEBUG;
    public static final MultiKeyBind OPEN_CLIENT_SCRIPT;
    public static final SingleKeyBind TOGGLE_DEBUG_MENU;
    private final Map<String, List<class_3675.class_306>> unregisteredKeyBinds = new HashMap<String, List<class_3675.class_306>>();

    private ClientKeyBinds() {
    }

    public static void load() {
    }

    @Override
    protected JsonElement valueToJson(ClientKeyBind value) {
        JsonArray keys = new JsonArray();
        for (class_3675.class_306 key : value.getKeys()) {
            keys.add(key.method_1441());
        }
        JsonObject keyData = new JsonObject();
        keyData.add("keys", (JsonElement)keys);
        keyData.addProperty("canUseInGui", Boolean.valueOf(value.canUseInGui()));
        return keyData;
    }

    @Override
    protected ClientKeyBind jsonToValue(String key, JsonElement valueElement) {
        ClientKeyBind existingKeyBind = (ClientKeyBind)this.map.get(key);
        ArrayList<class_3675.class_306> keys = new ArrayList<class_3675.class_306>();
        if (valueElement.isJsonPrimitive()) {
            keys.add(class_3675.method_15981((String)valueElement.getAsString()));
        } else if (valueElement.isJsonArray()) {
            for (Iterator element : valueElement.getAsJsonArray()) {
                keys.add(class_3675.method_15981((String)element.getAsString()));
            }
        } else {
            JsonObject keyData = valueElement.getAsJsonObject();
            for (JsonElement element : keyData.get("keys").getAsJsonArray()) {
                keys.add(class_3675.method_15981((String)element.getAsString()));
            }
            if (existingKeyBind != null && keyData.has("canUseInGui")) {
                existingKeyBind.setCanUseInGui(keyData.get("canUseInGui").getAsBoolean());
            }
        }
        if (existingKeyBind != null) {
            existingKeyBind.clearKey();
            for (class_3675.class_306 inputKey : keys) {
                existingKeyBind.addKey(inputKey);
            }
        } else {
            this.unregisteredKeyBinds.put(key, keys);
            EssentialClient.LOGGER.warn("Could not load keybind: {}", (Object)key);
        }
        return null;
    }

    @Override
    public JsonObject getSaveData() {
        JsonObject object = new JsonObject();
        this.map.forEach((k, v) -> object.add(k, this.valueToJson((ClientKeyBind)v)));
        this.unregisteredKeyBinds.forEach((s, keys) -> {
            JsonArray array = new JsonArray();
            for (class_3675.class_306 key : keys) {
                array.add(key.method_1441());
            }
            object.add(s, (JsonElement)array);
        });
        return super.getSaveData();
    }

    @Override
    public String getConfigName() {
        return "ClientKeyBinds";
    }

    public static void onKeyPress(class_3675.class_306 key, boolean isInGui) {
        for (ClientKeyBind keyBind : ClientKeyBinds.getAllKeyBinds()) {
            if (!keyBind.canUseInGui() && isInGui) continue;
            keyBind.press(key);
        }
    }

    public static void onKeyRelease(class_3675.class_306 key, boolean isInGui) {
        for (ClientKeyBind keyBind : ClientKeyBinds.getAllKeyBinds()) {
            if (!keyBind.canUseInGui() && isInGui) continue;
            keyBind.release(key);
        }
    }

    public static Collection<ClientKeyBind> getAllKeyBinds() {
        return ClientKeyBinds.INSTANCE.map.values();
    }

    public static MultiKeyBind registerMulti(String name, int ... keys) {
        return ClientKeyBinds.registerMulti(name, null, keys);
    }

    public static MultiKeyBind registerMulti(String name, ClientKeyBind.Callback onPressed, int ... keys) {
        return ClientKeyBinds.registerMulti(name, DEFAULT_CATEGORY, onPressed, keys);
    }

    public static MultiKeyBind registerMulti(String name, String category, ClientKeyBind.Callback onPressed, Collection<class_3675.class_306> keys) {
        return ClientKeyBinds.registerMulti(name, category, onPressed, keys.stream().mapToInt(class_3675.class_306::method_1444).toArray());
    }

    public static MultiKeyBind registerMulti(String name, String category, ClientKeyBind.Callback onPressed, int ... keys) {
        ClientKeyBind clientKeyBind = (ClientKeyBind)ClientKeyBinds.INSTANCE.map.get(name);
        if (clientKeyBind instanceof MultiKeyBind) {
            MultiKeyBind multiKeyBind = (MultiKeyBind)clientKeyBind;
            multiKeyBind.setCallback(onPressed);
            return multiKeyBind;
        }
        if (clientKeyBind != null) {
            EssentialClient.LOGGER.warn("Overwriting key bind {}", (Object)name);
        }
        MultiKeyBind keyBind = new MultiKeyBind(name, category, new class_3675.class_306[0]);
        List<class_3675.class_306> inputKeys = ClientKeyBinds.INSTANCE.unregisteredKeyBinds.remove(name);
        if (inputKeys != null) {
            keyBind.clearKey();
            inputKeys.forEach(keyBind::addKey);
        } else {
            keyBind.addKeys(keys);
        }
        keyBind.setCallback(onPressed);
        ClientKeyBinds.INSTANCE.map.put(name, keyBind);
        return keyBind;
    }

    public static SingleKeyBind registerSingle(String name, int key) {
        return ClientKeyBinds.registerSingle(name, null, key);
    }

    public static SingleKeyBind registerSingle(String name, ClientKeyBind.Callback onPressed, int key) {
        return ClientKeyBinds.registerSingle(name, DEFAULT_CATEGORY, onPressed, key);
    }

    public static SingleKeyBind registerSingle(String name, String category, ClientKeyBind.Callback onPressed, int key) {
        ClientKeyBind clientKeyBind = (ClientKeyBind)ClientKeyBinds.INSTANCE.map.get(name);
        if (clientKeyBind instanceof SingleKeyBind) {
            SingleKeyBind singleKeyBind = (SingleKeyBind)clientKeyBind;
            singleKeyBind.setCallback(onPressed);
            return singleKeyBind;
        }
        if (clientKeyBind != null) {
            EssentialClient.LOGGER.warn("Overwriting key bind {}", (Object)name);
        }
        SingleKeyBind keyBind = new SingleKeyBind(name, category, class_3675.method_15985((int)key, (int)0));
        List<class_3675.class_306> inputKeys = ClientKeyBinds.INSTANCE.unregisteredKeyBinds.remove(name);
        if (inputKeys != null && inputKeys.size() == 1) {
            keyBind.addKey(inputKeys.get(0));
        }
        keyBind.setCallback(onPressed);
        ClientKeyBinds.INSTANCE.map.put(name, keyBind);
        return keyBind;
    }

    public static ClientKeyBind unregisterKeyBind(String name) {
        return (ClientKeyBind)ClientKeyBinds.INSTANCE.map.remove(name);
    }

    private static void setScreenIfNull(class_310 client, Supplier<class_437> screenFactory) {
        if (client.field_1755 == null) {
            client.method_1507(screenFactory.get());
        }
    }

    static {
        OPEN_CLIENT_SCRIPT = ClientKeyBinds.registerMulti("Open Client Script", (class_310 client) -> ClientKeyBinds.setScreenIfNull(client, () -> new ClientScriptScreen(null)), new int[0]);
        OPEN_CHUNK_DEBUG = ClientKeyBinds.registerMulti("Open Chunk Debug", (class_310 client) -> {
            if (EssentialClient.CHUNK_NET_HANDLER.isAvailable()) {
                if (client.field_1755 instanceof ChunkDebugScreen) {
                    client.field_1755.method_25419();
                    return;
                }
                ClientKeyBinds.setScreenIfNull(client, () -> new ChunkDebugScreen(null));
            }
        }, 295);
        TOGGLE_DEBUG_MENU = ClientKeyBinds.registerSingle("Toggle Debug Menu", 292);
    }
}

