/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.feature.keybinds;

import java.util.Collection;
import java.util.Iterator;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;

public abstract class ClientKeyBind
implements Comparable<ClientKeyBind> {
    private final String name;
    private final String category;
    private boolean canUseInGui;
    private boolean isPressed;
    private Callback callback;

    ClientKeyBind(String name, String category) {
        this.name = name;
        this.category = category;
    }

    public abstract void press(class_3675.class_306 var1);

    public abstract void release(class_3675.class_306 var1);

    public abstract void addKey(class_3675.class_306 var1);

    public abstract void clearKey();

    public abstract void resetKey();

    public abstract boolean isSingleKey();

    public abstract boolean isDefault();

    public abstract Collection<class_3675.class_306> getKeys();

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public Callback getCallback() {
        return this.callback;
    }

    void setPressed(boolean pressed) {
        this.isPressed = pressed;
    }

    void setCanUseInGui(boolean canUseInGui) {
        this.canUseInGui = canUseInGui;
    }

    void callCallback() {
        if (this.callback != null) {
            this.callback.pressed(EssentialUtils.getClient());
        }
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean canUseInGui() {
        return this.canUseInGui;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDisplay() {
        StringBuilder builder = new StringBuilder();
        Iterator<class_3675.class_306> keyIterator = this.getKeys().iterator();
        while (keyIterator.hasNext()) {
            builder.append(keyIterator.next().method_27445().getString());
            if (!keyIterator.hasNext()) continue;
            builder.append(" + ");
        }
        return builder.toString();
    }

    @Override
    public int compareTo(@NotNull ClientKeyBind o) {
        return this.name.compareTo(o.name);
    }

    @FunctionalInterface
    public static interface Callback {
        public void pressed(class_310 var1);
    }
}

