/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.feature.chunkdebug;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkDebugScreen;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkInfo;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkLevel;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.render.RenderHelper;
import me.senseiwells.essentialclient.utils.render.Texts;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_746;

public class ChunkGrid {
    public static ChunkGrid instance;
    private int width;
    private int height;
    private int columns;
    private int rows;
    private int startX = 0;
    private int startY = 0;
    private int scale = 10;
    private final class_310 client;
    private final DraggablePoint cornerPoint;
    private final Point staticCentrePoint = new Point();
    private final Point minimapCornerPoint = new Point();
    private final Point mouseDown = new Point();
    private final List<class_5321<class_1937>> dimensions;
    private final Map<class_5321<class_1937>, DraggablePoint> dimensionPoints = new LinkedHashMap<class_5321<class_1937>, DraggablePoint>();
    private boolean panning = false;
    private int dimensionIndex = 0;
    private class_2561 selectionText = null;
    private Minimap minimapMode = Minimap.NONE;

    public ChunkGrid(class_310 client, int width, int height) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.updateRowsAndColumns();
        for (class_5321 key : EssentialUtils.getNetworkHandler().method_29356()) {
            this.dimensionPoints.put((class_5321<class_1937>)key, null);
        }
        this.dimensions = this.dimensionPoints.keySet().stream().toList();
        class_746 player = client.field_1724;
        if (player != null) {
            class_1923 pos = player.method_31476();
            this.cornerPoint = new DraggablePoint(this.getCornerOfCentre(pos.field_9181, pos.field_9180));
            int dimensionIndex = this.dimensions.indexOf(player.method_5770().method_27983());
            this.dimensionIndex = dimensionIndex == -1 ? 0 : dimensionIndex;
        } else {
            this.cornerPoint = new DraggablePoint(this.getCornerOfCentre(0, 0));
        }
        this.cornerPoint.mainPoint.y += 5;
    }

    private void updateRowsAndColumns() {
        this.rows = (int)Math.floor((float)this.height / (float)this.scale);
        this.columns = (int)Math.ceil((float)this.width / (float)this.scale);
    }

    public void render(int thisX, int thisY, int width, int height, boolean isMinimap) {
        DraggablePoint selectionPoint;
        int cellY;
        int cellX;
        int z;
        int x;
        this.width = width;
        this.height = height;
        this.startX = thisX;
        this.startY = thisY;
        this.updateRowsAndColumns();
        class_289 tessellator = class_289.method_1348();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.setPositionColourShader();
        class_287 bufferBuilder = RenderHelper.startQuads(tessellator, class_290.field_1576);
        if (isMinimap && ((Boolean)ClientRules.CHUNK_DEBUG_MINIMAP_BACKGROUND.getValue()).booleanValue()) {
            int thatX = thisX + this.scale * (this.columns + 1);
            int thatY = thisY + this.scale * (this.rows + 1);
            bufferBuilder.method_22912((float)(thisX - 5), (float)(thisY - 5), 0.0f).method_1336(53, 59, 72, 200);
            bufferBuilder.method_22912((float)(thisX - 5), (float)(thatY + 5), 0.0f).method_1336(53, 59, 72, 200);
            bufferBuilder.method_22912((float)(thatX + 5), (float)(thatY + 5), 0.0f).method_1336(53, 59, 72, 200);
            bufferBuilder.method_22912((float)(thatX + 5), (float)(thisY - 5), 0.0f).method_1336(53, 59, 72, 200);
            bufferBuilder.method_22912((float)thisX, (float)thisY, 0.0f).method_1336(45, 52, 54, 200);
            bufferBuilder.method_22912((float)thisX, (float)thatY, 0.0f).method_1336(45, 52, 54, 200);
            bufferBuilder.method_22912((float)thatX, (float)thatY, 0.0f).method_1336(45, 52, 54, 200);
            bufferBuilder.method_22912((float)thatX, (float)thisY, 0.0f).method_1336(45, 52, 54, 200);
        }
        for (ChunkInfo info : EssentialClient.CHUNK_NET_HANDLER.getChunks(this.getDimension())) {
            if (info.level() == ChunkLevel.UNLOADED && !((Boolean)ClientRules.CHUNK_DEBUG_SHOW_UNLOADED_CHUNKS.getValue()).booleanValue()) continue;
            x = info.getX() - (isMinimap ? this.minimapCornerPoint.x : this.cornerPoint.getX());
            z = info.getZ() - (isMinimap ? this.minimapCornerPoint.y : this.cornerPoint.getY());
            if (x < 0 || x > this.columns || z < 0 || z > this.rows) continue;
            cellX = thisX + x * this.scale;
            cellY = thisY + z * this.scale;
            this.drawBox(bufferBuilder, cellX, cellY, x, z, info.getColour());
        }
        class_746 player = this.client.field_1724;
        if (player != null && this.isPlayerInDimension((class_1657)player)) {
            class_1923 playerChunkPos = player.method_31476();
            x = playerChunkPos.field_9181 - (isMinimap ? this.minimapCornerPoint.x : this.cornerPoint.getX());
            z = playerChunkPos.field_9180 - (isMinimap ? this.minimapCornerPoint.y : this.cornerPoint.getY());
            if (x >= 0 && x <= this.columns && z >= 0 && z <= this.rows) {
                cellX = thisX + x * this.scale;
                cellY = thisY + z * this.scale;
                this.drawCross(tessellator, cellX, cellY, thisX, thisY);
            }
        }
        if ((selectionPoint = this.getSelectionPoint()) != null) {
            Point drawingPoint = selectionPoint.mainPoint;
            if (isMinimap) {
                int minimapSelectionX = this.cornerPoint.getX() + selectionPoint.getX() - this.minimapCornerPoint.x;
                int minimapSelectionZ = this.cornerPoint.getY() + selectionPoint.getY() - this.minimapCornerPoint.y;
                drawingPoint = new Point(minimapSelectionX, minimapSelectionZ);
            }
            this.drawSelectionBox(tessellator, drawingPoint, thisX, thisY);
            this.updateSelectionInfo();
        } else {
            this.selectionText = null;
        }
        if (!isMinimap) {
            this.updateStaticCentre();
        }
        RenderSystem.disableBlend();
    }

    public void renderMinimap(int width, int height) {
        if (this.minimapMode == Minimap.NONE) {
            return;
        }
        this.width = (int)((float)width * 0.25f);
        this.height = (int)((float)height * 0.45f);
        this.updateRowsAndColumns();
        int minimapX = width - this.scale * (this.columns + 1) - 10;
        int minimapY = 10;
        switch (this.minimapMode.ordinal()) {
            case 1: {
                Point minimapCorner = this.getCornerOfCentre(this.staticCentrePoint.x, this.staticCentrePoint.y);
                this.minimapCornerPoint.setLocation(minimapCorner);
                break;
            }
            case 2: {
                class_746 player = this.client.field_1724;
                if (player == null) break;
                if (!this.isPlayerInDimension((class_1657)player) && !(this.client.field_1755 instanceof ChunkDebugScreen)) {
                    this.setDimension(player.method_5770());
                    EssentialClient.CHUNK_NET_HANDLER.requestChunkData(this.getDimension());
                }
                class_1923 pos = player.method_31476();
                Point minimapCorner = this.getCornerOfCentre(pos.field_9181, pos.field_9180);
                this.minimapCornerPoint.setLocation(minimapCorner);
            }
        }
        this.render(minimapX, minimapY, this.width, this.height, true);
    }

    private void drawBox(class_287 bufferBuilder, int cellX, int cellY, int x, int y, int colour) {
        if ((x + y) % 2 == 0) {
            colour = ChunkGrid.brighten(colour, 0.14f);
        }
        int red = (colour & 0xFF0000) >> 16;
        int green = (colour & 0xFF00) >> 8;
        int blue = colour & 0xFF;
        bufferBuilder.method_22912((float)cellX, (float)cellY, 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)cellX, (float)(cellY + this.scale), 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)(cellX + this.scale), (float)(cellY + this.scale), 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)(cellX + this.scale), (float)cellY, 0.0f).method_1336(red, green, blue, 255);
    }

    private void drawSelectionBox(class_289 tessellator, Point selectionPoint, int thisX, int thisY) {
        int red = 247;
        int green = 240;
        int blue = 6;
        int x = selectionPoint.x;
        int z = selectionPoint.y;
        int scaledX = x * this.scale;
        int scaledZ = z * this.scale;
        int cellX = thisX + scaledX;
        int cellY = thisY + scaledZ;
        if (cellX < thisX || cellY < thisY || cellX + this.scale > thisX + this.width || cellY + this.scale > thisY + this.height) {
            return;
        }
        class_287 bufferBuilder = RenderHelper.startDebugLines(tessellator, class_290.field_1576);
        bufferBuilder.method_22912((float)cellX, (float)cellY, 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)cellX, (float)(cellY + this.scale), 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)cellX, (float)(cellY + this.scale), 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)(cellX + this.scale), (float)(cellY + this.scale), 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)(cellX + this.scale), (float)(cellY + this.scale), 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)(cellX + this.scale), (float)cellY, 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)(cellX + this.scale), (float)cellY, 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)cellX, (float)cellY, 0.0f).method_1336(red, green, blue, 255);
    }

    private void drawCross(class_289 tessellator, int cellX, int cellY, int x, int y) {
        int red = 247;
        int green = 240;
        int blue = 6;
        if (cellX < x || cellY < y || cellX + this.scale > x + this.width || cellY + this.scale > y + this.height) {
            return;
        }
        class_287 bufferBuilder = RenderHelper.startDebugLines(tessellator, class_290.field_1576);
        bufferBuilder.method_22912((float)cellX, (float)cellY, 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)(cellX + this.scale), (float)(cellY + this.scale), 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)(cellX + this.scale), (float)cellY, 0.0f).method_1336(red, green, blue, 255);
        bufferBuilder.method_22912((float)cellX, (float)(cellY + this.scale), 0.0f).method_1336(red, green, blue, 255);
    }

    public boolean onScroll(double mouseX, double mouseY, double amount) {
        if (this.isInBounds(mouseX, mouseY) && !this.panning && (amount > 0.0 && this.scale < 20 || amount < 0.0 && this.scale > 1)) {
            this.syncSelectionPointsWithCorner(() -> this.updateCornerScroll(class_3532.method_15350((double)amount, (double)-1.0, (double)1.0)));
            return true;
        }
        return false;
    }

    private void updateCornerScroll(double scrollAmount) {
        this.scale += (int)scrollAmount;
        Point centre = this.getCentre();
        this.updateRowsAndColumns();
        this.cornerPoint.setLocation(this.getCornerOfCentre(centre.x, centre.y));
    }

    public void onClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isInBounds(mouseX, mouseY)) {
            this.mouseDown.setLocation((int)mouseX, (int)mouseY);
            this.cornerPoint.getDragPoint().setLocation(this.cornerPoint.mainPoint);
            this.dimensionPoints.values().forEach(draggablePoint -> {
                if (draggablePoint != null) {
                    draggablePoint.dragPoint.setLocation(draggablePoint.mainPoint);
                }
            });
        }
    }

    public void onRelease(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.panning) {
            Point newSelectionPoint = this.getPointFromPosition(mouseX, mouseY);
            DraggablePoint oldSelectionPoint = this.getSelectionPoint();
            if (oldSelectionPoint != null && oldSelectionPoint.mainPoint.equals(newSelectionPoint)) {
                this.setSelectionPoint(null);
                this.selectionText = null;
            } else if (newSelectionPoint != null) {
                this.setSelectionPoint(new DraggablePoint(newSelectionPoint));
                this.updateSelectionInfo();
            }
        }
        this.panning = false;
    }

    public void onDragged(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isInBounds(mouseX, mouseY)) {
            int changeX = (int)(mouseX - this.mouseDown.getX()) / this.scale;
            int changeY = (int)(mouseY - this.mouseDown.getY()) / this.scale;
            if (!this.panning && changeX * changeX + changeY * changeY > 2) {
                this.panning = true;
            } else if (this.panning) {
                int dragX = this.cornerPoint.dragPoint.x - changeX;
                int dragY = this.cornerPoint.dragPoint.y - changeY;
                this.cornerPoint.setLocation(dragX, dragY);
                this.updateSelectionPointDrag(changeX, changeY);
            }
        }
    }

    public void onResize(int newWidth, int newHeight) {
        Point centre = this.getCentre();
        this.width = newWidth;
        this.height = newHeight;
        this.updateRowsAndColumns();
        this.setCentre(centre.x, centre.y);
    }

    public void setCentre(int x, int y) {
        this.syncSelectionPointsWithCorner(() -> this.cornerPoint.setLocation(this.getCornerOfCentre(x, y)));
    }

    private void syncSelectionPointsWithCorner(Runnable cornerFunction) {
        Collection<DraggablePoint> draggablePoints = this.dimensionPoints.values();
        draggablePoints.forEach(draggablePoint -> {
            if (draggablePoint != null) {
                draggablePoint.setLocation(this.cornerPoint.getX() + draggablePoint.getX(), this.cornerPoint.getY() + draggablePoint.getY());
            }
        });
        cornerFunction.run();
        draggablePoints.forEach(draggablePoint -> {
            if (draggablePoint != null) {
                draggablePoint.setLocation(draggablePoint.getX() - this.cornerPoint.getX(), draggablePoint.getY() - this.cornerPoint.getY());
            }
        });
    }

    private void updateSelectionPointDrag(int changeX, int changeY) {
        this.dimensionPoints.values().forEach(draggablePoint -> {
            if (draggablePoint != null) {
                int dragX = draggablePoint.dragPoint.x + changeX;
                int dragY = draggablePoint.dragPoint.y + changeY;
                draggablePoint.setLocation(dragX, dragY);
            }
        });
    }

    public void updateSelectionInfo() {
        DraggablePoint selectionPoint = this.getSelectionPoint();
        if (selectionPoint != null) {
            class_1923 chunkPos = new class_1923(this.cornerPoint.getX() + selectionPoint.getX(), this.cornerPoint.getY() + selectionPoint.getY());
            Optional<ChunkInfo> chunkData = EssentialClient.CHUNK_NET_HANDLER.getChunk(this.getDimension(), chunkPos);
            boolean isEmpty = chunkData.isEmpty();
            class_5250 selection = Texts.SELECTED_CHUNK.generate("X: " + chunkPos.field_9181 + ", Z: " + chunkPos.field_9180);
            selection.method_27693(" || ");
            selection.method_10852((class_2561)Texts.CHUNK_STATUS.generate((isEmpty ? ChunkLevel.UNLOADED : chunkData.get().level()).getName()));
            if (!isEmpty) {
                ChunkInfo data = chunkData.get();
                if (data.hasTicket()) {
                    selection.method_27693(" || ");
                    selection.method_10852((class_2561)Texts.CHUNK_TICKET.generate(data.ticket().getName()));
                }
                selection.method_27693(" || ");
                selection.method_10852((class_2561)Texts.CHUNK_STAGE.generate(data.status().getName()));
            }
            this.selectionText = selection;
        }
    }

    private void updateStaticCentre() {
        this.staticCentrePoint.setLocation(this.getCentre());
    }

    public int getCentreX() {
        return this.getCentre().x;
    }

    public int getCentreZ() {
        return this.getCentre().y;
    }

    public class_5321<class_1937> getDimension() {
        return this.dimensions.get(this.dimensionIndex);
    }

    public boolean isPlayerInDimension(class_1657 player) {
        return this.getDimension().equals((Object)player.method_5770().method_27983());
    }

    private DraggablePoint getSelectionPoint() {
        return this.dimensionPoints.get(this.getDimension());
    }

    private void setSelectionPoint(DraggablePoint newPoint) {
        this.dimensionPoints.put(this.getDimension(), newPoint);
    }

    public class_2561 getSelectionText() {
        return this.selectionText;
    }

    public class_2561 getPrettyDimension() {
        class_5321<class_1937> dimension = this.getDimension();
        if (dimension == class_1937.field_25179) {
            return Texts.OVERWORLD;
        }
        if (dimension == class_1937.field_25180) {
            return Texts.NETHER;
        }
        if (dimension == class_1937.field_25181) {
            return Texts.END;
        }
        return class_2561.method_43470((String)dimension.method_29177().method_12832());
    }

    public void setDimension(class_1937 world) {
        int dimensionIndex = this.dimensions.indexOf(world.method_27983());
        this.dimensionIndex = dimensionIndex == -1 ? 0 : dimensionIndex;
    }

    public void cycleDimension() {
        if (this.dimensionIndex >= this.dimensions.size() - 1) {
            this.dimensionIndex = 0;
            return;
        }
        ++this.dimensionIndex;
    }

    public Minimap getMinimapMode() {
        return this.minimapMode;
    }

    public void cycleMinimap() {
        this.minimapMode = this.minimapMode.getNextMinimap();
    }

    public boolean isPanning() {
        return this.panning;
    }

    private boolean isInBounds(double mouseX, double mouseY) {
        boolean withinX = mouseX > (double)this.startX && mouseX < (double)(this.startX + this.width);
        boolean withinY = mouseY > (double)this.startY && mouseY < (double)(this.startY + this.height);
        return withinX && withinY;
    }

    private Point getCentre() {
        int centreX = this.cornerPoint.getX() + this.columns / 2;
        int centreY = this.cornerPoint.getY() + this.rows / 2;
        return new Point(centreX, centreY);
    }

    private Point getCornerOfCentre(int centreX, int centreY) {
        int cornerX = centreX - this.columns / 2;
        int cornerY = centreY - this.rows / 2;
        return new Point(cornerX, cornerY);
    }

    private Point getPointFromPosition(double x, double y) {
        if (!this.isInBounds(x, y)) {
            return null;
        }
        int pointX = (int)(x / (double)this.scale);
        int pointY = (int)((y -= 30.0) / (double)this.scale);
        return new Point(pointX, pointY);
    }

    private static int brighten(int colour, float factor) {
        int alpha = (colour & 0xFF000000) >>> 24;
        int red = (colour & 0xFF0000) >> 16;
        int green = (colour & 0xFF00) >> 8;
        int blue = colour & 0xFF;
        int mix = (int)((float)(red + green + blue) * factor / 3.0f);
        int redOverflow = Integer.max((red += mix) - 255, 0);
        int greenOverflow = Integer.max((green += mix) - 255, 0);
        int blueOverflow = Integer.max((blue += mix) - 255, 0);
        red = Integer.min(red - redOverflow * 3, 255);
        green = Integer.min(green - greenOverflow * 3, 255);
        blue = Integer.min(blue - blueOverflow * 3, 255);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static enum Minimap {
        NONE(Texts.MINIMAP_NONE),
        STATIC(Texts.MINIMAP_STATIC),
        FOLLOW(Texts.MINIMAP_FOLLOW);

        public final class_2561 prettyName;

        private Minimap(class_2561 prettyName) {
            this.prettyName = prettyName;
        }

        private Minimap getNextMinimap() {
            int ordinal = this.ordinal();
            if (this.ordinal() >= 2) {
                return NONE;
            }
            return Minimap.values()[ordinal + 1];
        }
    }

    private static class DraggablePoint {
        private final Point mainPoint;
        private final Point dragPoint = new Point();

        private DraggablePoint(Point main) {
            this.mainPoint = main;
        }

        private int getX() {
            return this.mainPoint.x;
        }

        private int getY() {
            return this.mainPoint.y;
        }

        private Point getDragPoint() {
            return this.dragPoint;
        }

        private void setLocation(Point newLocation) {
            this.mainPoint.setLocation(newLocation);
        }

        private void setLocation(int x, int y) {
            this.mainPoint.setLocation(x, y);
        }
    }
}

