/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.feature.chunkdebug;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkClusterScreen;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkClusters;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkGrid;
import me.senseiwells.essentialclient.utils.EssentialUtils;
import me.senseiwells.essentialclient.utils.render.ChildScreen;
import me.senseiwells.essentialclient.utils.render.RenderHelper;
import me.senseiwells.essentialclient.utils.render.Texts;
import me.senseiwells.essentialclient.utils.render.WidgetHelper;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ChunkDebugScreen
extends ChildScreen {
    public static final int HEADER_HEIGHT = 30;
    public static final int FOOTER_ROW_HEIGHT = 20;
    public static final int FOOTER_ROW_PADDING = 5;
    public static final int FOOTER_ROW_COUNT = 2;
    public static final int FOOTER_HEIGHT = 55;
    private final class_310 client = EssentialUtils.getClient();
    private NumberFieldWidget xPositionBox;
    private NumberFieldWidget zPositionBox;
    private boolean canClick = false;

    public ChunkDebugScreen(class_437 parent) {
        super(Texts.CHUNK_SCREEN, parent);
    }

    public void method_25426() {
        if (ChunkGrid.instance == null) {
            ChunkGrid.instance = new ChunkGrid(this.client, this.field_22789, this.field_22790);
        }
        EssentialClient.CHUNK_NET_HANDLER.requestChunkData(ChunkGrid.instance.getDimension());
        int buttonWidth = (this.field_22789 - 20) / 3;
        int buttonHeight = this.field_22790 - 60 + 10;
        class_2561 dimensionText = ChunkGrid.instance.getPrettyDimension();
        class_4185 dimensionButton = (class_4185)this.method_37063((class_364)WidgetHelper.newButton(5, buttonHeight, buttonWidth, 20, dimensionText, button -> {
            ChunkGrid.instance.cycleDimension();
            button.method_25355(ChunkGrid.instance.getPrettyDimension());
            EssentialClient.CHUNK_NET_HANDLER.requestChunkData(ChunkGrid.instance.getDimension());
        }));
        this.method_37063((class_364)WidgetHelper.newButton(buttonWidth + 10, buttonHeight, buttonWidth, 20, Texts.RETURN_TO_PLAYER, button -> {
            if (this.client.field_1724 != null) {
                ChunkGrid.instance.setDimension(this.client.field_1724.method_5770());
                dimensionButton.method_25355(ChunkGrid.instance.getPrettyDimension());
                int chunkX = this.client.field_1724.method_31476().field_9181;
                int chunkZ = this.client.field_1724.method_31476().field_9180;
                ChunkGrid.instance.setCentre(chunkX, chunkZ);
                this.xPositionBox.method_1852(String.valueOf(chunkX));
                this.zPositionBox.method_1852(String.valueOf(chunkZ));
                EssentialClient.CHUNK_NET_HANDLER.requestChunkData(ChunkGrid.instance.getDimension());
            }
        }));
        class_2561 initialMinimapText = ChunkGrid.instance.getMinimapMode().prettyName;
        this.method_37063((class_364)WidgetHelper.newButton(buttonWidth * 2 + 15, buttonHeight, buttonWidth, 20, initialMinimapText, button -> {
            ChunkGrid.instance.cycleMinimap();
            button.method_25355(ChunkGrid.instance.getMinimapMode().prettyName);
        }));
        buttonHeight = this.field_22790 - 40 + 15;
        this.xPositionBox = new NumberFieldWidget(this.field_22793, 33, buttonHeight, buttonWidth - 30, 20, Texts.X);
        this.xPositionBox.setInitialValue(ChunkGrid.instance.getCentreX());
        this.zPositionBox = new NumberFieldWidget(this.field_22793, buttonWidth + 10 + 28, buttonHeight, buttonWidth - 30, 20, Texts.Z);
        this.zPositionBox.setInitialValue(ChunkGrid.instance.getCentreZ());
        this.method_37063((class_364)WidgetHelper.newButton(buttonWidth * 2 + 15, buttonHeight, buttonWidth, 20, Texts.REFRESH, button -> {
            if (ChunkDebugScreen.method_25441()) {
                EssentialClient.CHUNK_NET_HANDLER.requestServerRefresh();
            } else {
                EssentialClient.CHUNK_NET_HANDLER.requestChunkData(ChunkGrid.instance.getDimension());
            }
        }));
        this.method_37063((class_364)WidgetHelper.newButton(5, 5, 90, 20, Texts.CHUNK_CLUSTER_SCREEN, button -> {
            Optional<ChunkClusters> optional = EssentialClient.CHUNK_NET_HANDLER.getChunkCluster(ChunkGrid.instance.getDimension());
            optional.ifPresent(clusters -> this.client.method_1507((class_437)new ChunkClusterScreen((ChunkClusters)clusters, this)));
        }));
        this.method_37063((class_364)this.xPositionBox);
        this.method_37063((class_364)this.zPositionBox);
    }

    public void method_25410(class_310 client, int width, int height) {
        if (ChunkGrid.instance != null) {
            ChunkGrid.instance.onResize(width, height - 30 - 55);
        }
        super.method_25410(client, width, height);
    }

    @Override
    public void method_25419() {
        this.method_25432();
        super.method_25419();
    }

    public void method_25432() {
        if (ChunkGrid.instance.getMinimapMode() == ChunkGrid.Minimap.NONE) {
            EssentialClient.CHUNK_NET_HANDLER.removeChunkData();
            EssentialClient.CHUNK_NET_HANDLER.clearAllChunks();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_52752(context);
        ChunkGrid.instance.render(0, 30, this.field_22789, this.field_22790 - 30 - 55, false);
        class_289 tessellator = class_289.method_1348();
        this.drawHeaderAndFooterGradient(tessellator);
        this.drawHeaderAndFooterTexture(tessellator);
        super.method_25394(context, mouseX, mouseY, delta);
        if (ChunkGrid.instance.isPanning()) {
            this.xPositionBox.method_1852(String.valueOf(ChunkGrid.instance.getCentreX()));
            this.zPositionBox.method_1852(String.valueOf(ChunkGrid.instance.getCentreZ()));
        }
        RenderHelper.drawScaledText(context, Texts.CHUNK_SCREEN, this.field_22789 / 2, 12, 1.5f, true);
        if (ChunkGrid.instance.getSelectionText() != null) {
            RenderHelper.drawScaledText(context, ChunkGrid.instance.getSelectionText(), this.field_22789 / 2, 40, 1.0f, true);
        }
        this.xPositionBox.method_25394(context, mouseX, mouseY, delta);
        this.zPositionBox.method_25394(context, mouseX, mouseY, delta);
        int textHeight = this.field_22790 - 20;
        int xOffset = 15;
        int zOffset = this.xPositionBox.method_25368() + 50;
        RenderHelper.drawScaledText(context, Texts.X, xOffset, textHeight, 1.5f, false);
        RenderHelper.drawScaledText(context, Texts.Z, zOffset, textHeight, 1.5f, false);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void drawHeaderAndFooterGradient(class_289 tessellator) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_287 bufferBuilder = RenderHelper.startQuads(tessellator, class_290.field_1576);
        bufferBuilder.method_22912(0.0f, 30.0f, 0.0f).method_1336(0, 0, 0, 255);
        bufferBuilder.method_22912(0.0f, 34.0f, 0.0f).method_1336(0, 0, 0, 0);
        bufferBuilder.method_22912((float)this.field_22789, 34.0f, 0.0f).method_1336(0, 0, 0, 0);
        bufferBuilder.method_22912((float)this.field_22789, 30.0f, 0.0f).method_1336(0, 0, 0, 255);
        bufferBuilder.method_22912(0.0f, (float)(this.field_22790 - 55 - 4), 0.0f).method_1336(0, 0, 0, 0);
        bufferBuilder.method_22912(0.0f, (float)(this.field_22790 - 55), 0.0f).method_1336(0, 0, 0, 255);
        bufferBuilder.method_22912((float)this.field_22789, (float)(this.field_22790 - 55), 0.0f).method_1336(0, 0, 0, 255);
        bufferBuilder.method_22912((float)this.field_22789, (float)(this.field_22790 - 55 - 4), 0.0f).method_1336(0, 0, 0, 0);
    }

    private void drawHeaderAndFooterTexture(class_289 tessellator) {
        RenderHelper.setPositionTextureColourShader();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        class_287 bufferBuilder = RenderHelper.startQuads(tessellator, class_290.field_1575);
        bufferBuilder.method_22912(0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912(0.0f, 30.0f, 0.0f).method_22913(0.0f, 0.9375f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)this.field_22789, 30.0f, 0.0f).method_22913((float)this.field_22789 / 32.0f, 0.9375f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)this.field_22789, 0.0f, 0.0f).method_22913((float)this.field_22789 / 32.0f, 0.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912(0.0f, (float)(this.field_22790 - 55), 0.0f).method_22913(0.0f, (float)(this.field_22790 - 55) / 32.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912(0.0f, (float)this.field_22790, 0.0f).method_22913(0.0f, (float)this.field_22790 / 32.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)this.field_22789, (float)this.field_22790, 0.0f).method_22913((float)this.field_22789 / 32.0f, (float)this.field_22790 / 32.0f).method_1336(64, 64, 64, 255);
        bufferBuilder.method_22912((float)this.field_22789, (float)(this.field_22790 - 55), 0.0f).method_22913((float)this.field_22789 / 32.0f, (float)(this.field_22790 - 55) / 32.0f).method_1336(64, 64, 64, 255);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return ChunkGrid.instance.onScroll(mouseX, mouseY, horizontalAmount + verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.canClick = true;
        ChunkGrid.instance.onClicked(mouseX, mouseY, button);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.canClick) {
            ChunkGrid.instance.onRelease(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        ChunkGrid.instance.onDragged(mouseX, mouseY, button);
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private class NumberFieldWidget
    extends class_342 {
        private int lastValidValue;

        private NumberFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
            super(textRenderer, x, y, width, height, text);
        }

        private void setInitialValue(int value) {
            this.lastValidValue = value;
            this.method_1852(String.valueOf(value));
        }

        private int getValue() {
            return this.lastValidValue;
        }

        public void method_25365(boolean focused) {
            if (this.method_25370() && !focused) {
                try {
                    int newValue = Integer.parseInt(this.method_1882());
                    if (this.lastValidValue != newValue) {
                        this.lastValidValue = newValue;
                        ChunkGrid.instance.setCentre(ChunkDebugScreen.this.xPositionBox.getValue(), ChunkDebugScreen.this.zPositionBox.getValue());
                    }
                }
                catch (NumberFormatException e) {
                    this.method_1852(String.valueOf(this.lastValidValue));
                }
            }
            super.method_25365(focused);
        }
    }
}

