/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essentialclient.feature.chunkdebug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.senseiwells.essentialclient.EssentialClient;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkClusters;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkGrid;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkInfo;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkLevel;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkStatus;
import me.senseiwells.essentialclient.feature.chunkdebug.ChunkTicket;
import me.senseiwells.essentialclient.feature.chunkdebug.WorldChunkInfo;
import me.senseiwells.essentialclient.rule.ClientRules;
import me.senseiwells.essentialclient.utils.network.NetworkHandler;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class ChunkClientNetworkHandler
extends NetworkHandler {
    public static final int VERSION = 106;
    private final Map<class_5321<class_1937>, WorldChunkInfo> chunkInfoMap = new HashMap<class_5321<class_1937>, WorldChunkInfo>();

    @Override
    public void onDisconnect() {
        super.onDisconnect();
        ChunkGrid.instance = null;
        this.clearAllChunks();
    }

    @Override
    public int getVersion() {
        return 106;
    }

    @Override
    protected void onHelloSuccess() {
        EssentialClient.LOGGER.info("Chunk Debug is available");
    }

    @Override
    protected void onHelloFail() {
        EssentialClient.LOGGER.info("Server has out of date Chunk Debug!");
    }

    public Optional<ChunkInfo> getChunk(class_5321<class_1937> world, class_1923 pos) {
        WorldChunkInfo chunks = this.chunkInfoMap.get(world);
        if (chunks == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(chunks.getInfo(pos.method_8324()));
    }

    public Iterable<ChunkInfo> getChunks(class_5321<class_1937> world) {
        WorldChunkInfo chunks = this.chunkInfoMap.get(world);
        if (chunks == null) {
            return List.of();
        }
        return chunks.getAllInfo();
    }

    public void clearAllChunks() {
        this.chunkInfoMap.forEach((s, chunkData) -> chunkData.clear());
    }

    public Optional<ChunkClusters> getChunkCluster(class_5321<class_1937> world) {
        WorldChunkInfo chunks = this.chunkInfoMap.get(world);
        return chunks == null ? Optional.empty() : Optional.of(chunks.getClusters());
    }

    public void updateChunks(class_5321<class_1937> world, Iterable<ChunkInfo> infos) {
        WorldChunkInfo chunks = this.chunkInfoMap.computeIfAbsent(world, k -> new WorldChunkInfo());
        ChunkClusters clusters = chunks.getClusters();
        for (ChunkInfo info : infos) {
            long position = info.position();
            chunks.remove(position);
            if (info.level() != ChunkLevel.UNLOADED) {
                clusters.add(position);
                chunks.add(info);
                continue;
            }
            clusters.remove(position);
            if (!((Boolean)ClientRules.CHUNK_DEBUG_SHOW_UNLOADED_CHUNKS.getValue()).booleanValue()) continue;
            chunks.add(info);
        }
    }

    public void removeChunkData() {
        this.sendPayload(StopChunkInfoPayload::new);
    }

    public void requestChunkData(class_5321<class_1937> world) {
        this.clearAllChunks();
        this.sendPayload(() -> new SetChunkDimensionPayload(world));
    }

    protected void requestServerRefresh() {
        this.clearAllChunks();
        this.sendPayload(ReloadChunkDebugPayload::new);
    }

    @Override
    public void registerCustomPayloads() {
        PayloadTypeRegistry.playC2S().register(ChunkDebugHelloPayload.ID, ChunkDebugHelloPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ReloadChunkDebugPayload.ID, ReloadChunkDebugPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(StopChunkInfoPayload.ID, StopChunkInfoPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetChunkDimensionPayload.ID, SetChunkDimensionPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ChunkDebugHelloPayload.ID, ChunkDebugHelloPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(BatchedChunkInfoPayload.ID, BatchedChunkInfoPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ChunkDebugHelloPayload.ID, (payload, context) -> this.onHello(context.player().field_3944, (NetworkHandler.HelloPayload)payload));
        ClientPlayNetworking.registerGlobalReceiver(BatchedChunkInfoPayload.ID, (payload, context) -> this.updateChunks(payload.world, payload.infos));
    }

    @Override
    protected NetworkHandler.HelloPayload createHelloPayload(String brand, int version) {
        return new ChunkDebugHelloPayload(brand, version);
    }

    private static class ChunkDebugHelloPayload
    extends NetworkHandler.HelloPayload {
        public static final class_8710.class_9154<ChunkDebugHelloPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"chunk_debug:hello"));
        public static final class_9139<class_2540, ChunkDebugHelloPayload> CODEC = class_9139.method_56438(NetworkHandler.HelloPayload::write, ChunkDebugHelloPayload::new);

        public ChunkDebugHelloPayload(String brand, int version) {
            super(brand, version);
        }

        public ChunkDebugHelloPayload(class_2540 buf) {
            super(buf.method_19772(), buf.readInt());
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    private record ReloadChunkDebugPayload() implements class_8710
    {
        public static final class_8710.class_9154<ReloadChunkDebugPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"chunk_debug:reload"));
        public static final class_9139<class_2540, ReloadChunkDebugPayload> CODEC = class_9139.method_56431((Object)new ReloadChunkDebugPayload());

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    private record StopChunkInfoPayload() implements class_8710
    {
        public static final class_8710.class_9154<StopChunkInfoPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"chunk_debug:stop"));
        public static final class_9139<class_2540, StopChunkInfoPayload> CODEC = class_9139.method_56431((Object)new StopChunkInfoPayload());

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    private record SetChunkDimensionPayload(class_5321<class_1937> dimension) implements class_8710
    {
        public static final class_8710.class_9154<SetChunkDimensionPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"chunk_debug:set_dimension"));
        public static final class_9139<class_2540, SetChunkDimensionPayload> CODEC = class_9139.method_56438(SetChunkDimensionPayload::write, SetChunkDimensionPayload::new);

        public SetChunkDimensionPayload(class_2540 buf) {
            this((class_5321<class_1937>)buf.method_44112(class_7924.field_41223));
        }

        public void write(class_2540 buf) {
            buf.method_44116(this.dimension);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    private record BatchedChunkInfoPayload(class_5321<class_1937> world, List<ChunkInfo> infos) implements class_8710
    {
        public static final class_8710.class_9154<BatchedChunkInfoPayload> ID = new class_8710.class_9154(class_2960.method_60654((String)"chunk_debug:batched_chunk_info"));
        public static final class_9139<class_2540, BatchedChunkInfoPayload> CODEC = class_9139.method_56438(BatchedChunkInfoPayload::write, BatchedChunkInfoPayload::read);

        public void write(class_2540 buf) {
            int size = this.infos.size();
            long[] chunkPositions = new long[size];
            byte[] levels = new byte[size];
            byte[] statuses = new byte[size];
            byte[] tickets = new byte[size];
            int i = 0;
            for (ChunkInfo info : this.infos) {
                chunkPositions[i] = info.position();
                levels[i] = (byte)info.level().ordinal();
                statuses[i] = (byte)info.status().ordinal();
                tickets[i] = (byte)info.ticket().ordinal();
                ++i;
            }
            buf.method_10804(size);
            buf.method_10789(chunkPositions);
            buf.method_10813(levels);
            buf.method_10813(statuses);
            buf.method_10813(tickets);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }

        public static BatchedChunkInfoPayload read(class_2540 buf) {
            int size = buf.method_10816();
            long[] chunkPositions = buf.method_10801(new long[size]);
            byte[] levelTypes = buf.method_10803(size);
            byte[] statusTypes = buf.method_10803(size);
            byte[] ticketTypes = buf.method_10803(size);
            class_5321 world = buf.method_44112(class_7924.field_41223);
            ArrayList<ChunkInfo> infos = new ArrayList<ChunkInfo>();
            for (int i = 0; i < size; ++i) {
                long position = chunkPositions[i];
                ChunkLevel chunkType = ChunkLevel.decodeChunkType(levelTypes[i]);
                ChunkTicket ticketType = ChunkTicket.decodeTicketType(ticketTypes[i]);
                ChunkStatus status = ChunkStatus.decodeChunkStatus(statusTypes[i]);
                infos.add(new ChunkInfo(position, chunkType, status, ticketType));
            }
            return new BatchedChunkInfoPayload((class_5321<class_1937>)world, infos);
        }
    }
}

